/*
 * Copyright (c) 2009 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Walter Guerra <walter.guerra@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */
 
#ifndef __NM_VNC_SETUP_H__
#define __NM_VNC_SETUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"

G_BEGIN_DECLS

#define NM_VNC_SETUP_TYPE            (nm_vnc_setup_get_type ())
#define NM_VNC_SETUP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_VNC_SETUP_TYPE, NmVncSetup))
#define NM_VNC_SETUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_VNC_SETUP_TYPE, NmVncSetupClass))
#define IS_NM_VNC_SETUP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_VNC_SETUP_TYPE))
#define IS_NM_VNC_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_VNC_SETUP_TYPE))
#define NM_VNC_SETUP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_VNC_SETUP_TYPE, NmVncSetupClass))

typedef struct _NmVncSetup      NmVncSetup;
typedef struct _NmVncSetupClass NmVncSetupClass;

struct _NmVncSetupClass
{
    NmConnWidgetClass parent_class;
};

struct _NmVncSetup
{
    NmConnWidget parent;
};

GType       nm_vnc_setup_get_type (void);
GtkWidget*  nm_vnc_setup_new      (gchar *env);
void        nm_vnc_setup_enable (NmVncSetup *self, gboolean enable);
gboolean    nm_vnc_setup_is_enabled (NmVncSetup *);
gboolean    vnc_setup_check_enabled (NmVncSetup *);
void        nm_vnc_setup_fill_widget(NmVncSetup *self);
gboolean    nm_vnc_setup_apply_changes (NmConnWidget *);
gboolean    nm_vnc_setup_activate_environment (gchar *);
void        nm_vnc_setup_save_changes (NmVncSetup *);

G_END_DECLS

#endif
