/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Marcos Morais   <morais@dee.ufcg.edu.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#include <glib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "nm_log.h"

#define NM_LOG_FILE "/tmp/conn_manager_log"

static gint log_file = 0;

void
nm_log_init (void)
{

    log_file = open (NM_LOG_FILE, O_RDWR | O_CREAT | O_TRUNC);
}

void
nm_log_close (void)
{
    if (log_file != 0) {
        close (log_file);
        log_file = 0;
    }
}

void
nm_log (gchar* msg)
{
    write (log_file, msg, strlen(msg));
}

