/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *          Andre Rodrigues <andre.rodrigues@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef NM_BT_UTILS_H
#define NM_BT_UTILS_H

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <stdbool.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

G_BEGIN_DECLS

#define DBUS_SERVICE_BLUEZ                  "org.bluez"
#define DBUS_INTERFACE_BLUEZ                "org.bluez.Manager"
#define DBUS_INTERFACE_BLUEZ_ADP            "org.bluez.Adapter"
#define DBUS_INTERFACE_BLUEZ_DEVICE         "org.bluez.Device"
#define DBUS_INTERFACE_BLUEZ_NETWORK        "org.bluez.Network"

/* bluez methods */
#define BLUEZ_GET_PROPERTIES                "GetProperties"
#define BLUEZ_SET_PROPERTY                  "SetProperty"
#define BLUEZ_LIST_DEVICES                  "ListDevices"
#define BLUEZ_FIND_DEVICE                   "FindDevice"
#define BLUEZ_CREATE_PAIRED_DEVICE          "CreatePairedDevice"
#define BLUEZ_REGISTER_AGENT                "RegisterAgent"
#define BLUEZ_DISCONNECT                    "Disconnect"
#define BLUEZ_START_DISCOVERY               "StartDiscovery"
#define BLUEZ_STOP_DISCOVERY                "StopDiscovery"
#define BLUEZ_DEFAULT_ADAPTER               "DefaultAdapter"

#define BLUEZ_CONNECT                       "Connect"


/* bluez signals */
#define BLUEZ_DEVICE_FOUND                  "DeviceFound"


/* other bluez stuff */
#define BLUEZ_NETWORK_PAN_SERVICE_UUID      "00001116-0000-1000-8000-00805f9b34fb"
#define BLUEZ_NETWORK_GN_SERVICE_UUID       "00001117-0000-1000-8000-00805F9B34FB"

#define NM_BT_UTILS_TYPE            (nm_bt_utils_get_type ())
#define NM_BT_UTILS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_BT_UTILS_TYPE, NmBtUtils))
#define NM_BT_UTILS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_BT_UTILS_TYPE, NmBtUtilsClass))
#define IS_NM_BT_UTILS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_BT_UTILS_TYPE))
#define IS_NM_BT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_BT_UTILS_TYPE))
#define NM_BT_UTILS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_BT_UTILS_TYPE, NmBtUtilsClass))

typedef struct _NmBtUtils      NmBtUtils;
typedef struct _NmBtUtilsClass NmBtUtilsClass;

struct _NmBtUtilsClass
{
    GObjectClass parent_class;
};

struct _NmBtUtils
{
    GObject parent;
};

GType       nm_bt_utils_get_type (void);
NmBtUtils*  nm_bt_utils_new      (void);

/* Bluetooth radio handling */
gboolean nm_bt_utils_radio_is_enabled (NmBtUtils *);
gboolean nm_bt_utils_radio_enable (NmBtUtils *, gboolean);

/* Network connection setup methods */
gboolean nm_bt_utils_connect (NmBtUtils *, gchar *, const gchar *);
gboolean nm_bt_utils_remove_connection (NmBtUtils *);
gboolean nm_bt_utils_has_network_connection (NmBtUtils *);
gchar* nm_bt_utils_get_network_connection_end_point (NmBtUtils *);
gboolean nm_bt_utils_is_paired (NmBtUtils *, gchar *);
gboolean nm_bt_utils_pair_device (NmBtUtils *, gchar *);

gboolean nm_bt_utils_ifup (const gchar *);
gboolean nm_bt_utils_ifdown (void);

/* Device search methods */
gboolean nm_bt_utils_start_device_discovery (NmBtUtils *);
gboolean nm_bt_utils_stop_device_discovery (NmBtUtils *);

/* PAND check utils */
gchar *nm_bt_utils_check_pand (NmBtUtils *, gchar *);

G_END_DECLS

#endif

