#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "nm_main_dialog.h"

static gboolean 
run(gpointer data) 
{

    GtkWidget *dialog;
    dialog = nm_main_dialog_new();
    
    gint type = GPOINTER_TO_INT(data);

    nm_main_dialog_run(NM_MAIN_DIALOG(dialog), type);

    /* Free the dialog (and it's children) */
    gtk_widget_destroy(GTK_WIDGET(dialog));
    
    gtk_main_quit();
    
    return FALSE;
    
}


int main(int argc, char *argv[]) {

    gtk_init (&argc, &argv);
    
    gint type = NM_CONTROL_PANEL;
    
    if (argc == 2) {
        gint tmp = atoi(argv[1]);
        if (tmp == NM_CONTROL_PANEL || tmp == NM_STATUS_MENU) {
            type = tmp;
        }
    }    
    
    gpointer p = GINT_TO_POINTER(type);
    
    g_idle_add(run, p);
    
    gtk_main ();
    
}
