/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Walter Guerra <walter.guerra@signove.com>
 *          Andre Rodrigues <andre.rodrigues@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_INTERNET_SETUP_H__
#define __NM_INTERNET_SETUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"

G_BEGIN_DECLS

#define NM_INTERNET_INTERFACE            "INTERFACE"
#define NM_INTERNET_INTERFACE_USB        "Usb"
#define NM_INTERNET_INTERFACE_BT         "Bluetooth"
#define NM_INTERNET_INTERFACE_WLAN       "Wlan"
#define NM_INTERNET_INTERFACE_WLAN_ADHOC "Wlan adhoc"
#define NM_INTERNET_INTERFACE_DEFAULT    NM_INTERNET_INTERFACE_WLAN
#define NM_INTERNET_IN_INTERFACE_USB     "INTERFACE_USB"
#define NM_INTERNET_IN_INTERFACE_WLAN    "INTERFACE_WLAN"
#define NM_INTERNET_IN_INTERFACE_BT      "INTERFACE_BT"
#define NM_INTERNET_DNS                  "DNS"
#define NM_INTERNET_DNS_DEFAULT          "208.67.222.222"

#define NM_INTERNET_SETUP_TYPE              (nm_internet_setup_get_type ())
#define NM_INTERNET_SETUP(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_INTERNET_SETUP_TYPE, NmInternetSetup))
#define NM_INTERNET_SETUP_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), NM_INTERNET_SETUP_TYPE, NmInternetSetupClass))
#define IS_NM_INTERNET_SETUP(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_INTERNET_SETUP_TYPE))
#define IS_NM_INTERNET_SETUP_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_INTERNET_SETUP_TYPE))
#define NM_INTERNET_SETUP_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_INTERNET_SETUP_TYPE, NmInternetSetupClass))

typedef struct _NmInternetSetup      NmInternetSetup;
typedef struct _NmInternetSetupClass NmInternetSetupClass;

struct _NmInternetSetupClass
{
    NmConnWidgetClass parent_class;
};

struct _NmInternetSetup
{
    NmConnWidget parent;
};

GType       nm_internet_setup_get_type (void);
GtkWidget*  nm_internet_setup_new      (gchar *env);
void nm_internet_setup_fill_widget(NmInternetSetup *);
gboolean nm_internet_setup_apply_changes(NmConnWidget *);
gboolean nm_internet_setup_activate_environment (gchar *);
void nm_internet_setup_save_changes (NmInternetSetup *);

G_END_DECLS

#endif
