#ifndef QOSSOABOOKDIALOG_H
#define QOSSOABOOKDIALOG_H

#include <libosso-abook/osso-abook.h>
#include <QObject>
#include <QStringList>

class QOssoABookDialog : public QObject
{
    Q_OBJECT
public:
    explicit QOssoABookDialog(QObject *parent = 0);
    /*
        selectedContacts is a QStringList of contact UID.
        These are shown as "selected" in the contact chooser.
     */
    static QStringList contactChooser(const QString& windowTitle,
                                      OssoABookCapsFlags caps = OSSO_ABOOK_CAPS_ALL,
                                      OssoABookContactOrder order = OSSO_ABOOK_CONTACT_ORDER_NAME,
                                      unsigned int lower_limit = 1, // Choose at least 1
                                      unsigned int upper_limit = 1, // Choose at most 1
                                      QStringList *selectedContacts = 0);
    static void contactEditor(const QString& id);
    static OssoABookContact *lookup(const QString& id);

signals:

public slots:

};

#endif // QOSSOABOOKDIALOG_H
