#ifndef WIDGET_H
#define WIDGET_H

#include <QtCore>
#include <QtGui>

#include "settingsdialog.h"

namespace Ui {
    class Widget;
}

class Widget : public QWidget
{
    Q_OBJECT

public:
    explicit Widget(QWidget *parent = 0);
    ~Widget();


public slots:
    void showSettingsDialog();


private:
    Ui::Widget *ui;
    int gradientWidth;
    QColor startingColor;
    int startingColorAlphaValue;
    QColor endingColor;
    int endingColorAlphaValue;
    int buttonsHeight;


    void readSettings();


private slots:
    void on_playButton_clicked();
    void on_pauseButton_clicked();
    void on_nextButton_clicked();
    void on_prevButton_clicked();
    void on_startButton_clicked();
    void settingsChanged();


protected:
    void paintEvent(QPaintEvent *);
};

#endif // WIDGET_H
