#include "widget.h"
#include "ui_widget.h"

Widget::Widget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Widget)
{
    ui->setupUi(this);

    readSettings();

    this->setAttribute(Qt::WA_TranslucentBackground);
    //setFont(QFont("Nokia Sans", 12));
    adjustSize();
}

Widget::~Widget()
{
    delete ui;
}

void Widget::paintEvent(QPaintEvent *event)
{
    QLinearGradient gradient(gradientWidth, 10, 0, 10);
    gradient.setColorAt(0, startingColor);
    gradient.setColorAt(1, endingColor);
    QPainter p(this);
    p.setBrush(gradient);
    p.setPen(Qt::NoPen);
    p.drawRoundedRect(rect(), 0, 0);
    p.end();

    QWidget::paintEvent(event);
}

void Widget::on_playButton_clicked()
{
    if ( ui->multimediaButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.resume");
    }

    if ( ui->somePlayerButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=ru.somebody.someplayer / ru.somebody.someplayer.toggle");
    }

    if ( ui->internetPushButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=it.ggiovanni.internetradioplayer /it/ggiovanni/internetradioplayer it.ggiovanni.internetradioplayer.play");
    }
}

void Widget::on_pauseButton_clicked()
{
    if ( ui->multimediaButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.pause");
    }

    if ( ui->somePlayerButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=ru.somebody.someplayer / ru.somebody.someplayer.toggle");
    }

    if ( ui->internetPushButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=it.ggiovanni.internetradioplayer /it/ggiovanni/internetradioplayer it.ggiovanni.internetradioplayer.stop");
    }
}

void Widget::on_nextButton_clicked()
{
    if ( ui->multimediaButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.next");
    }

    if ( ui->somePlayerButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=ru.somebody.someplayer / ru.somebody.someplayer.next");
    }

    if ( ui->internetPushButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=it.ggiovanni.internetradioplayer /it/ggiovanni/internetradioplayer it.ggiovanni.internetradioplayer.next");
    }
}

void Widget::on_prevButton_clicked()
{

    if ( ui->multimediaButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.previous");
    }

    if ( ui->somePlayerButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=ru.somebody.someplayer / ru.somebody.someplayer.prev");
    }

    if ( ui->internetPushButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=it.ggiovanni.internetradioplayer /it/ggiovanni/internetradioplayer it.ggiovanni.internetradioplayer.prev");
    }
}

void Widget::on_startButton_clicked()
{
    if ( ui->multimediaButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.play");
    }

    if ( ui->somePlayerButton->isChecked() )
    {
        QProcess process;
        process.start("pgrep someplayer");
        process.waitForFinished();

        if ( process.canReadLine() )
        {
            //An istance of someplayer is already running
            return;
        }
        else
        {
            process.startDetached("/opt/someplayer/bin/someplayer");
        }

    }

    if ( ui->internetPushButton->isChecked() )
    {
        QProcess process;
        process.startDetached("dbus-send --type=method_call --dest=it.ggiovanni.internetradioplayer /it/ggiovanni/internetradioplayer it.ggiovanni.internetradioplayer.top_application");
    }
}

void Widget::showSettingsDialog()
{
    SettingsDialog* dialog = new SettingsDialog();
    connect(dialog, SIGNAL(saveButtonClicked()), this, SLOT(settingsChanged()));
    dialog->exec();
}

void Widget::settingsChanged()
{
    readSettings();
    repaint();
    adjustSize();
}

void Widget::readSettings()
{
    QSettings settings("packedmediawidget", "settings");

    gradientWidth = settings.value("gradientWidth", 40).toInt();

    if ( settings.contains("startingColor") )
    {
        QVariant variant;
        variant = settings.value("startingColor");
        startingColor = variant.value<QColor>();
    }
    else
    {
        startingColor = QColor( 0, 0, 0, 100);
    }

    if ( settings.contains("endingColor") )
    {
        QVariant variant;
        variant = settings.value("endingColor");
        endingColor = variant.value<QColor>();
    }
    else
    {
        endingColor = QColor( 0, 0, 0, 0);
    }

    startingColorAlphaValue = settings.value("startingColorAlphaValue", 100).toInt();
    endingColorAlphaValue = settings.value("endingColorAlphaValue", 0).toInt();

    buttonsHeight = settings.value("buttonsHeight", 83).toInt();
    ui->nextButton->setFixedHeight(buttonsHeight);
    ui->prevButton->setFixedHeight(buttonsHeight);
    ui->playButton->setFixedHeight(buttonsHeight);
    ui->pauseButton->setFixedHeight(buttonsHeight);
    ui->startButton->setFixedHeight(buttonsHeight);
    ui->multimediaButton->setFixedHeight(buttonsHeight);
    ui->somePlayerButton->setFixedHeight(buttonsHeight);
    ui->internetPushButton->setFixedHeight(buttonsHeight);

    adjustSize();
}
