#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtCore>
#include <QtGui>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

public slots:


signals:
    void saveButtonClicked();

private slots:
    void on_changeStartingColorButton_clicked();
    void on_changeEndingColorButton_clicked();
    void on_saveButton_clicked();

    void on_startingColorAlphaValueSlider_valueChanged(int value);

    void on_endingColorAlphaValueSlider_valueChanged(int value);

private:
    Ui::SettingsDialog *ui;

    int gradientWidth;
    QColor startingColor;
    int startingColorAlphaValue;
    QColor endingColor;
    int endingColorAlphaValue;
    int buttonsHeight;

    void readSettings();
    void saveSettings();
    void updateColorsIcons();
    void updateSliders();
};

#endif // SETTINGSDIALOG_H
