#ifndef PACKAGE_H
#define PACKAGE_H

/*
  PackageView - Show debian package details
  Copyright (C) 2008  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <apt-pkg/pkgcache.h>

#include <Lum/Model/Table.h>

class Package
{
private:
  std::wstring         name;
  std::wstring         version;
  std::wstring         section;
  std::wstring         shortDesc;
  std::wstring         longDesc;
  std::wstring         maintainer;
  std::wstring         homepage;
  std::wstring         dependencies;
  pkgCache::State::PkgCurrentState state;
  size_t               size;
  size_t               installedSize;

public:
  Package();
  virtual ~Package();

  void         SetName(const std::wstring& name);
  std::wstring GetName() const;

  void         SetVersion(const std::wstring& version);
  std::wstring GetVersion() const;

  void         SetSection(const std::wstring& section);
  std::wstring GetSection() const;

  void         SetShortDescription(const std::wstring& shortDescription);
  std::wstring GetShortDescription() const;

  void         SetDescription(const std::wstring& description);
  std::wstring GetDescription() const;

  void         SetMaintainer(const std::wstring& maintainer);
  std::wstring GetMaintainer() const;

  void         SetHomepage(const std::wstring& homepage);
  std::wstring GetHomepage() const;

  void         SetDependencies(const std::wstring& dependencies);
  std::wstring GetDependencies() const;

  void         SetState(pkgCache::State::PkgCurrentState state);

  void         SetPackageSize(size_t packageSize);
  size_t       GetPackageSize() const;

  void         SetInstalledSize(size_t installedSize);
  size_t       GetInstalledSize() const;

  bool         LoadPackageContent(std::list<std::wstring>& content);
};

class PackageEntry
{
private:
          Package     *package;
  mutable Lum::Object *nameObject;

public:
  PackageEntry(Package* package);
  virtual ~PackageEntry();

  Lum::Object* GetObject(size_t column) const;
  std::wstring GetString(size_t column) const;

  Package* GetPackage() const;
};

#endif

