/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Package.h"

#include <Lum/Image.h>
#include <Lum/Panel.h>
#include <Lum/Text.h>

#include "Globals.h"

Package::Package(const std::wstring& name,
                 const std::wstring& version,
                 const std::wstring& description,
                 int score)
: name(name),
  version(version),
  description(description),
  score(score)/*,
  nameObject(NULL),
  ratingObject(NULL)*/
{
  // no code
}

Package::~Package()
{
  //delete nameObject;
}

std::wstring Package::GetName() const
{
  return name;
}

std::wstring Package::GetVersion() const
{
  return version;
}

std::wstring Package::GetDescription() const
{
  return description;
}

int Package::GetScore() const
{
  return score;
}

void Package::UpdateScore(int score)
{
  this->score=score;
}

