#include <mozilla-config.h>
#include <npapi.h>
#include <npfunctions.h>
#include <npruntime.h>

#include <sys/io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifndef DO_NOT_USE_GLIB
#include <glib.h>
#endif

#define DATA_FILE "/opt/ovi-maps-cnfix/offset.dat"

#undef  STRINGZ_TO_NPVARIANT
#define STRINGZ_TO_NPVARIANT(_val, _v)                                        \
NP_BEGIN_MACRO                                                                \
    (_v).type = NPVariantType_String;                                         \
    NPString str = { _val, (uint32_t)strlen(_val) };                          \
    (_v).value.stringValue = str;                                             \
NP_END_MACRO

#define NP_STRING_GET_UTF8STRING(_np_s)     (_np_s.UTF8Characters)
#define NP_STRING_GET_LENGTH(_np_s)     (_np_s.UTF8Length)

static NPNetscapeFuncs* browser = NULL;
static const char *plugin_method_name = "voice";
static const char *plugin_method_offset = "offset";

#define plugin_version  "0.0.1"
#define plugin_copyright "Copyleft © 2012 eveing@139.com"

typedef struct
{
	char *key;
	char *value;
}StringKeyValue;

static StringKeyValue static_propertys[]=
{
	{
		.key = "version",
		.value = plugin_version,
	},
	{
		.key = "copyright",
		.value = plugin_copyright,
	},
	{NULL}
};

//Functions for scriptablePluginClass
bool plugin_has_method(NPObject *obj, NPIdentifier methodName);
bool plugin_invoke(NPObject *obj, NPIdentifier methodName, const NPVariant *args, uint32_t argCount, NPVariant *result);
bool plugin_invoke_default(NPObject *npobj,
                           const NPVariant *args,
                           uint32_t argCount,
                           NPVariant *result);
bool hasProperty(NPObject *obj, NPIdentifier propertyName);
bool getProperty(NPObject *obj, NPIdentifier propertyName, NPVariant *result);
////////////////////////////////////

static struct NPClass scriptablePluginClass = {
    NP_CLASS_STRUCT_VERSION,
    NULL,
    NULL,
    NULL,
    plugin_has_method,
    plugin_invoke,
    plugin_invoke_default,
    hasProperty,
    getProperty,
    NULL,
    NULL,
};


//#define __debug__

#ifdef XP_WIN
#define LOGFILE "C:\\tmp\\browser_plugin.log"
#else
#define LOGFILE "/tmp/browser_plugin.log"
#endif ///XP_WIN

#ifdef __debug__
static FILE *logfp = NULL;

#define OPENLOG  {if(logfp == NULL)logfp = fopen(LOGFILE,"a+");/*if(logfp == NULL)exit(0);*/}
#define CLOSELOG  {if(logfp)fclose(logfp);}
#define logmsg(...) { \
            if(logfp){\
                fprintf(logfp,"%s:%d:%s:", __FILE__, __LINE__,__func__);\
                fflush(logfp);\
                fprintf(logfp,">>"__VA_ARGS__);\
                fprintf(logfp,"\n"); \
                fflush(logfp);\
                } \
            }
#else
#define OPENLOG
#define CLOSELOG
#define logmsg(...)
#endif

NPError _NP_GetEntryPoints(NPPluginFuncs* pluginFuncs);
NPError _NP_Initialize(NPNetscapeFuncs* browserFuncs);

/* 纠偏算法实现 */

#define RECORDCOUNT 98648
#define RECORDLENGTH 8
#define ZOOM 18

typedef struct {
        int16_t lon;
        int16_t lat;
        int16_t x_off;
        int16_t y_off;
} offDat;

typedef struct {
        int16_t lng;
        int16_t lat;
        int16_t x0;
        int16_t y0;
        int16_t x1;
        int16_t y1;
        int16_t x2;
        int16_t y2;
        int16_t x3;
        int16_t y3;
} GeoPoint;

static GeoPoint *lastPos = NULL;
static FILE *mapOffsetDataFile=NULL;
static void offset_init() {
        lastPos=malloc(sizeof(GeoPoint));
        memset(lastPos,0,sizeof(GeoPoint));
        mapOffsetDataFile=fopen(DATA_FILE,"rb");
        if(mapOffsetDataFile==NULL){
            logmsg("Cant open data!");
        }
}
static void offset_exit() {
        if(mapOffsetDataFile!=NULL){
            fclose(mapOffsetDataFile);
        }
        free(lastPos);
}

static double lngToPixel(double lng) {

      return (lng + 180) * (256L << ZOOM) / 360;
}
static double pixelToLng(double pixelX) {

      return pixelX * 360 / (256L << ZOOM) - 180;
}

static double latToPixel(double lat) {

      double siny = sin(lat * M_PI / 180);
      double y = log((1 + siny) / (1 - siny));
      return (128 << ZOOM) * (1 - y / (2 * M_PI));
}

static double pixelToLat(double pixelY) {

      double y = 2 * M_PI * (1 - pixelY / (128 << ZOOM));
      double z = pow(M_E, y);
      double siny = (z - 1) / (z + 1);
      return asin(siny) * 180 / M_PI;
}
static void getOffsetFromFile(int16_t lng, int16_t lat, offDat *offsetData) {
            int left = 0;
            int right = RECORDCOUNT;
            long queryValue=(long)lat+((long)lng<<16);
            while (left <= right)
            {
                int middle = (int)floor((left + right) / 2.0);
                fseek(mapOffsetDataFile, middle*RECORDLENGTH, SEEK_SET);
                fread(offsetData,sizeof(offDat),1,mapOffsetDataFile);
                long middleValue =offsetData->lat+((long)(offsetData->lon)<<16);
                if(queryValue==middleValue){
                    return;
                }
                if (queryValue>middleValue)
                {
                    left = middle + 1;
                }
                else
                {
                    right = middle - 1;
                }
            }
       offsetData->x_off=0;
       offsetData->y_off=0;
       return ;
}

static void getMarsOffset(double lng, double lat, double *lngOffset, double *latOffset)
{
        double mo0_lat,mo0_lng,mo1_lat,mo1_lng,mo2_lat,mo2_lng,mo3_lat,mo3_lng;
        double latConvert = lat * 10;
        double lngConvert = lng * 10;

        int16_t x0 = (int16_t)latConvert, y0 = (int16_t)lngConvert;
        int16_t x1 = x0, y1 = y0+1;
        int16_t x2 = x0+1, y2 = y1;
        int16_t x3 = x2, y3 = y0;

        if((int16_t)latConvert != lastPos->lat || (int16_t)lngConvert != lastPos->lng){
            offDat off0 = {0,0,0,0};
            offDat off1 = {0,0,0,0};
            offDat off2 = {0,0,0,0};
            offDat off3 = {0,0,0,0};
            lastPos->lat=(int16_t)latConvert;
            lastPos->lng=(int16_t)lngConvert;
            getOffsetFromFile(y0*10, x0*10, &off0);
            lastPos->x0 = off0.x_off;
            lastPos->y0 = off0.y_off;
            getOffsetFromFile(y1*10, x1*10, &off1);
            lastPos->x1 = off1.x_off;
            lastPos->y1 = off1.y_off;
            getOffsetFromFile(y2*10, x2*10, &off2);
            lastPos->x2 = off2.x_off;
            lastPos->y2 = off2.y_off;
            getOffsetFromFile(y3*10, x3*10, &off3);
            lastPos->x3 = off3.x_off;
            lastPos->y3 = off3.y_off;
        }
        mo0_lng=pixelToLng(lngToPixel(lng)+lastPos->x0);
        mo0_lat=pixelToLat(latToPixel(lat)+lastPos->y0);
        mo1_lng=pixelToLng(lngToPixel(lng)+lastPos->x1);
        mo1_lat=pixelToLat(latToPixel(lat)+lastPos->y1);
        mo2_lng=pixelToLng(lngToPixel(lng)+lastPos->x2);
        mo2_lat=pixelToLat(latToPixel(lat)+lastPos->y2);
        mo3_lng=pixelToLng(lngToPixel(lng)+lastPos->x3);
        mo3_lat=pixelToLat(latToPixel(lat)+lastPos->y3);

        //计算纠偏点影响系数

        double coef0 = (x2 - latConvert) * (y2 - lngConvert);
        double coef1 = (x3 - latConvert) * (lngConvert - y3);
        double coef2 = (latConvert - x0) * (lngConvert - y0);
        double coef3 = (latConvert - x1) * (y1 - lngConvert);

        *latOffset = mo0_lat * coef0 + mo1_lat * coef1 + mo2_lat * coef2 + mo3_lat * coef3;
        *lngOffset = mo0_lng * coef0 + mo1_lng * coef1 + mo2_lng * coef2 + mo3_lng * coef3;
}

//接口的实现
#ifdef XP_MACOSX

#else

NPError NP_Initialize(NPNetscapeFuncs* browserFuncs,NPPluginFuncs* pluginFuncs)
{
    _NP_Initialize(browserFuncs);
    _NP_GetEntryPoints(pluginFuncs);
    return NPERR_NO_ERROR;
}

#endif ///XP_MACOSX

NPError _NP_Initialize(NPNetscapeFuncs* browserFuncs)
{

    NPError err = NPERR_NO_ERROR;

    browser = browserFuncs;
    OPENLOG
    logmsg("");
    /* 初始化纠偏数据库 */
    offset_init();

    return err;
}

char*
NP_GetMIMEDescription()
{
    OPENLOG
    logmsg("");
    return "map/plug:xx:browser call aplay";
}

NPError _NP_GetEntryPoints(NPPluginFuncs* pluginFuncs)
{
    pluginFuncs->version = 1;
    pluginFuncs->size = sizeof(pluginFuncs);
    pluginFuncs->newp = NPP_New;
    pluginFuncs->destroy = NPP_Destroy;
    pluginFuncs->setwindow = NPP_SetWindow;
    pluginFuncs->newstream = NPP_NewStream;
    pluginFuncs->destroystream = NPP_DestroyStream;
    pluginFuncs->asfile = NPP_StreamAsFile;
    pluginFuncs->writeready = NPP_WriteReady;
    pluginFuncs->write = (NPP_WriteProcPtr)NPP_Write;
    pluginFuncs->print = NPP_Print;
    pluginFuncs->event = NPP_HandleEvent;
    pluginFuncs->urlnotify = NPP_URLNotify;
    pluginFuncs->getvalue = NPP_GetValue;
    pluginFuncs->setvalue = NPP_SetValue;
    logmsg("");
    return NPERR_NO_ERROR;
}

NPError
NP_GetValue (void *future,
	     NPPVariable variable,
	     void *value)
{
    logmsg("NPPVariable:%d",variable);
    if(value == NULL)
        { return NPERR_INVALID_PARAM; }

    return NPP_GetValue(future,variable,value);
}

NPError NP_Shutdown()
{
    logmsg("\n\n");
    browser = NULL;
    offset_exit();
    CLOSELOG
    return NPERR_NO_ERROR;
}

bool plugin_has_method(NPObject *obj, NPIdentifier methodName)
{
    // This function will be called when we invoke method on this plugin elements.
    NPUTF8 *name = browser->utf8fromidentifier(methodName);
    bool result;
    result = strcmp(name, plugin_method_name) == 0;
    if(!result){
       result = strcmp(name, plugin_method_offset) == 0;
    }
    logmsg("method:%s",name);
    browser->memfree(name);
    return result;
}

bool plugin_invoke(NPObject *obj, NPIdentifier methodName, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
    bool ret = true;
    NPUTF8 *name = browser->utf8fromidentifier(methodName);
    logmsg("Invokeing %s",name);
    if(strcmp(name, plugin_method_name) == 0) {
        int status = -1;
        char *play = NULL;
//        char ** argv = malloc(sizeof(char *)*(argCount+1));
        if(NPVARIANT_IS_STRING(args[0])){
            NPString str = NPVARIANT_TO_STRING(args[0]);
            play = malloc(9+str.UTF8Length);
            if(!play){
                return false;
            }
            memset(play,0,9+str.UTF8Length);
            strcat(play,"aplay ");
            //epiphany-browser do not terminating with '\0',so it's evil.
            strcat(play, (const char *)NP_STRING_GET_UTF8STRING(str));
            strcat(play, " &");
            logmsg("argv[%d]=%s",0,play);
#if 0 //def  __G_LIB_H__
        status = g_spawn_async("/tmp",argv,NULL,G_SPAWN_SEARCH_PATH,NULL,NULL,NULL,NULL);
        BOOLEAN_TO_NPVARIANT(status,*result);
#else
        status = system(play);
#endif ///__G_LIB_H__
            free(play);
        }
        INT32_TO_NPVARIANT(status,*result);
    }else if(strcmp(name, plugin_method_offset) == 0) {
      if(NPVARIANT_IS_DOUBLE(args[0])){
        double _offset_lat=0, _offset_lon=0;
        double lat = NPVARIANT_TO_DOUBLE(args[0]);
        double lon = NPVARIANT_TO_DOUBLE(args[1]);
        if(mapOffsetDataFile != NULL){
            getMarsOffset(lon, lat, &_offset_lon, &_offset_lat);
            if(_offset_lat != 0 && _offset_lat != 0){
                _offset_lat-=lat;
                _offset_lon-=lon;
            }
        }
        char *s = (char *)browser->memalloc(40);
        sprintf(s,"%3.12lf,%3.12lf",_offset_lat,_offset_lon);
        STRINGZ_TO_NPVARIANT(s, *result);
      }
    }else{
        ret = false;
        BOOLEAN_TO_NPVARIANT(ret,*result);
    }
    browser->memfree(name);
    logmsg("invoked");
    return ret;
}

bool plugin_invoke_default(NPObject *npobj,
                           const NPVariant *args,
                           uint32_t argCount,
                           NPVariant *result)
{
    int i;
    logmsg("come");
    for(i = 0;i<argCount;i++){
        NPVariant var;
        var = args[i];
        if(NPVARIANT_IS_VOID(var)){
            logmsg("%-3d VOID",i);
        }else if(NPVARIANT_IS_NULL(var)){
            logmsg("%-3d NULL",i);
        }else if(NPVARIANT_IS_BOOLEAN(var)){
            logmsg("%-3d bool(%s)",i,NPVARIANT_TO_BOOLEAN(var)?"true":"false");
        }else if(NPVARIANT_IS_INT32(var)){
             logmsg("%-3d int32(%d)",i,NPVARIANT_TO_INT32(var));
        }else if(NPVARIANT_IS_DOUBLE(var)){
            logmsg("%-3d double(%f)",i,NPVARIANT_TO_DOUBLE(var));
        }else if(NPVARIANT_IS_STRING(var)){
            logmsg("%-3d string(%s)",i,NP_STRING_GET_UTF8STRING(NPVARIANT_TO_STRING(var)));
        }else if(NPVARIANT_IS_OBJECT(var)){
            logmsg("%-3d Object(%p)",i,NPVARIANT_TO_OBJECT(var));
        }
    }
    logmsg("return")
    return false;
}

bool hasProperty(NPObject *obj, NPIdentifier propertyName)
{
    int i;
    bool ret = false;

    NPUTF8 *name = browser->utf8fromidentifier(propertyName);
    logmsg("%s",name);
    for(i=0;static_propertys[i].key;i++){
        ret = (strcmp(static_propertys[i].key,name) == 0);
        logmsg("%s",static_propertys[i].key);
        if(ret)
            break;
    }
    browser->memfree(name);
    logmsg("");
    return ret;
}

bool getProperty(NPObject *obj, NPIdentifier propertyName, NPVariant *result)
{
    int i;
    bool ret = false;

    NPUTF8 *name = browser->utf8fromidentifier(propertyName);
    logmsg("%s",name);
    for(i=0;static_propertys[i].key;i++){
        ret = (strcmp(static_propertys[i].key,name) == 0);
        logmsg("%s",static_propertys[i].key);
        if(ret){
            NPUTF8 *ret_str = g_strdup(static_propertys[i].value);
            STRINGZ_TO_NPVARIANT(ret_str,*result);
            break;
        }
    }
    browser->memfree(name);
    logmsg("");
    return ret;
}

//NPP Functions Implements
NPError NPP_New(NPMIMEType pluginType, NPP instance, uint16_t mode, int16_t argc, char* argn[], char* argv[], NPSavedData* saved)
{
    logmsg("mimetype:%s",pluginType);
    if(!instance->pdata) {
        instance->pdata = browser->createobject(instance, &scriptablePluginClass);
    }
    logmsg("");
    return NPERR_NO_ERROR;
}

NPError NPP_Destroy(NPP instance, NPSavedData** save)
{
    // If we created a plugin instance, we'll destroy and clean it up.
    NPObject *pluginInstance=instance->pdata;
    if(pluginInstance) {
        browser->releaseobject(pluginInstance);
        instance->pdata = NULL;
    }
    logmsg("");
    return NPERR_NO_ERROR;
}

NPError NPP_SetWindow(NPP instance, NPWindow* window)
{
    logmsg("");
    return NPERR_NO_ERROR;
}

NPError NPP_NewStream(NPP instance, NPMIMEType type, NPStream* stream, NPBool seekable, uint16_t* stype)
{
    *stype = NP_ASFILEONLY;
    logmsg("");
    return NPERR_NO_ERROR;
}

NPError NPP_DestroyStream(NPP instance, NPStream* stream, NPReason reason)
{
    logmsg("");
    return NPERR_NO_ERROR;
}

int32_t NPP_WriteReady(NPP instance, NPStream* stream)
{
    logmsg("");
    return 0;
}

int32_t NPP_Write(NPP instance, NPStream* stream, int32_t offset, int32_t len, void* buffer)
{
    logmsg("");
    return 0;
}

void NPP_StreamAsFile(NPP instance, NPStream* stream, const char* fname)
{
    logmsg("");
}

void NPP_Print(NPP instance, NPPrint* platformPrint)
{
    logmsg("");
}


int16_t NPP_HandleEvent(NPP instance, void* event)
{
    logmsg("");
    return 0;
}

void NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
    logmsg("");
}

NPError NPP_GetValue(NPP instance, NPPVariable variable, void *value)
{
    NPObject *pluginInstance = NULL;
    NPError ret = NPERR_NO_ERROR;

    if(instance)
        pluginInstance = instance->pdata;
    logmsg("variable:%d",variable);
    switch(variable) {
    case NPPVpluginNameString:
        *((char **)value) = "Ovi Maps plugin" plugin_version;
    break;
    case NPPVpluginDescriptionString:
        *((char **)value) = "Map coordiantes corrective and voice expansion";
    break;
    case NPPVpluginNeedsXEmbed:
        *((NPBool *)value) = TRUE;
    break;
    case NPPVpluginScriptableIID:
    case NPPVpluginScriptableInstance:
        /* XPCOM scripting, obsolete */
        ret = NPERR_GENERIC_ERROR;
    break;
    case NPPVpluginScriptableNPObject:
        // If we didn't create any plugin instance, we create it.
        if (pluginInstance) {
            browser->retainobject(pluginInstance);
            *((NPObject **)value) = pluginInstance;
        }else{
            ret = NPERR_GENERIC_ERROR;
        }
    break;
    default:
        logmsg("Unhandled variable %d instance %p", variable, pluginInstance);
        ret = NPERR_INVALID_PARAM;
    }
    return ret;
}

NPError NPP_SetValue(NPP instance, NPNVariable variable, void *value)
{
    logmsg("");
    return NPERR_GENERIC_ERROR;
}
