/*
 * This file is part of osso-abook-plugin-merge-contacts
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 * 
 */

#include "sort.h"
#include "appdata.h"


int sort_by_name_asc_cb(const OssoABookListStoreRow *row_a,
		    const OssoABookListStoreRow *row_b,
		    gpointer user_data) 
{
    OssoABookContact *c_1 = row_a->contact;
    OssoABookContact *c_2 = row_b->contact;
    gchar *n_1 = osso_abook_contact_get_name(c_1);
    gchar *n_2 = osso_abook_contact_get_name(c_2);

    printf("from sort_by_name_asc_cb\n");

    return -g_strcmp0(n_1, n_2);
}

GList *create_sorts() {
    GList *result = NULL;

    // Sort by name;
    Sort *sort_by_name = g_new0(Sort, 1);
    sort_by_name->display_name = g_strdup("Sort By Name");
    sort_by_name->order = OSSO_ABOOK_CONTACT_ORDER_NAME;
    result = g_list_append(result, sort_by_name);

    // Sort by presence;
    Sort *sort_by_presence = g_new0(Sort, 1);
    sort_by_presence->display_name = g_strdup("Sort By Presence");
    sort_by_presence->order = OSSO_ABOOK_CONTACT_ORDER_PRESENCE;
    result = g_list_append(result, sort_by_presence);

    // Sort by name;
    Sort *sort_by_name_asc = g_new0(Sort, 1);
    sort_by_name_asc->display_name = g_strdup("Sort By Name A");
    sort_by_name_asc->order = OSSO_ABOOK_CONTACT_ORDER_CUSTOM;
    sort_by_name_asc->callback = sort_by_name_asc_cb;

    result = g_list_append(result, sort_by_name_asc);

  
    return result;
}

/**
 * Callback is called when user choose type of sort.
 */ 
static void select_sort(GtkWidget *selector, gint column, gpointer data) 
{
    GtkTreeIter iter;
    Sort *sort;
    GtkTreeModel *selector_model;

    if (hildon_touch_selector_get_selected (HILDON_TOUCH_SELECTOR (selector), 0, &iter)) {
	
	selector_model = hildon_touch_selector_get_model (HILDON_TOUCH_SELECTOR (selector), 0);
	gtk_tree_model_get (selector_model, &iter, 0, &sort, -1);
    }

    if (sort) {
	OssoABookListStore *store = data;
	if (sort->callback) {
	    printf("from not NULL\n");
	}

	if (sort->order == OSSO_ABOOK_CONTACT_ORDER_CUSTOM) {
	    printf("from OSSO_ABOOK_CONTACT_ORDER_CUSTOM\n");
	    osso_abook_list_store_set_sort_func(store, sort->callback, NULL, NULL); 
	} else {
	    osso_abook_list_store_set_contact_order(store, sort->order);

	}
    }
}

     // Selector of sort
    selector_sort = create_selector(appdata.sorts, 
		    renderer_sort_name, 
		    touch_selector_print_sort_func); 

gchar *
touch_selector_print_sort_func (HildonTouchSelector *selector, gpointer userdata) 
{
    GtkTreeIter iter;

    if (hildon_touch_selector_get_selected (HILDON_TOUCH_SELECTOR (selector), 0, &iter)) {
	Sort *sort;
	GtkTreeModel *model;
	
	model = hildon_touch_selector_get_model (HILDON_TOUCH_SELECTOR (selector), 0);
	gtk_tree_model_get (model, &iter, 0, &sort, -1);

	if (sort) {
	    return g_strdup(sort->display_name);
	}
    }

    return NULL;
}

/**
 * Renderer for selector item of sort name.
 */ 
void
renderer_sort_name (GtkTreeViewColumn *tree_column,
               GtkCellRenderer   *cell,
               GtkTreeModel      *model,
               GtkTreeIter       *iter,
               gpointer           data)
{
    Sort *sort;
    gtk_tree_model_get (model, iter, 0, &sort, -1);

    g_object_set (GTK_CELL_RENDERER (cell), "text", sort->display_name, NULL);
}
