#    Openvpn Applet
#    Copyright (C) 2008  Mikko Vartiainen <mvartiainen@gmail.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

enable_logging = True

if enable_logging:
    fd = open('/tmp/openvpn-applet.log','w+')
else:
    fd = None

import glob
import os
import string
from subprocess import Popen, PIPE, call
import gtk
import hildondesktop
import hildon
import gobject
from sets import Set
import fileinput
import re
from UserDict import UserDict

import time

def copy_file(file):
    print "Copy: ", file
    for f in file:
        if f != None:
            print f
            print file[f]
            call(['sudo','/usr/libexec/openvpn-applet-helper.py', 'copy', str(f), str(file[f])])

def delete_files(file):
    print "Delete: ", file
    for f in file:
        if f != None:
            call(['sudo','/usr/libexec/openvpn-applet-helper.py', 'delete', f])
    

def pid_exists(pid):
    try:
        os.kill(pid, 0)
        return True
    except OSError, err:
        if err.errno == 1:
            return True
        else:
            return False
    
def openvpn_running(pid):
    p = Popen("pidof openvpn", shell=True, stdout=PIPE)
    pipe = p.stdout
    s = pipe.read().split()
    p.wait()
    print s
    if s.count(str(pid)):
        return True
    else:
        return False
        
class vpn():
    def __init__(self, conf_file, conf_dir='/etc/openvpn'):
        self.conf_file = conf_file
        self.name = string.split(os.path.basename(self.conf_file),'.')[0]
        self.pid_file = '/var/run/openvpn.'+self.name+'.pid'
        self.conf_dir = conf_dir
        self.stopcmd = '/etc/init.d/openvpn'
        self.startcmd = '/usr/sbin/openvpn'
        self.log_file = '/tmp/'+self.name+'.log'
        parameters = self.__read_conf()
        print parameters
        if parameters["auth-user-pass"] == True:
            self.user_auth = True
        else:
            self.user_auth = False
        
        if parameters["askpass"] == True or parameters["auth-user-pass"] == True:
            self.pass_auth = True      
        else:
            self.pass_auth = False
        
        
    def get_status(self):
        pid = self.get_pid()
                
        if pid != None and pid_exists(pid) and openvpn_running(pid):
            #self.pid = pid
            return True
        else:
            return False
        
    def get_pid(self):
        print "pid_file: ",self.pid_file
        try:
            f = open(self.pid_file)
        except IOError:
            return None
        
        pid = int(f.readline())    
        return int(pid)
        
    def start(self,user=None,passwd=None,enable_log=False):
        command =["sudo",self.startcmd,"--daemon","--writepid",self.pid_file,"--config",self.conf_file]
        if enable_log:
            command.extend(['--log',self.log_file,'--verb','3'])
        print command
        process = Popen(command, shell=False, stdin=PIPE, stdout=None, cwd=self.conf_dir)
        input = process.stdin
              
        if self.user_required and user != None:
            print >>input,user

        if self.pass_required and passwd != None:
            print >>input,passwd

        input.close()
        
        return process.returncode
        
    def stop(self):
        print "stop"
        status = call(['sudo', self.stopcmd, 'stop', self.name])
        return status

    def get_conf_file(self):
        return self.conf_file        

    def get_name(self):
        return self.name

    def user_required(self):
        return self.user_auth
        
    def pass_required(self):
        return self.pass_auth

    def get_log_file(self):
        return self.log_file

    def __read_conf(self):
        keywords = ["askpass","auth-user-pass"]
        parameters = dict.fromkeys(keywords,False)
        
        line = None
        for line in fileinput.input(self.conf_file):
            #print "line: ", line
            #check for keywords
            s = line.split()
            if len(s) > 0:
                for word in keywords:
                    #print word
                    if word == s[0]:
                        print "MATCH: ", word,s
                        #get filename
                        if len(s) > 1:
                            filename = line.split()[1]
                            #check path
                            if os.path.exists(filename):
                                parameters[word] = filename
                            elif os.path.exists(os.path.join(self.conf_dir, filename)):
                                parameters[word] = filename
                            else:
                                parameters[word] = True
                        else:
                            parameters[word] = True

        return parameters
    
class vpn_control():
    def read_vpn_conf(self, dir, ext):
        vpn_conf = []
        for e in ext:
            l = glob.glob(dir+'/*.'+e)
            if len(l) > 0: vpn_conf.extend(l)
        return vpn_conf        
        
    def __init__(self):
        self.vpn_list = []
        for v in self.read_vpn_conf('/etc/openvpn',['conf','ovpn']):
            log(v)
            self.vpn_list.append(vpn(v))
        for v in self.read_vpn_conf('/home/user/.openvpn-applet',['conf','ovpn']):
            log(v)
            self.vpn_list.append(vpn(v,'/home/user/.openvpn-applet'))
    
    def __str__(self):
        s = ''
        for i,v in enumerate(self.vpn_list):
            if v.get_status() != True: cmd = 'start'
            else: cmd = 'stop'
            s = s+str(i+1)+'. '+v.name+' - '+cmd+'\n'
        return s   

    def start(self, index,user=None,passwd=None,enable_log=False):
        self.vpn_list[index].start(user,passwd)
        
    def stop(self, index):
        self.vpn_list[index].stop()
        
    def status(self, index):
        if len(self.vpn_list) > 0:
            return self.vpn_list[index].get_status()
        else:
            return -1

    def get_log_file(self,index):
        return self.vpn_list[index].get_log_file()

    def user_required(self,index):
        return self.vpn_list[index].user_required()
        
    def pass_required(self,index):
        return self.vpn_list[index].pass_required()
        
    def get_vpn_count(self):
        return len(self.vpn_list)

    def get_active_connections_number(self):
        active = 0
        for i,v in enumerate(self.vpn_list):
            if v.get_status(): active = active + 1
        return active

    
class openvpn_applet(hildondesktop.StatusMenuItem):
    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)
       
        self.vc = None
        self.banner = None
        self.timer = None
        self.timeout = 0
        #self.connection_text = "no connections"
        self.button_title_text = "OpenVPN"

        self.button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        #self.button.set_text(self.button_title_text, self.connection_text)
        self.button.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button.set_alignment(0.2,0.5,1,1)
        image = gtk.image_new_from_icon_name("openvpn-applet", gtk.ICON_SIZE_BUTTON)
        self.button.set_image(image)
        self.button.set_image_position(gtk.POS_LEFT)

        #self.button = gtk.Button("OpenVPN");
        self.button.connect("clicked", self.button_clicked_event)
        
        textcell = gtk.CellRendererText()
        imagecell = gtk.CellRendererPixbuf()
        
        self.combo = gtk.ComboBox()
        self.combo.pack_start(imagecell, True)
        self.combo.pack_start(textcell, True)
        self.combo.add_attribute(imagecell, 'stock-id',3)
        self.combo.add_attribute(textcell, 'text', 0)
        self.combo.connect("changed", self.combo_changed_event)

        self.add(self.button)
        self.show_all()
        self.update_list()
        self.update_button()
        #self.set_settings(True)
        #self.connect("show-settings", self.open_settings)
     
    def update_list(self,source=None):
        vpn_list = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_PYOBJECT,gobject.TYPE_STRING,gobject.TYPE_BOOLEAN)
        self.vc = vpn_control()
        if len(self.vc.vpn_list) == 0:
            #vpn_list.insert(0,("No Connections", "",None,None))
            pass
        else:
            for i,v in enumerate(self.vc.vpn_list):
                if v.get_status():
                    icon = gtk.STOCK_YES
                else:
                    icon = gtk.STOCK_NO
                vpn_list.insert(i,(v.get_name(), v.get_conf_file(),v,icon,True))
                #self.combo.insert_text(i,v.name)

        self.combo.set_model(vpn_list)
        if source == None:
            self.set_options_visible(True)
            self.combo.set_active(0)

        
        if self.vc.get_vpn_count() > 0:
            self.combo.set_active(0)
        #self.frame.check_resize()

    def set_options_visible(self,available):
        model = self.combo.get_model()
        iter = model.get_iter_first()
        if iter == None:
            if available == True:
                model.append(("Options...",None,None,None,False))
        else:    
            while model.iter_next(iter) != None:
                iter = model.iter_next(iter)
    
            if available == True:
                if model.get_value(iter,4) == True:
                    model.append(("Options...",None,None,None,False))
            else:
                if model.get_value(iter,4) == False:
                    model.remove(iter)            
    
    def get_vpn_list(self):
        return self.combo.get_model()
        
    def combo_changed_event(self,widget):
        index = self.combo.get_active()
        if index >= 0:
            if index == self.vc.get_vpn_count():
                #self.button.set_label("Open")
                pass
            elif self.vc.status(index) == False:
                #self.button.set_label("Start")
                pass
            else:
                #self.button.set_label("Stop")
                pass
    
    def button_clicked_event(self,widget):
        dlg = SelectConnectionDialog(parent=None,vpn_manager=self.vc)            
        dlg.connect("response",self.manage_connection)
        dlg.show_all()
        self.update_button()
    
    def update_button(self):
        log("update_button")
        self.timeout = self.timeout - 1
        active = self.vc.get_active_connections_number()
        if active == 1:
            self.button.set_text(self.button_title_text, str(active) + ' active connection')
        elif active > 1:
            self.button.set_text(self.button_title_text, str(active) + ' active connections')
        else:
            self.button.set_text(self.button_title_text, 'no active connections')
            
        if self.timeout > 0:
            self.timer = gobject.timeout_add(500, self.update_button)
        else:
            self.timer = None
            return False

    def settings_event(self, widget, data=None):
        widget = gtk.MenuItem("Openvpn setup")
        widget.connect("activate", self.open_settings)
        return widget
        
    def open_settings(self, widget=None, data=None):
        self.set_options_visible(False)
        dlg = OpenvpnAppletSettings(model=self.combo.get_model(), applet=self)
        dlg.run()
        dlg.destroy()
        self.set_options_visible(True)
        self.combo.set_active(0)
        self.update_button()

    def manage_connection(self, widget, vpn_number):
        if vpn_number == gtk.RESPONSE_HELP:
            self.open_settings()
            return

        if vpn_number >= 0  and vpn_number < self.vc.get_vpn_count():
            if self.vc.status(vpn_number) == False:
                if self.vc.user_required(vpn_number) and self.vc.pass_required(vpn_number):
                    (user,passwd,cont) = self.user_pass_dlg(True)
                elif self.vc.pass_required(vpn_number):
                    (user,passwd,cont) = self.user_pass_dlg(False)
                else:
                    user   = None
                    passwd = None
                    cont = True
                if cont:
                    self.banner = hildon.hildon_banner_show_information(self, "", "Starting Openvpn Connection")
                    self.vc.start(vpn_number,user,passwd)
            else:
                self.banner = hildon.hildon_banner_show_information(self,"", "Stopping Openvpn Connection")
                self.vc.stop(vpn_number)
            self.timeout = 10
            self.timer = gobject.timeout_add(500, self.update_button)
        elif vpn_number == self.vc.get_vpn_count():
            print "open settings"
            self.open_settings(self)

    def user_pass_dlg(self,ask_passwd):
        if ask_passwd:
            dlg = hildon.LoginDialog(gtk.Window())
            dlg.set_message("Openvpn Authentication")
            response = dlg.run()
            user_pass_resp = (dlg.get_username(),dlg.get_password())
            dlg.destroy()
        else:
            dlg = hildon.GetPasswordDialog(gtk.Window(),False)
            dlg.set_message("Openvpn Authentication")
            response = dlg.run()
            user_pass_resp = (None,dlg.get_password())
            dlg.destroy()

        if response == gtk.RESPONSE_OK:
            user_pass_resp = (user_pass_resp[0],user_pass_resp[1],True)
        else:
            user_pass_resp = (user_pass_resp[0],user_pass_resp[1],False)

        return user_pass_resp

class SelectConnectionDialog(gtk.Dialog):
    def __init__(self,title="Select OpenVPN Connection", parent=None, flags=0, buttons=None,vpn_manager=None):
        gtk.Dialog.__init__(self,title, parent, flags, buttons)
        self.vpn_manager = vpn_manager
        vbox = gtk.VBox()
        pannable_area = hildon.PannableArea()

        for vpn_number,v in enumerate(vpn_manager.vpn_list):
            button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
            if v.get_status():
                button.set_text("Disconnect from",v.get_name())
            else:
                button.set_text("Connect to",v.get_name())
            vbox.pack_start(button)
            button.connect("clicked", self.button_clicked_event, vpn_number)

        button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        button.set_text("Manage Connections","")
        button.connect("clicked", self.button_clicked_event, gtk.RESPONSE_HELP)
        vbox.pack_start(button)

        pannable_area.add_with_viewport(vbox)
        self.vbox.pack_start(pannable_area)
        self.action_area.show_all()
        self.vbox.show_all()
        self.set_size_request(800,(vpn_manager.get_vpn_count()+1)*50+35)
        #self.show_all()


    def button_clicked_event(self, widget, vpn_number):
        self.response(vpn_number)
        self.destroy()

class OpenvpnAppletSettings(gtk.Dialog):
    def __init__(self,title="Openvpn connections", parent=None, flags=0, buttons=None, model=None, applet=None):
        gtk.Dialog.__init__(self,title, parent, flags, buttons)

        self.model = model

        
        self.applet = applet
        
        self.treeview = gtk.TreeView(self.model)
        self.vpncolumn = gtk.TreeViewColumn('Openvpn Connection')
        self.treeview.append_column(self.vpncolumn)
        self.cell = gtk.CellRendererText()
        self.vpncolumn.pack_start(self.cell, True)
        self.vpncolumn.add_attribute(self.cell, 'text', 0)

        self.new_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,"New")
        self.new_button.connect("clicked", self.open_new_dialog)
        self.delete_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,"Delete")
        self.delete_button.connect("clicked", self.delete_clicked_event)
        #self.disable_button = gtk.Button("Disable")
        #self.disable_button.connect("clicked", self.disable_clicked_event)
        self.test_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,"Test")
        self.test_button.connect("clicked", self.test_clicked_event)


        self.treeview.set_size_request(-1, 155)
        scrolledwindow = gtk.ScrolledWindow()
        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
        scrolledwindow.add(self.treeview)
        hbox = gtk.HBox()
        hbox.pack_start(scrolledwindow)
        self.vbox.pack_start(hbox)   
        self.action_area.pack_start(self.new_button)
        self.action_area.pack_start(self.delete_button)
        self.action_area.pack_start(self.test_button)
        self.add_button("Close", gtk.RESPONSE_CLOSE)
        self.action_area.show_all()
        self.vbox.show_all()
        
        
    def open_new_dialog(self, widget, data=None):
        dlg = OpenvpnAppletNewConnection()
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            files_to_overwrite = {}
            files_to_overwrite_message = []
            files_to_copy = {}
            all_files = dlg.get_filenames()
            for f in all_files:
                target_file = os.path.join('/etc/openvpn', os.path.basename(f))
                if os.path.isfile(target_file):
                    files_to_overwrite[f] = all_files[f]
                    files_to_overwrite_message.append(target_file)
                else:
                    files_to_copy[f] =  all_files[f]
            if len(files_to_overwrite) > 0:
                print "Files to overwrite:", files_to_overwrite
                mstr = ""
                for f in files_to_overwrite_message:
                    mstr = mstr+"\n"+f
                mdlg = gtk.MessageDialog(dlg,0,gtk.MESSAGE_QUESTION,gtk.BUTTONS_NONE,"Overwrite files?\n"+mstr)
                mdlg.add_buttons("Overwrite", gtk.RESPONSE_ACCEPT,"Don't Overwrite", gtk.RESPONSE_REJECT)
                response = mdlg.run()
                mdlg.destroy()
                if response == gtk.RESPONSE_ACCEPT:
                    files_to_copy = all_files
            else:
                files_to_copy = all_files
                        
            copy_file(files_to_copy)
            self.applet.update_list(self)
            self.treeview.set_model(self.applet.get_vpn_list())
        dlg.destroy()

    def delete_clicked_event(self, widget, data=None):
        log("delete_clicked_event")
        file_links = FileLinks("/etc/openvpn", ["conf", "ovpn"])
        selection = self.treeview.get_selection()
        selection.set_mode(gtk.SELECTION_SINGLE)
        (model, iter) = selection.get_selected()
        if iter != None:
            log("Item selected")
            filename = model.get_value(iter,1)
            log(filename)
            log(file_links[filename])
            mstr = filename
            for f in file_links[filename]:
                mstr += "\n"+str(f)
            dlg = gtk.MessageDialog(self,0,gtk.MESSAGE_QUESTION,gtk.BUTTONS_NONE,"Deleting files:\n"+mstr)
            dlg.add_buttons("Delete", gtk.RESPONSE_ACCEPT,"Cancel", gtk.RESPONSE_REJECT)
            response = dlg.run()
            dlg.destroy()
            if response == gtk.RESPONSE_ACCEPT:
                delete_files(file_links[filename])
                delete_files([filename])
        else:
            log("No selection")

        self.applet.update_list(self)
        self.treeview.set_model(self.applet.get_vpn_list())
        
    def disable_clicked_event(self, widget, data=None):
        pass
    
    def test_clicked_event(self,widget,data=None):
        selection = self.treeview.get_selection()
        selection.set_mode(gtk.SELECTION_SINGLE)
        (model, iter) = selection.get_selected()
        if iter != None:
            log("Item selected")
            vpn = model.get_value(iter,2)
            if vpn.user_required() and vpn.pass_required():
                (user,passwd,cont) = self.applet.user_pass_dlg(True)
            elif vpn.pass_required():
                (user,passwd,cont) = self.applet.user_pass_dlg(False)
            else:
                user   = None
                passwd = None
                cont = True
            if cont:
                fd = open(vpn.get_log_file(),'w+')
                fd.close()
                if vpn.get_status:
                    vpn.stop()
                vpn.start(user,passwd,True)

            dlg = OpenvpnAppletTestConnection(parent=self,log_file=vpn.get_log_file())            
            dlg.run()        
            dlg.destroy()
            vpn.stop()


class OpenvpnAppletTestConnection(gtk.Dialog):
    def __init__(self,title="Test Connection", parent=None, flags=0, buttons=None,log_file=None):
        gtk.Dialog.__init__(self,title, parent, flags, buttons)
        
        self.fd = open(log_file,"r+")
        log(self.fd)
        self.timer = None
        
        self.textbuffer = gtk.TextBuffer()
        self.textview = gtk.TextView(self.textbuffer) 
        self.textview.set_size_request(800, 480)
        self.textview.set_editable(False)
        self.textview.set_cursor_visible(False)
        
        scrolledwindow = gtk.ScrolledWindow()
        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
        scrolledwindow.add(self.textview)
        
        self.vbox.pack_start(scrolledwindow)
                
        save_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        save_button.set_text("Save Log","")
        save_button.connect("clicked", self.save_button_clicked)
        
        #self.action_area.pack_start(save_button)
        self.add_button(gtk.STOCK_CLOSE,gtk.RESPONSE_CLOSE)
        
        self.update_text()
        self.show_all()
    
    def update_text(self):
        log("update_text")
        if self.timer == 'stop':
            return False
        text = self.fd.read()
        #TextIter.set_line forward_to_end
        self.textbuffer.insert(self.textbuffer.get_end_iter(), text)
        #self.textbuffer.insert_at_cursor(text)
        self.timer = gobject.timeout_add(1000, self.update_text)
    
    def save_button_clicked(self, widget, data=None):
        dlg = hildon.FileChooserDialog(self,gtk.FILE_CHOOSER_ACTION_SAVE,  hildon.FileSystemModel())
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            filename = dlg.get_filename()
            fd = open(filename,'w+')
            print >>fd,self.textbuffer.get_text(self.textbuffer.get_start_iter(),self.textbuffer.get_end_iter())
            fd.close()
            
        dlg.destroy()
        
    
    def destroy(self):
        self.timer = 'stop'
        self.fd.close()
        super(OpenvpnAppletTestConnection,self).destroy()
    
class OpenvpnAppletNewConnection(gtk.Dialog):
    def __init__(self,title="New Connection", parent=None, flags=0, buttons=None):
        gtk.Dialog.__init__(self,title, parent, flags, buttons)

        self.extra_files = []
        self.check = {}
        self.file_entry = {}
        self.browse_button = {}

        self.add_button("Import",gtk.RESPONSE_OK)
        self.add_button("Cancel",gtk.RESPONSE_CANCEL)
        description_keys = ["Configuration File", "Key File", "Cert File", "Ca File", "Secret File", "PKCS12 File"]
        description_values = ["conf", "key", "cert", "ca", "secret", "pkcs12"]
        descriptions = {}
        for i,key in enumerate(description_keys):
            descriptions[key] = description_values[i]
        log(descriptions)
        table = gtk.Table(len(descriptions), 2)
        vbox2 = gtk.VBox()
        pannable_area = hildon.PannableArea()
        for i,d in enumerate(description_keys):
            log(d)
            hbox = gtk.HBox()
            self.file_entry[descriptions[d]] = gtk.Entry()
            self.browse_button[descriptions[d]] = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,d, "None")
            self.browse_button[descriptions[d]].set_alignment(0.0,0.5,1,1)
            self.browse_button[descriptions[d]].set_style(hildon.BUTTON_STYLE_PICKER)
            #hbox.pack_start(self.file_entry[descriptions[d]])
            hbox.pack_start(self.browse_button[descriptions[d]])           
            self.check[descriptions[d]] = gtk.CheckButton(d)
            self.browse_button[descriptions[d]].connect("clicked", self.browse_button_event, (self.file_entry[descriptions[d]], self.check[descriptions[d]]))   

            #table.attach(self.check[descriptions[d]],0,1,i,i+1)
            table.attach(hbox,1,2,i,i+1)   
            vbox2.pack_start(table)

        pannable_area.add_with_viewport(vbox2)
        self.vbox.pack_start(pannable_area)
        self.set_size_request(800,480)
        self.vbox.show_all()

    def get_filenames(self):
        files = {}
        for i,key in enumerate(self.browse_button):
            if self.browse_button[key].get_value() != "None":
                fname = self.browse_button[key].get_value()
                perm = '600'
                for ext in ["conf", "ovpn"]:
                    if re.search("\."+ext+"$",fname):
                        perm = '644'
                files[self.browse_button[key].get_value()] = perm
            
            for file in self.extra_files:
                files[file] = '755'
            
        return files
    
    def browse_button_event(self, widget, data=None):
        textentry = data[0]
        checkbox = data[1]
        dlg = hildon.FileChooserDialog(self, gtk.FILE_CHOOSER_ACTION_OPEN, hildon.FileSystemModel())
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            widget.set_value(dlg.get_filename())
            textentry.set_text(dlg.get_filename())
            checkbox.set_active(True)
            filelinks = FileLinks(dlg.get_filename())
            filelinks.filter(['/home','/media'])
            log("Referenced files in",dlg.get_filename(),filelinks)
            for f in filelinks[dlg.get_filename()]:
                log("Keyword",f,filelinks.get_matchword(f))
                try:
                    self.browse_button[filelinks.get_matchword(f)].set_value(f)
                    self.file_entry[filelinks.get_matchword(f)].set_text(f)
                    self.check[filelinks.get_matchword(f)].set_active(True)
                    log("Keyword file:",filelinks.get_matchword(f),f)
                except KeyError:
                    self.extra_files.append(f)
                    log("Extra file:",f)
                
            if len(filelinks.get_not_found()) > 0:
                log("Files not found:",filelinks.get_not_found())
                mstr = ""
                for f in filelinks.get_not_found():
                    if isinstance(f,str):
                        mstr = mstr+"\n"+f
                mdlg = gtk.MessageDialog(self,0,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,"Files not found:\n"+mstr)
                response = mdlg.run()
                mdlg.destroy() 
        else:
            widget.set_value("None")    
        dlg.destroy()
        

class FileLinks(UserDict):
    def __init__(self, path, filetypes=None):
        UserDict.__init__(self)
        self.path = path
        self.keywords = ["secret","up","down","ca","cert","key","pkcs12","iproute","status","dh","tls-verify","ipchange","client-connect","route-up","client-disconnect","learn-address","auth-user-pass-verify","askpass","auth-user-pass"]
        self.filetypes = filetypes
        self.matchword = {}
        self.files_not_found = []
        if os.path.isdir(path):
            self.type = 'directory'
        else:
            self.type = 'file'
        
        self.update()
        
        
    def update(self):
        log("function: update")
        self.data = {}
        self.references = {}
        if self.type == 'directory':
            for root, dirs, files in os.walk(self.path):
                log(root, files)
                for name in files:
                    log("name: ", name)
                    for type in self.filetypes:
                        if re.search(".*\."+type+"$",name):
                            self.data[os.path.join(root, name)] = self.__scan(os.path.join(root, name), root)
        else:
            self.data[self.path] = self.__scan(self.path, os.path.dirname(self.path))
        
    def __scan(self,file,root):
        log("function: __scan", file, root)
        fileset = Set()
        for line in fileinput.input(file):
            parts = line.split()
            #check for keywords
            if len(parts) > 0:
                for word in self.keywords:
                    if parts[0] == word:
                        print "MATCH: ", word
                        #get filename
                        if len(parts) > 1:
                            filename = parts[1]
                        else:
                            filename = None
                        #check path
                        if filename != None and os.path.exists(filename):
                            #add to return Set
                            fileset.add(filename)
                            self.matchword[filename] = word
                        elif filename !=None and os.path.exists(os.path.join(root, filename)):
                            fileset.add(os.path.join(root, filename))
                            self.matchword[os.path.join(root, filename)] = word
                        elif filename !=None:
                            self.files_not_found.append(filename)
                            filename = None
                    
        #add entries in return Set to reference count
        for f in list(fileset):
            try:
                self.references[f] += 1
            except KeyError:
                self.references[f]  = 1
        return list(fileset)

    def __getitem__(self,item):
        items = self.data[item]
        return_items = []
        for it in items:
            if self.references[it] == 1:
                return_items.append(it)
        return return_items

    def get_matchword(self,file):
        try:
            response = self.matchword[file]     
        except KeyError:
            response = None
        return response
            
    def get_not_found(self):
        if self.files_not_found == [None]:
            self.files_not_found = []
        return self.files_not_found
        
    def filter(self,whitelist):
        for key in self.data:
            passed_files = []
            for file in self.data[key]:
                if os.path.isabs(file):
                    for wl in whitelist:
                        if re.search('^'+wl,file):
                            passed_files.append(file)
                        else:
                            log("Dropped:", file)
            self.data[key] = passed_files
                        
    
hd_plugin_type = openvpn_applet

def log(*input):
    if enable_logging:
        print input
        print >>fd,input
        fd.flush()

# The code below is just for testing purposes.
# It allows to run the widget as a standalone process.
if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()


#if __name__ == '__main__':
#    vc = vpn_control()
#    print vc
#    sel = int(raw_input("command: "))-1
#    if vc.status(sel) != 0:
#        vc.start(sel)
#    else:
#        vc.stop(sel)
