#!/bin/sh

if [ "$1" = "start_sshd" ] ; then
    /etc/init.d/ssh start
fi

if [ "$1" = "stop_sshd" ] ; then
    /etc/init.d/ssh stop
fi

if [ "$1" = "kill_sshd" ] ; then
    killall sshd
fi

if [ "$1" = "disable_respawn" ] ; then
    sed -i 's/respawn/#respawn/g' /etc/event.d/sshd
fi

if [ "$1" = "disable_autostart" ] ; then
    sed -i 's/start on stopped rcS/#start on stopped rcS/g' /etc/event.d/sshd
fi

if [ "$1" = "enable_autostart" ] ; then
    sed -i 's/#start on stopped rcS/start on stopped rcS/g' /etc/event.d/sshd
fi

if [ "$1" = "wlan_started" ] ; then
    WLAN_IP=$(/sbin/ifconfig wlan0 | sed -n 's/.*inet addr:\([0-9.]\+\).*/\1/p')
    if [ ! $WLAN_IP ]; then
        WLAN_IP="None"
    fi
    if [ $(netstat -t | grep :ssh.*ESTABLISHED | grep -c $WLAN_IP) -gt 0 ] \
    && [ $(ps aux | grep -v grep  | grep -c /usr/sbin/osw-power-management) -eq 0 ]; then
        nohup /usr/sbin/osw-power-management >/dev/null 2>&1 &
    fi
fi

if [ "$1" = "wlan_stopped" ] ; then
    kill $(ps aux | grep /usr/sbin/osw-power-management | grep -v grep | awk '{print $1}')
    iwconfig wlan0 power on
fi

if [ "$1" = "wifipmoff_once" ] ; then
    kill $(ps aux | grep /usr/sbin/osw-power-management | grep -v grep | awk '{print $1}')
    sleep 1
    kill $(ps aux | grep /usr/sbin/osw-power-management | grep -v grep | awk '{print $1}')
    if [ $(ps aux | grep -v grep  | grep -c /usr/sbin/osw-power-management) = "0" ]; then
        /usr/sbin/osw-power-management once &
    fi
fi

if [ "$1" = "enable_wifipmoff" ] ; then
    if [ $(ps aux | grep -v grep  | grep -c /usr/sbin/osw-power-management) = "0" ]; then
        /usr/sbin/osw-power-management &
    fi
fi

if [ "$1" = "disable_wifipmoff" ] ; then
    if [ $(ps aux | grep -v grep  | grep -c /usr/sbin/osw-power-management\ once) = "0" ]; then
        kill $(ps aux | grep /usr/sbin/osw-power-management | grep -v grep | awk '{print $1}')
        iwconfig wlan0 power on
    fi
fi

if [ "$1" = "togglepm_changed" ] ; then
    sleep 1
    if [ $(ps aux | grep -v grep  | grep -c /usr/sbin/osw-power-management\ once) = "0" ]; then
        kill $(ps aux | grep /usr/sbin/osw-power-management | grep -v grep | awk '{print $1}')
        /usr/sbin/osw-power-management &
    fi
fi

if [ "$1" = "disconnect" ] ; then
    WLAN_IP=$(/sbin/ifconfig wlan0 | sed -n 's/.*inet addr:\([0-9.]\+\).*/\1/p')
    if [ $(ps aux | grep -v grep  | grep -c /usr/sbin/osw-power-management\ once) = "0" ] \
    && [ $(netstat -t | grep :ssh | grep -c $WLAN_IP) = "0" ]; then
        kill $(ps aux | grep /usr/sbin/osw-power-management | grep -v grep | awk '{print $1}')
        iwconfig wlan0 power on
    fi
fi

if [ "$1" = "create_sshd" ] ; then
    echo "#start on stopped rcS" >> /etc/event.d/sshd
    echo "" >> /etc/event.d/sshd
    echo "console output" >> /etc/event.d/sshd
    echo "" >> /etc/event.d/sshd
    echo "#respawn" >> /etc/event.d/sshd
    echo "" >> /etc/event.d/sshd
    echo "pre-start script" >> /etc/event.d/sshd
    echo "    if [ ! -d /var/run/sshd ] ; then" >> /etc/event.d/sshd
    echo "        mkdir /var/run/sshd" >> /etc/event.d/sshd
    echo "        chmod 755 /var/run/sshd" >> /etc/event.d/sshd
    echo "    fi" >> /etc/event.d/sshd
    echo "end script" >> /etc/event.d/sshd
    echo "" >> /etc/event.d/sshd
    echo "exec /usr/sbin/sshd" >> /etc/event.d/sshd
fi

if [ "$1" = "insert_start" ] ; then
    sed -i '1i#start on stopped rcS' /etc/event.d/sshd
fi
