#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import gtk
import hildon
from os import listdir, path, system
from ConfigParser import SafeConfigParser

version = "1.6-0"
trackingEnabled = True
stopTracking = True
stopWhenIdle = False
stopAfterMinutes = "5 minutes"
confirmDisconnect = True
showConnected = True
connectedIcon = "Symbol"
skipSystemCheck = False
autostart = False
keepWifiPMOff = False
refreshPMAfterSec = "20 seconds"

class Main(object):
    def __init__(self):
        global trackingEnabled
        global stopTracking
        global stopWhenIdle
        global stopAfterMinutes
        global showConnected
        global connectedIcon
        global confirmDisconnect
        global skipSystemCheck
        global autostart
        global keepWifiPMOff
        global refreshPMAfterSec
        
        autostartDisabled = False
        keepWifiPMOffInstalled = False
        otherForceCommand = False
        
        self.parser = SafeConfigParser()
        self.parser.optionxform = str
        if path.isfile("/home/user/.openssh-status-widget"):
            try:
                self.parser.read('/home/user/.openssh-status-widget')
            except:
                system("rm /home/user/.openssh-status-widget")
            else:
                if not self.parser.has_section('options'):
                    system("rm /home/user/.openssh-status-widget")
        if not path.isfile("/home/user/.openssh-status-widget"):
            configFile = open('/home/user/.openssh-status-widget', 'w')
            self.parser.add_section('options')
            self.parser.set('options', 'trackingEnabled', str(trackingEnabled))
            self.parser.set('options', 'stopTracking', str(stopTracking))
            self.parser.set('options', 'stopWhenIdle', str(stopWhenIdle))
            self.parser.set('options', 'stopAfterMinutes', str(connectedIcon))
            self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
            self.parser.set('options', 'showConnected', str(showConnected))
            self.parser.set('options', 'connectedIcon', str(connectedIcon))
            self.parser.set('options', 'skipSystemCheck', str(skipSystemCheck))
            self.parser.write(configFile)
            configFile.close()
        else:
            self.parser.read('/home/user/.openssh-status-widget')
            if self.parser.has_section('options'):
                if self.parser.has_option('options', 'trackingEnabled'):
                    trackingEnabled = self.parser.getboolean('options', 'trackingEnabled')
                else:
                    self.parser.set('options', 'stopTracking', str(stopTracking))
                if self.parser.has_option('options', 'stopTracking'):
                    stopTracking = self.parser.getboolean('options', 'stopTracking')
                else:
                    self.parser.set('options', 'stopTracking', str(stopTracking))
                if self.parser.has_option('options', 'stopWhenIdle'):
                    stopWhenIdle = self.parser.getboolean('options', 'stopWhenIdle')
                else:
                    self.parser.set('options', 'stopWhenIdle', str(stopWhenIdle))
                if self.parser.has_option('options', 'stopAfterMinutes'):
                    stopAfterMinutes = self.parser.get('options', 'stopAfterMinutes')
                else:
                    self.parser.set('options', 'stopAfterMinutes', str(stopAfterMinutes))
                if self.parser.has_option('options', 'confirmDisconnect'):
                    confirmDisconnect = self.parser.getboolean('options', 'confirmDisconnect')
                else:
                    self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
                if self.parser.has_option('options', 'showConnected'):
                    showConnected = self.parser.getboolean('options', 'showConnected')
                else:
                    self.parser.set('options', 'showConnected', str(showConnected))
                if self.parser.has_option('options', 'connectedIcon'):
                    connectedIcon = self.parser.get('options', 'connectedIcon')
                else:
                    self.parser.set('options', 'connectedIcon', str(connectedIcon))
                if self.parser.has_option('options', 'skipSystemCheck'):
                    skipSystemCheck = self.parser.getboolean('options', 'skipSystemCheck')
                else:
                    self.parser.set('options', 'skipSystemCheck', str(skipSystemCheck))
        
        if not path.isfile("/etc/event.d/sshd"):
            system("sudo /usr/sbin/openssh-status.sh create_sshd")
        sshFile = open("/etc/event.d/sshd",'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "start on stopped rcS":
                autostart = True
            if line.strip('\n').strip(' ') == "#start on stopped rcS":
                autostartDisabled = True
        if not autostart and not autostartDisabled:
            system("sudo /usr/sbin/openssh-status.sh insert_start")
            
        sshFile = open("/etc/ssh/sshd_config", 'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "ForceCommand /usr/lib/openssh/session":
                keepWifiPMOffInstalled = True
            else:
                line = line.strip('\n').strip(' ')
                if line[0:12] == "ForceCommand":
                    otherForceCommand = True
        if otherForceCommand:
            system("sudo /usr/sbin/openssh-status.sh no_force")
            keepWifiPMOffInstalled = False
        if not keepWifiPMOffInstalled:
            system("sudo /usr/sbin/openssh-status.sh insert_wifipm")
            
        sshFile = open("/usr/lib/openssh/session", 'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "#SSH_IP=\"disabled\"":
                keepWifiPMOff = True
        
        sshFile = open("/usr/lib/openssh/wifi-power-management", 'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if 'sleep' in line:
                refreshPMAfterSec = line.strip('\n').split()[1] + " seconds"
        
        self.indicatorList = []
        for f in listdir('/usr/share/icons/hicolor/18x18/hildon/'):
            if f[0:21] == "openssh-status_users_" and f <> "openssh-status_users_symbol.png" and f[-4:] ==".png":
                f = f[21:-4]
                self.indicatorList.append(f.title())
        self.indicatorList.sort()
        self.indicatorList.insert(0, "Symbol")
        
        self.timeoutList = ["1 minute", "5 minutes", "15 minutes", "30 minutes", "60 minutes"]
        self.pmRefreshList = ["5 seconds", "10 seconds", "15 seconds", "20 seconds"]
        
        self.main()
    
    def main(self):
        window = hildon.Window()
        window.set_title("OpenSSH Status Widget")
        window.connect("delete_event", gtk.main_quit, None)
        
        labelWidget = gtk.Label("Widget options:")
        labelOther = gtk.Label("Server options:")
    
        self.buttonTrackingEnabled = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonTrackingEnabled.set_label("Enable tracking")
    
        self.buttonStopTracking = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonStopTracking.set_label("Stop tracking when server is off")
    
        self.buttonStopWhenIdle = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonStopWhenIdle.set_label("Stop server when not connected")
    
        self.buttonStopAfterMinutes = hildon.PickerButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonStopAfterMinutes.set_title("Wait:")
        self.buttonStopAfterMinutes.set_alignment(0.09, 0.5, 0, 0)
        self.buttonStopAfterMinutes.set_selector(self.selectTimeout())
        try:
            self.buttonStopAfterMinutes.set_active(self.timeoutList.index(stopAfterMinutes))
        except:
            self.buttonStopAfterMinutes.set_active(1)
    
        self.buttonConfirm = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonConfirm.set_label("Confirm when disconnecting")
        
        self.buttonShowConnected = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonShowConnected.set_label("Show status 'connected' in status area")
    
        self.buttonConnectedIcon = hildon.PickerButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonConnectedIcon.set_title("Indicator:")
        self.buttonConnectedIcon.set_alignment(0.09, 0.5, 0, 0)
        self.buttonConnectedIcon.set_selector(self.selectIndicator())
        try:
            self.buttonConnectedIcon.set_active(self.indicatorList.index(connectedIcon.strip('_')))
        except:
            self.buttonConnectedIcon.set_active(0)
    
        self.buttonAutostart = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonAutostart.set_label("Run server at system startup")
                
        self.buttonKeepWifiPMOff = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonKeepWifiPMOff.set_label("Keep wifi power management off when connected")
    
        self.buttonRefreshPMAfterSec = hildon.PickerButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonRefreshPMAfterSec.set_title("Refresh time:")
        self.buttonRefreshPMAfterSec.set_alignment(0.1, 0.5, 0, 0)
        self.buttonRefreshPMAfterSec.set_selector(self.selectPMRefreshTime())
        try:
            self.buttonRefreshPMAfterSec.set_active(self.pmRefreshList.index(refreshPMAfterSec))
        except:
            self.buttonRefreshPMAfterSec.set_active(3)
    
        vboxBorder = gtk.VBox(False, 0)
        vboxBorder.set_border_width(8)
        vbox = gtk.VBox(False, 0)
        vbox.set_border_width(0)
        vbox.pack_start(labelWidget, False, False, 8)
        vbox.pack_start(self.buttonTrackingEnabled, False, False, 0)
        vbox.pack_start(self.buttonStopTracking, False, False, 0)
        vbox.pack_start(self.buttonStopWhenIdle, False, False, 0)
        vbox.pack_start(self.buttonStopAfterMinutes, False, False, 0)
        vbox.pack_start(self.buttonConfirm, False, False, 0)
        vbox.pack_start(self.buttonShowConnected, False, False, 0)
        vbox.pack_start(self.buttonConnectedIcon, False, False, 0)
        vbox.pack_start(labelOther, False, False, 8)
        vbox.pack_start(self.buttonAutostart, False, False, 0)
        vbox.pack_start(self.buttonKeepWifiPMOff, False, False, 0)
        vbox.pack_start(self.buttonRefreshPMAfterSec, False, False, 0)
        
        areaScrolling = hildon.PannableArea()
        areaScrolling.add_with_viewport(vbox)
        areaScrolling.set_border_width(0)
        
        vboxBorder.pack_start(areaScrolling, True, True, 0)
        
        window.add(vboxBorder)
        
        if stopTracking:
            self.buttonStopTracking.set_active(True)
        else:
            self.buttonStopTracking.set_active(False)
        if stopWhenIdle:
            self.buttonStopWhenIdle.set_active(True)
            self.buttonStopAfterMinutes.set_sensitive(True)
        else:
            self.buttonStopWhenIdle.set_active(False)
            self.buttonStopAfterMinutes.set_sensitive(False)
        if confirmDisconnect:
            self.buttonConfirm.set_active(True)
        else:
            self.buttonConfirm.set_active(False)
        if showConnected:
            self.buttonShowConnected.set_active(True)
            self.buttonConnectedIcon.set_sensitive(True)
        else:
            self.buttonShowConnected.set_active(False)
            self.buttonConnectedIcon.set_sensitive(False)
            
        if trackingEnabled:
            self.buttonTrackingEnabled.set_active(True)
        else:
            self.buttonTrackingEnabled.set_active(False)
            self.buttonStopTracking.set_sensitive(False)
            self.buttonStopWhenIdle.set_sensitive(False)
            self.buttonStopAfterMinutes.set_sensitive(False)
            self.buttonConfirm.set_sensitive(False)
            self.buttonShowConnected.set_sensitive(False)
            self.buttonConnectedIcon.set_sensitive(False)
        
        if autostart:
            self.buttonAutostart.set_active(True)
        else:
            self.buttonAutostart.set_active(False)
        if keepWifiPMOff:
            self.buttonKeepWifiPMOff.set_active(True)
            self.buttonRefreshPMAfterSec.set_sensitive(True)
        else:
            self.buttonKeepWifiPMOff.set_active(False)
            self.buttonRefreshPMAfterSec.set_sensitive(False)
        
        self.buttonTrackingEnabled.connect("clicked", self.buttonTrackingEnabled_clicked)
        self.buttonStopTracking.connect("clicked", self.buttonStopTracking_clicked)
        self.buttonStopWhenIdle.connect("clicked", self.buttonStopWhenIdle_clicked)
        self.buttonStopAfterMinutes.connect("value-changed", self.buttonStopAfterMinutes_changed)
        self.buttonConfirm.connect("clicked", self.buttonConfirm_clicked)
        self.buttonShowConnected.connect("clicked", self.buttonShowConnected_clicked)
        self.buttonConnectedIcon.connect("value-changed", self.buttonConnectedIcon_changed)
        self.buttonAutostart.connect("clicked", self.buttonAutostart_clicked)
        self.buttonKeepWifiPMOff.connect("clicked", self.buttonKeepWifiPMOff_clicked)
        self.buttonRefreshPMAfterSec.connect("value-changed", self.buttonRefreshPMAfterSec_changed)
        
        menu = self.create_menu()
        window.set_app_menu(menu)
        
        window.show_all()
    
        gtk.main()
        
    def buttonTrackingEnabled_clicked(self, dummy):
        global trackingEnabled
        trackingEnabled = not trackingEnabled
        if trackingEnabled:
            self.buttonStopTracking.set_sensitive(True)
            self.buttonStopWhenIdle.set_sensitive(True)
            if stopWhenIdle:
                self.buttonStopAfterMinutes.set_sensitive(True)
            self.buttonConfirm.set_sensitive(True)
            self.buttonShowConnected.set_sensitive(True)
            if showConnected:
                self.buttonConnectedIcon.set_sensitive(True)
        else:
            self.buttonStopTracking.set_sensitive(False)
            self.buttonStopWhenIdle.set_sensitive(False)
            self.buttonStopAfterMinutes.set_sensitive(False)
            self.buttonConfirm.set_sensitive(False)
            self.buttonShowConnected.set_sensitive(False)
            self.buttonConnectedIcon.set_sensitive(False)
        self.parser.set('options', 'trackingEnabled', str(trackingEnabled))
        self.write_config()
        
    def buttonStopTracking_clicked(self, dummy):
        global stopTracking
        stopTracking = not stopTracking
        self.parser.set('options', 'stopTracking', str(stopTracking))
        self.write_config()
        
    def buttonStopWhenIdle_clicked(self, dummy):
        global stopWhenIdle
        stopWhenIdle = not stopWhenIdle
        if stopWhenIdle:
            self.buttonStopAfterMinutes.set_sensitive(True)
        else:
            self.buttonStopAfterMinutes.set_sensitive(False)
        self.parser.set('options', 'stopWhenIdle', str(stopWhenIdle))
        self.write_config()
        
    def selectTimeout(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.timeoutList:
            selector.append_text(i)
        return selector
        
    def buttonStopAfterMinutes_changed(self, dummy):
        t = self.buttonStopAfterMinutes.get_value()
        self.parser.set('options', 'stopAfterMinutes', t)
        self.write_config()
        
    def buttonConfirm_clicked(self, dummy):
        global confirmDisconnect
        confirmDisconnect = not confirmDisconnect
        self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
        self.write_config()

    def buttonShowConnected_clicked(self, dummy):
        global showConnected
        showConnected = not showConnected
        if showConnected:
            self.buttonConnectedIcon.set_sensitive(True)
        else:
            self.buttonConnectedIcon.set_sensitive(False)
        self.parser.set('options', 'showConnected', str(showConnected))
        self.write_config()
        
    def selectIndicator(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.indicatorList:
            selector.append_text(i)
        return selector
        
    def buttonConnectedIcon_changed(self, dummy):
        style = self.buttonConnectedIcon.get_value()
        while len(style) < 4:
            style = style + "_"
        self.parser.set('options', 'connectedIcon', style)
        self.write_config()
        
    def buttonAutostart_clicked(self, dummy):
        global autostart
        autostart = not autostart
        if autostart:
            system("sudo /usr/sbin/openssh-status.sh enable_autostart")
        else:
            system("sudo /usr/sbin/openssh-status.sh disable_autostart")

    def buttonKeepWifiPMOff_clicked(self, dummy):
        global keepWifiPMOff
        keepWifiPMOff = not keepWifiPMOff
        if keepWifiPMOff:
            self.buttonRefreshPMAfterSec.set_sensitive(True)
            system("sudo /usr/sbin/openssh-status.sh enable_wifipmoff")
        else:
            self.buttonRefreshPMAfterSec.set_sensitive(False)
            system("sudo /usr/sbin/openssh-status.sh disable_wifipmoff")
        
    def selectPMRefreshTime(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.pmRefreshList:
            selector.append_text(i)
        return selector
        
    def buttonRefreshPMAfterSec_changed(self, dummy):
        t = self.buttonRefreshPMAfterSec.get_value()
        system("sudo /usr/sbin/openssh-status.sh set_wifipmrefresh "+t)
        
    def write_config(self):
        configFile = open('/home/user/.openssh-status-widget', 'r+')
        self.parser.write(configFile)
        configFile.close()

    def create_menu(self):
        menu = hildon.AppMenu()
    
        buttonRestart = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        buttonRestart.set_label('Restart Status Menu')
        buttonRestart.connect("clicked", self.restart_clicked)
        buttonAbout = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        buttonAbout.set_label('About')
        buttonAbout.connect("clicked", self.about_clicked)
    
        menu.append(buttonRestart)
        menu.append(buttonAbout)
    
        menu.show_all()
    
        return menu
    
    def restart_clicked(self, dummy):
        system("killall hildon-status-menu")
        return
    
    def about_clicked(self, dummy):
        self.about = gtk.Dialog("About", None)
        logo = gtk.image_new_from_file("/usr/share/icons/hicolor/64x64/apps/openssh-status.png")
        textApp = gtk.Label("<big><b>OpenSSH Status Widget  "+version+"</b></big>")
        textApp.set_use_markup(True)
        textApp.set_line_wrap(True)
        textIandI = gtk.Label("Created by Marc Pöpperl (rasmarc)\n")
        buttonForum = hildon.Button(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        buttonForum.set_label('Go to forum thread')
        vbox2 = gtk.VBox(False,16)
        vbox2.set_border_width(16)
        vbox2.pack_start(logo)
        vbox2.pack_start(textApp)
        vbox2.pack_start(textIandI)
        vbox2.pack_start(buttonForum)
        self.about.vbox.pack_start(vbox2)

        buttonForum.connect("clicked", self.buttonForum_clicked)
        
        self.about.show_all()
        
    def buttonForum_clicked(self, dummy):
        self.about.destroy()
        system("dbus-send --session --type=method_call --print-reply --dest=com.nokia.osso_browser \
        /com/nokia/osso_browser/request com.nokia.osso_browser.open_new_window string:http://talk.maemo.org/showthread.php?t=95429")
            
if __name__ == "__main__":
    Main()

