/*
 * OpenConnect GUI (a GTK/Hildon GUI client for OpenConnect)
 *
 * Copyright (c) 2009-2010 Pascal Jermini <lorelei@garage.maemo.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to:
 *
 *   Free Software Foundation, Inc.
 *   51 Franklin Street, Fifth Floor,
 *   Boston, MA 02110-1301 USA
 */

#ifndef __PROFILES_H__
#define __PROFILES_H__

#include <hildon/hildon.h>
#include "openconnect-gui.h"

typedef struct _profileWidgets profileWidgets;

struct _profileWidgets {
	GtkWidget *win;
	GtkWidget *profileName;
	GtkWidget *server;
	GtkWidget *username;
	GtkWidget *password;

	OpenConnectGUI *appData;
	gboolean editingProfile;
	gchar *oldName;
};



profileWidgets *createProfilesWindow (GtkWidget *widget, gpointer data);
void editProfile(gpointer data, gchar *profile);
void load_profiles(OpenConnectGUI *self);
#endif

/* vim: set ts=4: */
