/*
 * OpenConnect GUI (a GTK/Hildon GUI client for OpenConnect)
 *
 * Copyright (c) 2009-2010 Pascal Jermini <lorelei@garage.maemo.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to:
 *
 *   Free Software Foundation, Inc.
 *   51 Franklin Street, Fifth Floor,
 *   Boston, MA 02110-1301 USA
 */

#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

pid_t pid=-1;

void killproc(int signal) {
	if(pid!=-1) {
		kill(pid, SIGTERM);
	}
}

int main(int argc, char *argv[]) {

	signal(SIGINT, killproc);
	signal(SIGTERM, killproc);
	signal(SIGPIPE, SIG_IGN);

	pid=fork();
	if(pid==-1) {
		exit(1);
	}

	if(pid==0) {
		/* Change UID and GID */
		if(setreuid (geteuid(), geteuid()) == -1) {
			exit(1);
		}
		if(setregid(getegid(), getegid()) == -1) {
			exit(1);
		}
#ifdef DEBUG
		execl("./senseless", "openconnect", "--script=/usr/share/openconnect/vpnc-script", argv[1], argv[2], argv[3], NULL);
#else
		execl("/usr/bin/openconnect", "openconnect", "--script=/usr/share/openconnect/vpnc-script", argv[1], argv[2], argv[3], NULL);
#endif
	}
	else {
		int status;
		waitpid(pid, &status, 0);
	}

	return 0;
}

/* vim: set ts=4: */
