/*
 * OpenConnect GUI (a GTK/Hildon GUI client for OpenConnect)
 *
 * Copyright (c) 2009-2010 Pascal Jermini <lorelei@garage.maemo.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to:
 *
 *   Free Software Foundation, Inc.
 *   51 Franklin Street, Fifth Floor,
 *   Boston, MA 02110-1301 USA
 */

#ifndef __OPENCONNECT_GUI_H__
#define __OPENCONNECT_GUI_H__

#include <hildon/hildon.h>

typedef struct _OpenConnectGUI OpenConnectGUI;

struct _OpenConnectGUI
{
	GtkWidget *window;
	GtkWidget *connButton;
	GtkWidget *disconnButton;
	GtkWidget *profileSelector;
	GtkWidget *profileButton;

	GtkTextBuffer *logBuffer;
	GtkWidget *logWidget;

	GPid pid;
	GIOChannel *channel;

	gchar *currentProfile;
	GKeyFile *keyfile;
	gchar *confFile;
	gchar **profiles;

	GtkListStore *profile_store;
};

#endif
