﻿ #!/usr/bin/env python
# -*- coding: utf-8 -*-
# 


__title__="NumberLocation"
__author__= "binkcn"
__email__="binkcn@vip.qq.com"
__version__= "0.2.3"
__build__="111010"

import sys
import os
import sqlite3
import string
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtMaemo5 import QMaemo5InformationBox

class MainApp(QApplication):
    def __init__(self, parent=None):
        super(MainApp, self).__init__(parent)
        self.create_default_window()
        
    def create_default_window(self):
        self.defaultWin=DefaultWindow(None)
        aboutAction=self.create_action(unicode("关于软件"), self.show_about_form)
        self.menuBar=QMenuBar()
        self.menuBar.addAction(aboutAction)
        self.defaultWin.setMenuBar(self.menuBar)
        self.defaultWin.show()
        
    def show_about_form(self):
        aboutForm=AboutForm(self.defaultWin)
        aboutForm.show()
        
    def create_action(self, text, slot=None, shortcut=None, icon=None, tip=None, checkable=False, signal="triggered()"):
        action = QAction(text, self)
        if slot is not None:
            self.connect(action, SIGNAL(signal), slot)
        if checkable:
            action.setCheckable(True)
        return action
        
class DefaultWindow(QMainWindow):
    def __init__(self, parent=None, orientation=0):
        super(DefaultWindow, self).__init__(parent)
        self.setWindowTitle(__title__)
        
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        st="""
            <br />
            NumberLocation<br />
            来电及去电号码归属地及类型显示<br />
            <br />
            1、首次安装完毕或无法显示时请点击第一个按钮重启后台进程。<br />
            2、点击第二个按钮后请稍等，根据通话记录数量，更新所需时间不一。<br />
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;一百条通话记录，一般大约3-5分钟即可更新完毕，届时会有提示。<br />
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;通讯录追加归属地信息后，请安装 Extended Call Log 查看信息。<br />
        """
        
        self.labelsummary = QLabel()
        self.labelsummary.setText(st)
        self.rebootBtn = QPushButton(unicode("重新启动后台进程（归属地不显示时点击）"))
        self.parseBtn = QPushButton(unicode("批量追加显示通讯录中现有号码归属地信息"))
        
        self.buttonFormLayout=QFormLayout(self)
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        
        self.buttonFormLayout.addRow(self.labelsummary)
        self.buttonFormLayout.addRow(self.rebootBtn)
        self.buttonFormLayout.addRow(self.parseBtn)
        
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)
        
        self.mainLayout = QGridLayout(self)
        self.mainLayout.addWidget(self.buttonFrame)
        self.mainLayout.setAlignment(Qt.AlignTop)

        
        self.setCentralWidget(self.buttonFrame)
        self.setFixedSize(800,480)
        #self.setStyleSheet("background-color: #333");
        self.connect(self.rebootBtn, SIGNAL("clicked()"), self.rebootBtn_Clicked)
        self.connect(self.parseBtn, SIGNAL("clicked()"), self.parseBtn_Clicked)
        
    def rebootBtn_Clicked(self):
        import os
        os.system("kill -9 `ps -ef|grep location/number|grep -v \"grep\"|awk '{print $1}'`")
        os.system("python /home/user/apps/numberlocation/numberlocation.py &")
        
        self.show_notice("后台进程重新启动成功！")
        
    def parseBtn_Clicked(self):
        #self.show_notice("开始批量处理数据，可能需要一点时间，请耐心等待……")
        self.fetchAllNumber()
        
    def fetchAllNumber(self):
        conn = sqlite3.connect("/home/user/.rtcom-eventlogger/el-v1.db")
        cur = conn.cursor()
        cur.execute('select * from Remotes where local_uid=\'ring/tel/ring\' and length(remote_uid) > 0 and length(remote_name) > 0 and abook_uid is null and remote_name not like \'%(%\'')
        rows = cur.fetchall()
        cur.close()
        
        for row in rows:
            #print row[1]+" -> "+row[2]
            self.parseNumberLocation(conn, row[1], row[2])
        
        self.show_notice("Extended Call Log 通话记录中所有数据已更新！")
        
    def parseNumberLocation(self, objconn, number, location):
        number=string.replace(number, "+86", "")
        location = self.getnumberlocation(number)
        
        conn = sqlite3.connect("/home/user/.rtcom-eventlogger/el-v1.db")
        cur = conn.cursor()
        
        #print 'update remotes set remote_name=remote_uid||\'('+location+')\' where remote_uid=\''+number+'\''
        cur.execute('update remotes set remote_name=remote_uid||\'('+location+')\' where remote_uid=\''+number+'\'')
                
        conn.commit()
        cur.close()
        conn.close()
         
    def getnumberlocation(self,callernumber):
        l = len(callernumber)
        f = callernumber[0]
        s = callernumber[1]
        if l < 6:
            return '特服号'
        elif f == '0' and s < '3':
            return self.getarea(callernumber[1:3])
        elif f == '0' and s > '3':
            return self.getarea(callernumber[1:4])
        elif l > 8 and f == '1':
            return self.getarea(callernumber[0:7])
        else:
            return '未知'
            
    def getarea(self,areacode):
        conn = sqlite3.connect("/home/user/apps/numberlocation/location.db3")
        cur = conn.cursor()
        cur.execute('select s_area,s_type from cw where n_phonenum='+areacode)
        row = cur.fetchone()
        #show_notification_dialog('号码归属地:'+row[0]+'\n号码类型:'+row[1])
        cur.close()
        if row:
            return row[0]
        else:
            return '未知'
        
    def show_notice(self,message,timeout=QMaemo5InformationBox.DefaultTimeout):
        QMaemo5InformationBox.information(None,"\n"+unicode(message)+"\n",timeout)
        
        
class AboutForm(QDialog):
    def __init__(self, parent=None):
        super(AboutForm, self).__init__(parent)
        self.setWindowTitle(unicode("关于"))
        self.aboutLabel=QLabel()
        st="""<b>NumberLocation</b>
            <p>  Nokia N900 来/去电号码归属地及类型显示
            <p>  如需在通讯录中显示归属地信息，请在源中安装以下软件：
            <p>  Extended Call Log
            <p>  版本号 %s  最后修订 %s
            <p>  软件作者 %s
            <p>  联系邮箱 %s
            """ % (
                          __version__, __build__,
                          __author__, __email__)
        self.aboutLabel.setText(st)
        self.formLayout=QFormLayout(self)
        self.formLayout.addRow(self.aboutLabel)
        
def main():
    reload(sys)
    sys.setdefaultencoding('utf8')
    QTextCodec.setCodecForCStrings(QTextCodec.codecForName("UTF-8"))
    app = MainApp(sys.argv)
    app.setApplicationName("NumberLocation")
    app.setOrganizationName("Binkcn")
    app.setOrganizationDomain("t.qq.com/binkcn")
    app.exec_()

main()
