//#include <QTimer>
#include "alarmwindow.h"
#include "ui_alarmwindow.h"

#if  defined(Q_WS_MAEMO_5)
#include <QtDBus/QtDBus>
#include <time.h>
#include <alarmd/alarm_dbus.h>
#include <alarmd/libalarm.h>
#endif


#include <QPainter>
#include "settingsdialog.h"
#include "nalarmsettings.h"

#define alarmIconPath "/usr/share/icons/hicolor/48x48/hildon/general_alarm_on.png"
#define clockIconPath "/usr/share/icons/hicolor/48x48/hildon/general_clock.png"
#define recurIconPath "/usr/share/icons/hicolor/48x48/hildon/general_refresh.png"
#define calendarIconPath "/usr/share/icons/hicolor/48x48/hildon/general_calendar.png"
#define eventIconPath "/usr/share/icons/hicolor/48x48/hildon/general_profile.png"

static int FNT_ADD = 3;
//static int NEXT_PERIOD = 86400; // look forward for 24 hours

AlarmWindow::AlarmWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::AlarmWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_TranslucentBackground);
    resize(300,300);

    loadSettings();
    fillAlarmList();
    updateUi();

    m_timer = new QTimer(this);
    connect(m_timer, SIGNAL(timeout()), this, SLOT(fillAlarmList()));
    showSettingsDialog();
}

AlarmWindow::~AlarmWindow()
{
    delete ui;
}

void AlarmWindow::fillAlarmList()
{
#if  defined(Q_WS_MAEMO_5)
    QIcon icn (alarmIconPath);
    QIcon icnRecur (recurIconPath);
    QIcon icnEvent (eventIconPath);
    QIcon icnCalendar (calendarIconPath);
#else
    QIcon icn ("d:\\Qt\\Project\\NextAlarm\\hicolor\\18x18\\hildon\\general_alarm_on.png");
#endif

    ui->listWidget->clear();
    QFontMetrics fm(m_font);
    int fntHeight = fm.height() + FNT_ADD;

    if (m_showCaption)
    {
       QString header;
       header = QString(tr("alarms in next %1 h").arg(QString::number(m_timeFrame)));
       QListWidgetItem * item = new QListWidgetItem;
       item->setText(header);
       item->setTextAlignment(Qt::AlignBottom);
       QFont hFnt;
       hFnt.setUnderline(true);
//       QIcon icnClock (clockIconPath);
//       item->setIcon(icnClock);
       item->setSizeHint(QSize (m_width-fntHeight,fntHeight));
       item->setFont(hFnt);
       ui->listWidget->addItem(item);
    }

#if  defined(Q_WS_MAEMO_5)
    cookie_t *list, *iter;
    time_t now;

    //TODO remove this
//    m_timeFrame = 96;

    now = time(NULL);
    list = alarmd_event_query(now, now + m_timeFrame*3600, ALARM_EVENT_DISABLED, 0, NULL);
    if (list == NULL) {
            fprintf(stderr, "alarm_event_query() failed\n");
    }

    bool aFound = false;
    if (list[0] != (cookie_t) 0) {
            for (iter = list; *iter != (cookie_t) 0; iter++) {

                QListWidgetItem * item = new QListWidgetItem;
                item->setSizeHint(QSize (m_width-fntHeight,fntHeight));
                item->setForeground(m_color);
                item->setFont(m_font);

                alarm_event_t * aevent = alarmd_event_get (*iter);

                int action_cnt = aevent->action_cnt;
                int recur = alarm_event_is_recurring (aevent);
                if (((m_alarmFilter == 2) || ((m_alarmFilter == 1) && (action_cnt > 1)) || ((m_alarmFilter == 0) && (action_cnt == 2)))
                    && ((m_showRecurrent) || ((!m_showRecurrent) && (!recur))))
                {


                    bool toAdd = false;
                    time_t ttime = alarm_event_get_trigger(aevent);
                    if (recur > 0) // find recurrent alarms
                    {
                        if (aevent->recurrence_cnt > 0)
                        {
                            toAdd = true;
//                            alarm_recur_t* arecur = &aevent->recurrence_tab[0];
  //                          const char* tz = alarm_event_get_alarm_tz(aevent);
    //                        struct tm* rtm = localtime(&now);
      //                      ttime = alarm_recur_next(arecur,rtm,tz);
                            item->setIcon(icnRecur);
                        }
                    }
                    else // simple alarms
                    {
                        toAdd = true;
        //                struct tm* rtm = localtime(&now);
          //              struct tm atm;
            //            alarm_event_get_time (aevent,&atm);
              //          rtm->tm_hour = atm.tm_hour;
                //        rtm->tm_min = atm.tm_min;
                  //      ttime = mktime(rtm);
                        item->setIcon(icn);
                    }

                    if (action_cnt == 1)
                        item->setIcon(icnEvent);
                    if (action_cnt == 3)
                        item->setIcon(icnCalendar);

                    if (toAdd) // preparing display string
                    {
                        aFound = true;

                        QDateTime qdtm = QDateTime::fromTime_t(ttime);
                        QTime qtm = qdtm.time();
                        int days = 0;
                        QDateTime currDate;
                        if (m_timeFrame > 24) // time can be more then one day
                        {
                            currDate = QDateTime::currentDateTime();
                            int secs = currDate.secsTo(qdtm);
                            days = secs / (60 * 60 * 24);
                        }

                        QString sTime;

                        sTime = qtm.toString(Qt::DefaultLocaleShortDate);
                        if ((days > 0) || (m_showRemain))
                            sTime += " (";
                        if (days > 0) // calc for more than 1 day alarms
                        {
                            sTime += QString::number(days) + tr("d");
                            if (m_showRemain)
                                sTime += " ";
//                            QDate qdt = qdtm.date();
  //                          sTimeDay = qdt.toString(Qt::DefaultLocaleLongDate);
                        }
//                        else
  //                      {

                            if (m_showRemain) // calc remaining time
                            {
                                QTime currTime = QTime::currentTime();
                                int remain = currTime.secsTo(qtm);
                                if (remain < 0) remain += 86400;
                                int h = remain/3600;
                                int m = (remain - h*3600)/60;
                                QTime remTime(h,m);
//                                QString sRemTime =
                                sTime += remTime.toString("H:mm");
                            }
             //           }
                        if ((days > 0) || (m_showRemain))
                            sTime += ")";

                        if (m_showTitle) // show title of alarm
                        {
                            QString aTitle;
                            const char * cTitle = alarm_event_get_message(aevent);
                            aTitle = QString::fromUtf8(cTitle);
                            if (aTitle.isEmpty())
                            {
                                cTitle = alarm_event_get_title(aevent);
                                aTitle = QString::fromUtf8(cTitle);
                                if (aTitle.isEmpty())
                                {
                                    cTitle = alarm_event_get_alarm_appid(aevent);
                                    aTitle = QString::fromUtf8(cTitle);
                                }
                            }
                            if (!aTitle.isEmpty())
                                sTime += ": " + aTitle;
                        }
                        item->setText(sTime);
                        ui->listWidget->addItem(item);
                    }
                }
                alarm_event_delete(aevent);
            }
    }

    free(list);
    if (!aFound) // now alarms
    {
        if (m_showIfEmpty)
        {
            QListWidgetItem * item = new QListWidgetItem;
            item->setSizeHint(QSize (m_width-fntHeight,fntHeight));
            item->setForeground(m_color);
            item->setFont(m_font);
    //        item->setText(tr("no active alarms"));
            item->setText(tr("--:--"));
            ui->listWidget->addItem(item);
        }
        else
            ui->listWidget->clear();
    }
#else
    for (int i = 0; i < 5; i++)
    {
        QListWidgetItem * item = new QListWidgetItem;
        item->setIcon(icn);
        item->setText(QString("%1:%2").arg(QString::number(12)).arg(QString::number(15+i)));
        ui->listWidget->addItem(item);
    }
#endif
}

void AlarmWindow::showClock()
{
#if  defined(Q_WS_MAEMO_5)
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr", "/com/nokia/HildonDesktop/AppMgr",
                          "com.nokia.HildonDesktop.AppMgr", bus);
    dbus_iface.call("LaunchApplication","worldclock");
#endif
}


void AlarmWindow::mouseReleaseEvent ( QMouseEvent * e )
{
    Q_UNUSED(e);
    //test Dialogs
    showClock();
}

void AlarmWindow::listClicked()
{
    showClock();
}

void AlarmWindow::showSettingsDialog()
    {
    SettingsDialog dialog(0);
    if (dialog.exec() == QDialog::Accepted) {

        dialog.dumpSettings();
        loadSettings();
        fillAlarmList();
        updateUi();
    }
}

void AlarmWindow::loadSettings()
{
    m_color = nalarmsettings::getInstance().getColor();
    m_numberAlarms = nalarmsettings::getInstance().getSize();
    m_width = nalarmsettings::getInstance().getWidth();
    m_font = nalarmsettings::getInstance().getFont();
    m_showCaption = nalarmsettings::getInstance().isShowHeader();
    m_showRemain = nalarmsettings::getInstance().isShowRemain();
    m_showTitle = nalarmsettings::getInstance().isShowTitle();
//    m_showStdOnly = nalarmsettings::getInstance().isStdOnly();

    m_showRecurrent = nalarmsettings::getInstance().isShowRecurrent();
    m_showIfEmpty = nalarmsettings::getInstance().isShowEmpty();
    m_alarmFilter = nalarmsettings::getInstance().alarmFilter();
    m_timeFrame = nalarmsettings::getInstance().timeFrame();

    float aTr = float(100-nalarmsettings::getInstance().getTransparency());
    m_transparency = aTr/100;
}

void AlarmWindow::homeScreenChanged(bool isOnCurrentHomescreen)
{
    if (m_timer->isActive())
        m_timer->stop();
    if (isOnCurrentHomescreen)
    {
        fillAlarmList();
//        updateUi();
        if (m_showRemain)
            m_timer->start(1000);
    }
}

void AlarmWindow::updateUi()
{
    int x = geometry().x();
    int y = geometry().y();
    int listHeight;
    QFontMetrics fm(m_font);
    int fntHeight = fm.height() + FNT_ADD;
    if (m_showCaption)
    {
        listHeight = ((m_numberAlarms + 1) * (fntHeight) + 20);
    }
    else
        listHeight = ((m_numberAlarms) * (fntHeight)+20);
    if (listHeight > 430 ) listHeight = 430;
    ui->listWidget->setIconSize(QSize(fntHeight/2,fntHeight/2));
    setGeometry(x,y,m_width,listHeight);
}

void AlarmWindow::paintEvent(QPaintEvent *event)
{
    Q_UNUSED(event);
    QPainter p(this);
    p.setOpacity(m_transparency);
    p.setBrush(Qt::SolidPattern);
    p.setPen(Qt::NoPen);
    p.drawRect(rect());
}
