#include <QtGui/QApplication>
#include <QLibraryInfo>
#include <QTranslator>
#include <QLocale>
#include "alarmwindow.h"
#if defined(Q_WS_MAEMO_5)
#include "qmaemo5homescreenadaptor.h"
#endif

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    // Set style for the QListWidget and QListWidgetItem
    QString style;
    style += "QListWidget {background-color: transparent;}";
    style += "QListWidget::item {background-color: transparent;}";
    style += "QListWidget::item {selection-color: white;}";
//    style += "QListWidget::item {color: black;}";
//    style += "QListWidget::item {height: 15;}";

    app.setStyleSheet(style);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
         QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    QTranslator myappTranslator;
    myappTranslator.load("nextalarm_" + QLocale::system().name(),"/opt/nextalarmwidget");
    app.installTranslator(&myappTranslator);

    AlarmWindow clock;
#if  defined(Q_WS_MAEMO_5)
    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&clock);
    adaptor->setSettingsAvailable(true);
    QObject::connect(adaptor, SIGNAL(settingsRequested()), &clock, SLOT(showSettingsDialog()));
    QObject::connect(adaptor, SIGNAL(homescreenChanged(bool)), &clock, SLOT(homeScreenChanged(bool)));
//    clock.setLineWidth(0);
    clock.show();
#else
    clock.show();
#endif

    return app.exec();

}
