#ifndef ALARMWINDOW_H
#define ALARMWINDOW_H

#include <QWidget>
#include <QTimer>

namespace Ui {
    class AlarmWindow;
}

class AlarmWindow : public QWidget
{
    Q_OBJECT

public:
    explicit AlarmWindow(QWidget *parent = 0);
    ~AlarmWindow();

public slots:
    void showSettingsDialog();
    void homeScreenChanged(bool isOnCurrentHomescreen);
    void listClicked();
    void fillAlarmList();

protected:
    void mouseReleaseEvent ( QMouseEvent * e );

private:
    void loadSettings();
    void showClock();
    void updateUi();

private:
    Ui::AlarmWindow *ui;
    int m_numberAlarms;
    int m_width;
    QFont m_font;
    QColor m_color;
    bool m_showCaption;
    bool m_showTitle;
    bool m_showRemain;
    bool m_showStdOnly;
    QTimer *m_timer;
};

#endif // ALARMWINDOW_H
