import QtQuick 2.0

import "../components"
import "../js/utils.js" as Utils

Item {
    id: eventItem

    signal userClicked()
    signal areaClicked()
    signal areaPressAndHold()

    property variant object

    //Old Values
    property string objectId: object.id
    property string venueName: object.venue.name
    property string createdAt: Utils.makeTime(object.createdAt)

    property int likesCount: object.likes.count
    property int photosCount: object.photos.count

    property string venuePhoto: Utils.makeVenueIcon(object.venue)
    property string venueAddress: Utils.parseString(object.venue.location.address)
    property bool activeWhole: true

    width: parent.width
    height: Math.max(statusTextArea.height,profileImage.height)

    ProfilePhoto {
        id: profileImage
        masked: true
        photoSize: 48
        photoUrl: venuePhoto

        onClicked: {
            eventItem.userClicked();
        }
    }

    Column {
        id: statusTextArea
        spacing: 4
        anchors {
            left: profileImage.right
            leftMargin: 12
            right: parent.right
            rightMargin: 12
        }

        Text {
            id: messageText
            color: myTheme.highlightColor
            font.pixelSize: myTheme.fontSizeSmall
            width: parent.width
            text: venueName
            wrapMode: Text.Wrap
            visible: messageText.text != ""
        }
        Row {
            width: parent.width
            spacing: 10
            Text {
                anchors.verticalCenter: parent.verticalCenter
                color: myTheme.secondaryColor
                font.pixelSize: myTheme.fontSizeExtraSmall
                text: venueAddress
                wrapMode: Text.Wrap
                visible: venueAddress.length>0
            }
            Image {
                id: photoImage
                anchors.verticalCenter: parent.verticalCenter
                source: "../pics/photocount.png"
                asynchronous: true
                smooth: true
                height: 32
                fillMode: Image.PreserveAspectFit
                visible: photosCount>0
            }
            Text {
                id: textPhotos
                anchors.verticalCenter: parent.verticalCenter
                color: myTheme.secondaryColor
                font.pixelSize: myTheme.fontSizeSmall
                text: photosCount
                visible: photosCount>0
            }
            Image {
                id: likesImage
                anchors.verticalCenter: parent.verticalCenter
                source: "../pics/venuelikes_heart.png"
                asynchronous: true
                smooth: true
                height: 32
                fillMode: Image.PreserveAspectFit
                visible: likesCount>0
            }
            Text {
                id: textLikes
                anchors.verticalCenter: parent.verticalCenter
                color: myTheme.secondaryColor
                font.pixelSize: myTheme.fontSizeSmall
                text: likesCount
                visible: likesCount>0
            }
            visible: createdAt.length>0 || commentsCount>0 || likesCount>0 || photosCount>0
        }
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: {
            eventItem.areaClicked();
        }
        onPressAndHold: {
            eventItem.areaPressAndHold();
        }
        visible: activeWhole
    }
}
