import QtQuick 2.0
import Sailfish.Silica 1.0

import "../components"

import "../js/api.js" as Api

PageWrapper {
    id: loginDialog
    signal finished(string url)
    signal loadFailed()
    anchors.fill: parent

    headerText: qsTr("Sign In to Foursquare")

    function load() {
        loginDialog.finished.connect(function(url) {
            var token = Api.parseAuth(url, "access_token");
            if (token!==undefined) {
                appConfig.foursquareAccessToken = token;
            }
        });
        loginDialog.loadFailed.connect(function() {
            //TODO: error loading page - show some details
            show_error(qsTr("Error connecting to Foursquare site"));
        });
        reset();
    }

    function reset() {
        loadedContent.url = Api.AUTHENTICATE_URL;
        loadedContent.reload();
    }

    content: SilicaWebView {
        id: webView
        clip: true
        url: ""

        header: PageHeader {
            title: headerText
        }

        onLoadingChanged: {
            switch(loadRequest.status) {
            case 0:
                waiting_show();
                break;
            case 1:
                waiting_hide();
                loginDialog.loadFailed();
                break;
            case 2:
                waiting_hide();
                loginDialog.finished( webView.url );
                break;
            }
        }
        /*onLoadStarted: {
            waiting_show();
        }

        onLoadFinished: {
            waiting_hide();
            loginDialog.finished( webView.url );
        }*/

        /*onLoadFailed: {
            waiting_hide();
            loginDialog.loadFailed();
        }*/
    }
}
