import QtQuick 2.0
import Sailfish.Silica 1.0

import "../components"

import "../js/api.js" as Api

PageWrapper {
    id: debuginfo
    property variant contentdata: {}

    signal submit()

    headerText: qsTr("DEBUG SUBMIT")

    onHeaderClicked: {
        //submit();
    }

    function reset() {
        shoutText.text = "";
    }

    function submitCompleted(status, message) {
        waiting_hide();
        if (!status) {
            buttonSubmit.enabled = true;
            show_info(message);
        }
        else {
            show_info(message + "<br>" + qsTr("Thank you for submit!<br>This will be implemented soon!"));
            stack.pop();
        }
    }

    onSubmit: {
        waiting_show();
        Api.submitDebugInfo(contentdata, submitCompleted);
    }

   tools: Component {
        PullDownMenu {
            MenuItem {
                text: qsTr("SUBMIT")
                onClicked: {
                    enabled = false;
                    debuginfo.submit();
                }
            }
        }
    }

    content: SilicaFlickable {
        id: flickableArea

        clip: true
        pressDelay: 0

        contentHeight: items.height

        Column {
            id: items
            width: parent.width
            spacing: 10

            Text {
                id: venueName
                text: qsTr("You can help me with Nelisquare development by submitting debug info.\n\nThe following information are going to be submitted:")
                width: parent.width
                wrapMode: Text.WordWrap
                font.pixelSize: myTheme.fontSizeMedium
                color: myTheme.highlightColor
            }

            TextArea {
                id: shoutText
                x: 5
                width: parent.width - 10

                text: JSON.stringify(contentdata);
                readOnly: true

                font.pixelSize: myTheme.fontSizeMedium
                color: myTheme.primaryColor

                onTextChanged: {
                    if (text.length>64000) {
                        errorHighlight = true;
                    } else {
                        errorHighlight = false;
                    }
                }
                Text {
                    anchors {
                        right: parent.right;
                        bottom: parent.bottom;
                        bottomMargin: myTheme.paddingMedium;
                        rightMargin: myTheme.paddingLarge
                    }
                    font.pixelSize: myTheme.fontSizeSmall
                    color: myTheme.secondaryColor
                    text: shoutText.text.length
                }
            }
        }
        ScrollDecorator{ flickable: loadedContent }
    }
}
