import QtQuick 2.0
import Sailfish.Silica 1.0
import "../components"

import "../js/api.js" as Api

PageWrapper {
    signal badge(variant params)

    property string userID: ""
    property alias badgeModel: badgeModel

    id: badgesPage
    width: parent.width
    height: parent.height

    headerText: qsTr("User badges")

    function load() {
        var page = badgesPage;
        page.badge.connect(function(params) {
            stack.push(Qt.resolvedUrl("BadgeInfo.qml"),params);
        });
        Api.users.loadBadges(page,userID);
    }

    ListModel {
        id: badgeModel
    }

    content: SilicaGridView {
        id: badgeGrid
        clip: true

        cellWidth: parent.width/3
        cellHeight: cellWidth
        pressDelay: 0

        model: badgeModel
        delegate: badgeDelegate
    }

    ScrollDecorator{ flickable: loadedContent }


    Component {
        id: badgeDelegate

        Column {
            width: loadedContent.cellWidth

            CacheImage {
                id: badgeImage
                width: 114
                height: 114
                sourceUncached: model.image
                anchors.horizontalCenter: parent.horizontalCenter

                MouseArea {
                    anchors.fill: badgeImage
                    onClicked: {
                        //To get rid of internal properties
                        badgesPage.badge(JSON.parse(JSON.stringify(model)));
                    }
                }
            }
            Text {
                text: model.name;
                width: parent.width
                wrapMode: Text.WordWrap
                horizontalAlignment: Text.AlignHCenter
                font.pixelSize: myTheme.fontSizeSmall
                color: myTheme.primaryColor
            }
        }
    }
}
