import QtQuick 2.0

Column {
    width: parent.width

    property string debugType: ""
    property variant debugContent: undefined


    Text {
        width: parent.width
        color: myTheme.primaryColor
        font.pixelSize: myTheme.fontSizeMedium
        text: qsTr("Unknown '%1' event!").arg(debugType)

        Image {
            anchors {
                right: parent.right
                rightMargin: 20
                top: parent.top
                topMargin: 20
            }
            source: "image://theme/icon-cover-search"
            smooth: true
            sourceSize { width: 64; height: 64 }

            MouseArea {
                anchors.fill: parent

                onClicked: {
                    appWindow.sendDebugInfo(
                        {
                            "debugType": debugType,
                            "debugContent": debugContent
                        }
                    );
                }
            }
        }

    }

    Text {
        width: parent.width
        color: myTheme.secondaryColor
        font.pixelSize: myTheme.fontSizeSmall
        text: qsTr("This event type is unknown.\nYou can help with resolution.")
    }
}
