#include "CoverDialog.h"
#include "Player.h"

CoverDialog::CoverDialog(Player* parent)
{
    this->parent = parent;
    this->setFixedHeight(370);

    trNoArtistInfo = tr("no artist info");
    trNoAlbumInfo = tr("no album info");

    currCoverDir = QDesktopServices::storageLocation(QDesktopServices::HomeLocation) + "/MyDocs";

    setWindowTitle(tr("Album art"));
    layout = new QHBoxLayout;
    labelArea = new QScrollArea();
    labelArea->setFixedHeight(48);
    labelArea->setWidgetResizable(true);
    labelWidget = new QWidget();
    labelAreaLayout = new QHBoxLayout(labelWidget);
    labelAreaLayout->setMargin(0);
    labelAreaLayout->setAlignment(Qt::AlignVCenter);
    labelArea->setWidget(labelWidget);

    label = new QLabel();
    labelAreaLayout->addWidget(label);

    cover = new QLabel();
    cover->setFixedHeight(295);

    labelAndCoverLayout = new QVBoxLayout();
    labelAndCoverLayout->setMargin(0);
    labelAndCoverLayout->addWidget(labelArea);
    labelAndCoverLayout->addWidget(cover);

    dialogButtons = new QDialogButtonBox(Qt::Vertical);
    chooseButton = new QPushButton(tr("Change"));
    deleteButton = new QPushButton(tr("Delete"));
    doneButton = new QPushButton(tr("Done"));
    dialogButtons->addButton(chooseButton, QDialogButtonBox::ActionRole);
    dialogButtons->addButton(deleteButton, QDialogButtonBox::ActionRole);
    dialogButtons->addButton(doneButton, QDialogButtonBox::ActionRole);

    layout->addLayout(labelAndCoverLayout);
    layout->addWidget(dialogButtons);

    setLayout(layout);

    connect(chooseButton, SIGNAL(clicked()), SLOT(chooseCover()));
    connect(deleteButton, SIGNAL(clicked()), SLOT(deleteCover()));
    connect(doneButton, SIGNAL(clicked()), SLOT(setCover()));

    connect(this, SIGNAL(rejected()), SLOT(hideAndReset()));
}

void
CoverDialog::getCover(int row)
{
    Media media = parent->engine->getInfos(row);
    artist = media.artist;
    album = media.album;
    QString t;
    changed = false;

    if (!artist.isEmpty() && !album.isEmpty())
    {
        QFileInfo checkFile(QDesktopServices::storageLocation(QDesktopServices::HomeLocation) +
                            "/.covers/" + artist.toLower() + " - " + album.toLower() + ".jpg");
        if (checkFile.exists())
        {
            t = QDesktopServices::storageLocation(QDesktopServices::HomeLocation) +
                    "/.covers/" + artist.toLower() + " - " + album.toLower() + ".jpg";
            QByteArray imageFormat = QImageReader::imageFormat(t);
            if (imageFormat.isEmpty())
            {
                t = QString();
            }
        }
    }
    else
    {
    }

    if (artist.isEmpty())
    {
        label->setText("<" + trNoArtistInfo + ">  -  ");
    }
    else
    {
        label->setText(artist + "  -  ");
    }
    if (album.isEmpty())
    {
        label->setText(label->text() + "<" + trNoAlbumInfo + ">");
    }
    else
    {
        label->setText(label->text() + album);
    }

    if (t.isEmpty())
    {
        cover->setPixmap(QPixmap("/opt/necroplayer2/icons/295x295/default_album.png").scaled(295, 295, Qt::KeepAspectRatio));
    }
    else
    {
        image.load(t);
        cover->setPixmap(QPixmap::fromImage(image.scaled(295, 295, Qt::KeepAspectRatio)));
    }
}

void
CoverDialog::chooseCover()
{
    if (!artist.isEmpty() && !album.isEmpty())
    {
        QString tmpfile;

        tmpfile = QFileDialog::getOpenFileName(this, "Choose album art", currCoverDir,
                                               "(*.jpg *.JPG *.jpeg *.JPEG *.png *.PNG *.gif *.GIF)");

        if (!tmpfile.isNull())
        {
            if(tmpfile.endsWith(".jpg",Qt::CaseInsensitive) ||
                    tmpfile.endsWith(".jpeg",Qt::CaseInsensitive) ||
                    tmpfile.endsWith(".png",Qt::CaseInsensitive) ||
                    tmpfile.endsWith(".gif",Qt::CaseInsensitive))
            {
                QByteArray imageFormat = QImageReader::imageFormat(tmpfile);
                if (!imageFormat.isEmpty())
                {
                    image.load(tmpfile);
                    cover->setPixmap(QPixmap::fromImage(image.scaled(295, 295, Qt::KeepAspectRatio)));
                    changed = true;
                }
            }
            QFileInfo tmpinfo(tmpfile);
            currCoverDir = tmpinfo.dir().absolutePath();
        }
    }
}

void
CoverDialog::deleteCover()
{
    image = QImage();
    cover->setPixmap(QPixmap("/opt/necroplayer2/icons/295x295/default_album.png").scaled(295, 295, Qt::KeepAspectRatio));
}

void
CoverDialog::setCover()
{
    if (image.isNull())
    {
        if (!artist.isEmpty() && !album.isEmpty())
        {
            QFileInfo checkFile(QDesktopServices::storageLocation(QDesktopServices::HomeLocation) +
                                "/.covers/" + artist.toLower() + " - " + album.toLower() + ".jpg");
            if (checkFile.exists())
            {
                QFile::remove(QDesktopServices::storageLocation(QDesktopServices::HomeLocation) +
                              "/.covers/" + artist.toLower() + " - " + album.toLower() + ".jpg");
                QFile::remove(QDesktopServices::storageLocation(QDesktopServices::HomeLocation) +
                              "/.covers/.thumbs/" + artist.toLower() + " - " + album.toLower() + ".jpg");
            }
        }
    }
    else if (changed)
    {
        image.scaled(400, 400, Qt::KeepAspectRatio).
                save(QDesktopServices::storageLocation(QDesktopServices::HomeLocation) +
                     "/.covers/" + artist.toLower() +
                     " - " + album.toLower() + ".jpg");
        image.scaled(80, 80, Qt::KeepAspectRatio).
                save(QDesktopServices::storageLocation(QDesktopServices::HomeLocation) +
                     "/.covers/.thumbs/" + artist.toLower() +
                     " - " + album.toLower() + ".jpg");
    }
    if (parent->ui->getPlaylist().getBoldRow() >= 0)
    {
        parent->engine->currentInfosUpdated(parent->ui->getPlaylist().getBoldRow());
    }
    hideAndReset();
}

void
CoverDialog::hideAndReset()
{
    hide();
    cover->setPixmap(NULL);
    label->setText(NULL);
    image = QImage();
    artist = QString();
    album = QString();
}
