#include "UIControl2.h"
#include "Player.h"

UIControl2::UIControl2(Player* parent)
{
    this->parent = parent;

    //QStyle * s = parent->style();

    buttonRandom = new QPushButton(QIcon("/etc/hildon/theme/mediaplayer/Shuffle.png"),"");
    buttonRepeat = new QPushButton(QIcon("/etc/hildon/theme/mediaplayer/Repeat.png"),"");

    buttonUp = new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/arrow_up.png"),"");
    buttonDown = new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/arrow_down.png"),"");
    buttonDel = new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/delete.png"),"");

    buttonAddOns = new QPushButton("Lyrics");
    buttonAutoAddons = new QPushButton();

    if (parent->config->autoaddons)
    {
        buttonAutoAddons->setIcon(QIcon("/opt/necroplayer2/icons/32x32/autoaddons.png"));
    }
    else
    {
        buttonAutoAddons->setIcon(QIcon("/opt/necroplayer2/icons/32x32/noautoaddons.png"));
    }

    buttonRandom->setFixedSize(72, 58);
    buttonRepeat->setFixedSize(72, 58);
    buttonUp->setFixedSize(72, 58);
    buttonDown->setFixedSize(72, 58);
    buttonDel->setFixedSize(72, 58);
    buttonAddOns->setFixedSize(144, 58);
    buttonAutoAddons->setFixedSize(72, 58);

    buttonUp->setAutoRepeat(true);
    buttonUp->setAutoRepeatDelay(1000);
    buttonUp->setAutoRepeatInterval(1000);

    buttonDown->setAutoRepeat(true);
    buttonDown->setAutoRepeatDelay(1000);
    buttonDown->setAutoRepeatInterval(1000);

    buttonDel->setAutoRepeat(true);
    buttonDel->setAutoRepeatDelay(1000);
    buttonDel->setAutoRepeatInterval(1000);

    buttonAutoAddons->setAutoRepeat(true);
    buttonAutoAddons->setAutoRepeatDelay(1000);
    buttonAutoAddons->setAutoRepeatInterval(1000);

    layoutControl2 = new QHBoxLayout;
    layoutControl2->setSpacing(0);
    layoutControl2->setMargin(6);

    buttonsMode = new QWidget();
    buttonsMode->setFixedSize(154, 60);
    layoutControlMode = new QHBoxLayout;
    layoutControlMode->setSpacing(0);
    layoutControlMode->setMargin(0);
    layoutControlMode->addWidget(buttonRandom);
    layoutControlMode->addSpacing(10);
    layoutControlMode->addWidget(buttonRepeat);
    buttonsMode->setLayout(layoutControlMode);

    buttonsPL = new QWidget();
    buttonsPL->setFixedSize(236, 60);
    layoutControlPL = new QHBoxLayout;
    layoutControlPL->setSpacing(0);
    layoutControlPL->setMargin(0);
    layoutControlPL->addWidget(buttonUp);
    layoutControlPL->addSpacing(10);
    layoutControlPL->addWidget(buttonDown);
    layoutControlPL->addSpacing(10);
    layoutControlPL->addWidget(buttonDel);
    buttonsPL->setLayout(layoutControlPL);

    buttonsAddOns = new QWidget();
    buttonsAddOns->setHidden(true);
    buttonsAddOns->setFixedSize(236, 60);
    layoutControlAddOns = new QHBoxLayout;
    layoutControlAddOns->setAlignment(Qt::AlignRight);
    layoutControlAddOns->setMargin(0);
    layoutControlAddOns->setSpacing(0);
    layoutControlAddOns->addWidget(buttonAutoAddons);
    buttonsAddOns->setLayout(layoutControlAddOns);

    layoutControl2->addWidget(buttonsMode);
    layoutControl2->addSpacing(40);
    layoutControl2->addWidget(buttonsPL);
    layoutControl2->addWidget(buttonsAddOns);
    layoutControl2->addSpacing(2);

    connect(buttonRandom, SIGNAL(pressed()), SLOT(buttonRandomPressed()));
    connect(buttonRepeat, SIGNAL(pressed()), SLOT(buttonRepeatPressed()));

    connect(buttonRandom, SIGNAL(clicked()), SLOT(buttonRandomChanged()));
    connect(buttonRepeat, SIGNAL(clicked()), SLOT(buttonRepeatChanged()));
    connect(buttonUp, SIGNAL(clicked()), SLOT(upItem()));
    connect(buttonDown, SIGNAL(clicked()), SLOT(downItem()));
    connect(buttonDel, SIGNAL(clicked()), SLOT(delItem()));
    connect(buttonAutoAddons, SIGNAL(clicked()), SLOT(buttonAutoAddonsChanged()));

    connect(buttonUp, SIGNAL(released()), SLOT(buttonUpReleased()));
    connect(buttonDown, SIGNAL(released()), SLOT(buttonDownReleased()));
    connect(buttonDel, SIGNAL(released()), SLOT(buttonDelReleased()));
    connect(buttonAutoAddons, SIGNAL(released()), SLOT(buttonAutoAddonsReleased()));

    this->setLayout(layoutControl2);
}

UIControl2::~UIControl2()
{
    if (buttonRandom)
        delete buttonRandom;
    if (buttonRepeat)
        delete buttonRepeat;
    if (buttonUp)
        delete buttonUp;
    if (buttonDown)
        delete buttonDown;
    if (buttonDel)
        delete buttonDel;
    //if (buttonClear)
    //    delete buttonClear;
    if (layoutControl2)
        delete layoutControl2;
}

void
UIControl2::buttonsToggle()
{
    buttonsPL->setHidden(!buttonsPL->isHidden());
    buttonsAddOns->setHidden(!buttonsAddOns->isHidden());
}

void
UIControl2::buttonRandomPressed()
{
    buttonRandom->setIcon(QIcon("/etc/hildon/theme/mediaplayer/ShufflePressed.png"));
}

void
UIControl2::buttonRandomChanged()
{
    if (parent->config->random)
    {
        parent->config->random = false;
        buttonRandom->setIcon(QIcon("/etc/hildon/theme/mediaplayer/Shuffle.png"));
    }
    else
    {
        parent->config->random = true;
        buttonRandom->setIcon(QIcon("/etc/hildon/theme/mediaplayer/ShufflePressed.png"));
    }
}

void
UIControl2::buttonRepeatPressed()
{
    buttonRepeat->setIcon(QIcon("/etc/hildon/theme/mediaplayer/RepeatPressed.png"));
}

void
UIControl2::buttonRepeatChanged()
{
    if (parent->config->repeat)
    {
        parent->config->repeat = false;
        buttonRepeat->setIcon(QIcon("/etc/hildon/theme/mediaplayer/Repeat.png"));
    }
    else
    {
        parent->config->repeat = true;
        buttonRepeat->setIcon(QIcon("/etc/hildon/theme/mediaplayer/RepeatPressed.png"));
    }
}

void UIControl2::upItem()
{
    if (buttonUp->isDown())
    {
        buttonUp->setAutoRepeat(false);
        parent->ui->topItem();
    }
    else if (buttonUp->autoRepeat())
    {
        parent->ui->upItem();
    }
}

void UIControl2::downItem()
{
    if (buttonDown->isDown())
    {
        buttonDown->setAutoRepeat(false);
        parent->ui->bottomItem();
    }
    else if (buttonDown->autoRepeat())
    {
        parent->ui->downItem();
    }
}

void UIControl2::delItem()
{
    if (buttonDel->isDown())
    {
        buttonDel->setAutoRepeat(false);
        parent->ui->buttonClearPlaylist();
    }
    else if (buttonDel->autoRepeat())
    {
        parent->ui->delItem();
    }
}

void
UIControl2::buttonAutoAddonsChanged()
{
    if (buttonAutoAddons->isDown())
    {
        buttonAutoAddons->setAutoRepeat(false);
        int row = parent->ui->getPlaylist().getBoldRow();
        if (row > -1)
            parent->ui->openCoverDialog(row);
    }
    else if (buttonAutoAddons->autoRepeat())
    {
        if (parent->config->autoaddons)
        {
            parent->config->autoaddons = false;
            buttonAutoAddons->setIcon(QIcon("/opt/necroplayer2/icons/32x32/noautoaddons.png"));
        }
        else
        {
            parent->config->autoaddons = true;
            buttonAutoAddons->setIcon(QIcon("/opt/necroplayer2/icons/32x32/autoaddons.png"));
        }
    }
}

void
UIControl2::buttonUpReleased()
{
    if (!buttonUp->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonUpEnableAutoRepeat", Qt::QueuedConnection);
}

void
UIControl2::buttonUpEnableAutoRepeat()
{
    buttonUp->setAutoRepeat(true);
}

void
UIControl2::buttonDownReleased()
{
    if (!buttonDown->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonDownEnableAutoRepeat", Qt::QueuedConnection);
}

void
UIControl2::buttonDownEnableAutoRepeat()
{
    buttonDown->setAutoRepeat(true);
}

void
UIControl2::buttonDelReleased()
{
    if (!buttonDel->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonDelEnableAutoRepeat", Qt::QueuedConnection);
}

void
UIControl2::buttonDelEnableAutoRepeat()
{
    buttonDel->setAutoRepeat(true);
}

void
UIControl2::buttonAutoAddonsReleased()
{
    if (!buttonAutoAddons->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonAutoAddonsEnableAutoRepeat", Qt::QueuedConnection);
}

void
UIControl2::buttonAutoAddonsEnableAutoRepeat()
{
    buttonAutoAddons->setAutoRepeat(true);
}
