# -*- coding: utf-8 -*-

"""
Module implementing MainWindow.
"""

from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import pyqtSignature

from Ui_calc import Ui_MainWindow

    
class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """

    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        
    operand1=0
    operand2=0
    stackpointer=1
    displaystring=''
    operator=''
    error=0
    csign=1
    pointset=0
    memory=0
    lastkey='='
    
    @pyqtSignature("")
    def on_pushButton_1_pressed(self):
        """
        The 1 key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'1'
            self.lcd.setText(self.displaystring)
            self.lastkey='1'

    @pyqtSignature("")
    def on_pushButton_2_pressed(self):
        """
        The 2 key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'2'
            self.lcd.setText(self.displaystring)
            self.lastkey='2'
    
    @pyqtSignature("")
    def on_pushButton_3_pressed(self):
        """
        Slot documentation goes here.
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'3'
            self.lcd.setText(self.displaystring)
            self.lastkey='3'
    
    @pyqtSignature("")
    def on_pushButton_4_pressed(self):
        """
        The 4 Key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'4'
            self.lcd.setText(self.displaystring)
            self.lastkey='4'
            
    @pyqtSignature("")
    def on_pushButton_5_pressed(self):
        """
        The 5 Key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'5'
            self.lcd.setText(self.displaystring)
            self.lastkey='5'
    
    @pyqtSignature("")
    def on_pushButton_6_pressed(self):
        """
        The 6 Key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'6'
            self.lcd.setText(self.displaystring)
            self.lastkey='6'
    
    @pyqtSignature("")
    def on_pushButton_7_pressed(self):
        """
        The 7 key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'7'
            self.lcd.setText(self.displaystring)
            self.lastkey='7'
    
    @pyqtSignature("")
    def on_pushButton_8_pressed(self):
        """
        The 8 Key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'8'
            self.lcd.setText(self.displaystring)
            lastkey='8'
    
    @pyqtSignature("")
    def on_pushButton_9_pressed(self):
        """
        The 9 Key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'9'
            self.lcd.setText(self.displaystring)
            self.lastkey='9'
            
    @pyqtSignature("")
    def on_pushButton_0_pressed(self):
        """
        The 0 Key is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if len(self.displaystring)<12:
            self.displaystring=self.displaystring+'0'
            self.lcd.setText(self.displaystring)
            self.lastkey='0'
            
    @pyqtSignature("")
    def on_pushButton_CS_pressed(self):
        """
        The Change Sign Key is pressed
        """
   
        if len(self.displaystring)>0:
            if float(self.displaystring)!= 0:
           
                self.csign=self.csign*-1
                if  self.csign == -1:
                    self.displaystring='-'+self.displaystring
                if  self.csign== 1:
                    self.displaystring=self.displaystring.replace('-', '')

                self.lcd.setText(self.displaystring)
        else:
             if  self.operand2!=0:
                 #self.csign=self.csign*-1
                 self.operand2=self.operand2*-1
                 #print self.csign
                 #print self.operand2
                 self.lcd.setText(str(self.operand2))
        self.lastkey='cs'
            
            
            
    @pyqtSignature("")
    def on_pushButton_point_pressed(self):
        """
        The Decimal point key is pressed
        """ 
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        if self.pointset==0: 
             self.pointset=1
             if len(self.displaystring)==0: self.displaystring='0'
             self.displaystring=self.displaystring+'.'
             self.lcd.setText(self.displaystring)
        self.lastkey='.'
    
    @pyqtSignature("")
    def on_pushButton_mul_pressed(self):
        """
        The Multiply button is pressed
        """
        self.dobigsum()
        self.operator='x'
        self.lastkey='x'
        
    @pyqtSignature("")
    def on_pushButton_div_pressed(self):
        """
        The Divide Button is pressed
        """
        self.dobigsum()
        self.operator='/'
        self.lastkey='/'
    
    @pyqtSignature("")
    def on_pushButton_add_pressed(self):
        """
        The Plus Button is pressed
        """
        self.dobigsum()
        self.operator='+'
        self.lastkey='+'
    
    @pyqtSignature("")
    def on_pushButton_sub_pressed(self):
        """
        The Subtract Button is pressed
        """
        self.dobigsum()
        self.operator='-'
        self.lastkey='-'
    
    @pyqtSignature("")
    def on_pushButton_c_pressed(self):
        """
        The Cancel Button is pressed
        """
        self.displaystring=('')
        self.operand1=0
        self.operand2=0
        self.lcd.setText('0')
        if self.memory==0:self.lcd2.setText('')
        self.stackpointer=1
        self.csign=1
        self.pointset=0
        self.lastkey='c'
    
    @pyqtSignature("")
    def on_pushButton_m_pressed(self):
        """
        The Memory Button is pressed
        """
        if len(self.displaystring)>0: self.memory=float(self.displaystring)
        else :self.memory=self.operand2
        if self.memory==0:self.lcd2.setText('')
        else:self.lcd2.setText('M')
        self.lastkey='m'
        
        
     
    
    @pyqtSignature("")
    def on_pushButton_r_pressed(self):
        """
        The Memory Recall  Button is pressed
        """
        if self.lastkey=='=' or self.lastkey=='r': self.on_pushButton_c_pressed()
        self.displaystring=str(self.memory)
        self.lcd.setText(self.displaystring)
        if self.memory<0:self.csign=-1
        self.pointset=1
        self.lastkey='r'
        
        
         
    @pyqtSignature("")
    def on_pushButton_equ_pressed(self):
        """
        The Equal key is Pressed
        """
        self.dobigsum()
        self.operator='='
        #self.displaystring=('')
        #self.operand1=0
        #self.operand2=0
        #self.lcd.setText('0')
        #iself.stackpointer=1
        #self.csign=1
        #self.pointset=0
        self.lastkey='='
        
    @pyqtSignature("")
    def dodivision(self):
        """
        Handle divide by Zero errors
        """
        try : self.operand2=self.operand2/self.operand1
        except ZeroDivisionError:
         self.error=1   
    
    @pyqtSignature("")
    def dosum(self):
        """
        does the sum dependant on the operand
        """
        if self.operator=='+': self.operand2=self.operand2+self.operand1
        if self.operator=='-':  self.operand2=self.operand2-self.operand1
        if self.operator=='x': self.operand2=self.operand2*self.operand1
        if self.operator=='/':  self.dodivision()
        #if self.operator=='=':print "last operator was equal"
                                         
        self.operand1=0
        if self.error==0: self.lcd.setText(str(self.operand2))
    
        else:
                 self.lcd.setText('div 0')
                 self.error=0
  
  
    @pyqtSignature("")
    def dobigsum(self):
        """
        Handle maths operations on keys
        """
       # if self.operator=='=':self.stackpointer=1
        if len(self.displaystring)>0: self.operand1=float(self.displaystring)
        
        if self.stackpointer==1: 
                     self.operand2=self.operand1
                     self.operand1=0
                     self.lcd.setText(str(self.operand2))
        else :
                 self.dosum()
        self.displaystring=''
        self.stackpointer=2
        self.pointset=0
        self.csign=1
        #print "stackpointer", self.stackpointer

    @pyqtSignature("")
    def on_Red_triggered(self):
        """
        Change the Display Colour to Red
        """
        self.lcd.setStyleSheet("""color: rgb(255,50,14); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
        
    @pyqtSignature("")
    def on_Green_triggered(self):
        """
        Slot documentation goes here.
        """
        self.lcd.setStyleSheet("""color: rgb(42,211,26); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
    
    @pyqtSignature("")
    def on_Orange_triggered(self):
        """
        Slot documentation goes here.
        """
        self.lcd.setStyleSheet("""color: rgb(238,156,14); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
    
    
    @pyqtSignature("")
    def on_White_triggered(self):
        """
        Slot documentation goes here.
        """
        self.lcd.setStyleSheet("""color: rgb(255,255,255); border-width:0px;background-image:none; background-image:url(:/images/transparent.png);""")
    






def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
    





