# -*- coding: utf-8 -*-

"""
DataModel:
    Book{"id":int,
        "name":string,
        "author":string,
        "websiteId":int,    [for UMD, should be 0]
        "websiteName":string,   [for UMD, should be "UMD"]
        "url":string,    //the index page's url [for UMD, should be full file name]
        "lastModified":string,    //headers attr
                [for UMD, store start position of ziped parts,
                for example:"680, 21180"]
        "eTag":string,    //headers attr
                [for UMD, store the length of ziped parts,
                for example:"20461, 4663"]
        "stopUpdate":bool,    //if false, this book will no be updated
        "autoDownload":bool,    //if true, all chapters will be downloaded automatically,
                                    except the chapters which
                                    filtered==ture, downloadable==false, downloaded=true
                                  if false, it will just show the chapters to let you
                                      choose which to download
        "createDate":datetime,  [for UMD, should be the import time]
        "updateDate":datetime,  [for UMD, should be the publish date of the book]
        "chapterNum":int,    //the number of all chapters, except the filtered
        "unreadChapterNum":int,    //the number of all unread chapters
        "downloadedChapterNum":int,    //the number of all downloaded chapters
        "sequence":int, //the sequence number of this book in the book list,ABANDONED
                [for UMD, store the md5 value of the file]
        "lastViewedChapterId":int //the last viewed chapter's id of the book
        }

    Chapter("id":int,
        "bookId":int,
        "sequence":int,    //the sequence number of this chapter in the book
        "title":string,
        "url":string,   [for UMD, store the start position of the chapter]
        "filename":string,    //the filename of this chapter on disk, should be bookId_id.html
                        [for UMD, store the content of the chapter at the runtime]
        "readed":bool,
        "downloaded":bool,
        "downloadable":bool,    //if false, this chapter will not be downloaded
        "filtered":bool,        //if ture, this chapter will not show in the list window
        "downloadDate":datetime,
        }
"""

__author__ = "Michael"
__date__ = "$2010-1-19 20:29:42$"

#import logging
import string
import md5
from datetime import datetime



CONF_DIR="/home/user/.n3dr/"
CONF_FILE_PATH="/home/user/.n3dr/config"
DB_FILE_PATH="/home/user/.n3dr/n3dr.db"
DEFAULT_DOWNLOADS_PATH="/home/user/MyDocs/n3dr_downloads/"
INSTALL_PATH="/opt/n3dr/"
WEBSITE_DB_NAME="n3dr_w.db"
TEMPLATE_FILE_NAME="template.html"
NO_CONTENT_FILE_NAME="no_content.html"

BOOK_NAME_PLACE_HOLDER="$bookName$"
TITLE_PLACE_HOLDER = "$TITLE"
CONTENT_PLACE_HOLDER = "$CONTENT"
PIC_PLACE_HOLDER="$PIC"
PIC_STRING='<center><img src="$PIC" /></center>'

UMD_WEBSITE_ID=0
UMD_WEBSITE_NAME="UMD"

SQL_DROP_BOOKS_TABLE="""
DROP TABLE IF EXISTS books;
"""
SQL_DROP_CHAPTERS_TABLE="""
DROP TABLE IF EXISTS chapters;
"""
SQL_CREATE_BOOKS_TABLE="""
CREATE TABLE [books]
(
[id] INTEGER PRIMARY KEY AUTOINCREMENT,
[name] VARCHAR NOT NULL,
[author] VARCHAR,
[website_id] INTEGER NOT NULL,
[website_name] VARCHAR,
[url] VARCHAR NOT NULL,
[last_modified] VARCHAR,
[etag] VARCHAR,
[stop_update] BOOLEAN NOT NULL DEFAULT 'false',
[auto_download] BOOLEAN NOT NULL DEFAULT 'false',
[create_date] DATETIME NOT NULL,
[update_date] DATETIME,
[chapter_num] INTEGER NOT NULL DEFAULT 0,
[unread_chapter_num] INTEGER NOT NULL DEFAULT 0,
[sequence] INTEGER NOT NULL DEFAULT 0,
[last_viewed_chapter_id] INTEGER NOT NULL DEFAULT 0,
[downloaded_chapter_num] INTEGER NOT NULL DEFAULT 0
);
"""
SQL_CREATE_CHAPTERS_TABLE="""
CREATE TABLE [chapters]
(
[id] INTEGER PRIMARY KEY AUTOINCREMENT,
[book_id] INTEGER REFERENCES [books](id),
[sequence] INTEGER NOT NULL,
[title] VARCHAR NOT NULL,
[url] VARCHAR NOT NULL,
[filename] VARCHAR,
[readed] BOOLEAN NOT NULL DEFAULT 'false',
[downloaded] BOOLEAN NOT NULL DEFAULT 'false',
[downloadable] BOOLEAN NOT NULL DEFAULT 'true',
[filtered] BOOLEAN NOT NULL DEFAULT 'false',
[download_date] DATETIME
);

"""

def generate_md5(file):
    fa=open(file,"rb")
    sample=fa.read(1024)
    return md5.new(sample).digest()

def build_website_from_row(values):
#    logger = logging.getLogger('Utils.build_website_from_row')
#    logger.debug(values)
    if values == None:
        result = None
    else:
        result = {}
        result["id"] = values["id"]
        result["name"] = values["name"]
        result["indexUrl"] = values["index_url"]
        result["searchUrl"] = values["search_url"]
        result["catalogStartSign"] = values["catalog_start_sign"]
        result["catalogEndSign"] = values["catalog_end_sign"]
        result["chapterStartSign"] = values["chapter_start_sign"]
        result["chapterEndSign"] = values["chapter_end_sign"]
        result["searchStartSign"] = values["search_start_sign"]
        result["searchEndSign"] = values["search_end_sign"]
        result["enabled"]=values["enabled"]
        result["filterWords"] = []
        if values["filter_words"] is not None and len(values["filter_words"]) > 0:
            result["filterWords"] = values["filter_words"].split("|")
        result["chapterTagsToKeep"] = []
        if values["chapter_tags_to_keep"] is not None and len(values["chapter_tags_to_keep"]) > 0:
            result["chapterTagsToKeep"] = values["chapter_tags_to_keep"].split("|")
        result["chapterTagsToRemove"] = []
        if values["chapter_tags_to_remove"] is not None and len(values["chapter_tags_to_remove"]) > 0:
            result["chapterTagsToRemove"] = values["chapter_tags_to_remove"].split("|")
        result["catalogTagsToKeep"] = []
        if values["catalog_tags_to_keep"] is not None and len(values["catalog_tags_to_keep"]) > 0:
            result["catalogTagsToKeep"] = values["catalog_tags_to_keep"].split("|")
        result["catalogTagsToRemove"] = []
        if values["catalog_tags_to_remove"] is not None and len(values["catalog_tags_to_remove"]) > 0:
            result["catalogTagsToRemove"] = values["catalog_tags_to_remove"].split("|")
        result["searchTagsToKeep"] = []
        if values["search_tags_to_keep"] is not None and len(values["search_tags_to_keep"]) > 0:
            result["searchTagsToKeep"] = values["search_tags_to_keep"].split("|")
        result["searchTagsToRemove"] = []
        if values["search_tags_to_remove"] is not None and len(values["search_tags_to_remove"]) > 0:
            result["searchTagsToRemove"] = values["search_tags_to_remove"].split("|")
        result["searchResultPattern"] = []
        if values["search_result_pattern"] is not None and len(values["search_result_pattern"]) > 0:
            result["searchResultPattern"] = values["search_result_pattern"].split("|")
#    logger.debug(result)
    return result

def build_book_from_row(values):
#    logger = logging.getLogger('Utils.build_book_from_row')
#    logger.debug(values)
    if values == None:
        result = None
    else:
        result = {}
        result["id"] = values["id"]
        result["name"] = values["name"]
        result["author"] = values["author"]
        result["websiteId"] = values["website_id"]
        result["websiteName"] = values["website_name"]
        result["url"] = values["url"]
        result["lastModified"] = values["last_modified"]
        result["eTag"] = values["etag"]
        result["stopUpdate"] = values["stop_update"]
        result["autoDownload"] = values["auto_download"]
        result["createDate"] = values["create_date"]
        result["updateDate"] = values["update_date"]
        result["chapterNum"] = values["chapter_num"]
        result["unreadChapterNum"] = values["unread_chapter_num"]
        result["downloadedChapterNum"] = values["downloaded_chapter_num"]
        result["sequence"] = values["sequence"]
        result["lastViewedChapterId"] = values["last_viewed_chapter_id"]
#    logger.debug(result)
    return result

def build_chapter_from_row(values):
#    logger = logging.getLogger('Utils.build_chapter_from_row')
#    logger.debug(values)
    if values == None:
        result = None
    else:
        result = {}
        result["id"] = values["id"]
        result["bookId"] = values["book_id"]
        result["sequence"] = values["sequence"]
        result["title"] = values["title"]
        result["url"] = values["url"]
        result["filename"] = values["filename"]
        result["readed"] = values["readed"]
        result["downloaded"] = values["downloaded"]
        result["downloadable"] = values["downloadable"]
        result["filtered"] = values["filtered"]
        result["downloadDate"] = values["download_date"]
#    logger.debug(result)
    return result

def build_a_default_book():
#    logger = logging.getLogger('Utils.build_a_default_book')
    result = {}
    result["id"] = None
    result["name"] = None
    result["author"] = None
    result["websiteId"] = None
    result["websiteName"] = None
    result["url"] = None
    result["lastModified"] = None
    result["eTag"] = None
    result["stopUpdate"] = 0
    result["autoDownload"] = 1
    result["createDate"] = datetime.now()
    result["updateDate"] = None
    result["chapterNum"] = 0
    result["downloadedChapterNum"] = 0
    result["unreadChapterNum"] = 0
    result["sequence"] = 0
    result["lastViewedChapterId"] = -1
#    logger.debug(result)
    return result

def build_a_default_chapter():
#    logger = logging.getLogger('Utils.build_a_default_chapter')
    result = {}
    result["id"] = None
    result["bookId"] = None
    result["sequence"] = None
    result["title"] = None
    result["url"] = None
    result["filename"] = None
    result["readed"] = 0
    result["downloaded"] = 0
    result["downloadable"] = 0
    result["filtered"] = 0
    result["downloadDate"] = None
#    logger.debug(result)
    return result

def get_context_of_index_url(url):
    #get context part of a url, i.e "www.michaelwong.cn/context/index.html",
    #the context part is "www.michaelwong.cn/context/"
    #return value starts with "http://", end with "/"
#    logger = logging.getLogger('Utils.get_context_of_index_url')
#    logger.debug(url)
    if url == None or url == "":
        return None
    if string.find(url, "http://") != 0:
        url = "http://" + url
    pieces = url.split("/")
    if pieces[-1] != None and pieces[-1] != "":
        if string.find(pieces[-1], ".") == -1:
            url = url + "/"
        else:
            url = url[0:-len(pieces[-1])]
#    logger.debug(url)
    return url

def generate_chapter_url(indexUrl, chapterLink):
    # use index page url and chapter page link to build a complete chapter page url
    #i.e indexUrl="www.michaelwong.cn/context/index.html", chapterLink="1.html"
    #it will generate "http://www.michaelwong.cn/context/1.html"
    #return value start with "http://"
#    logger = logging.getLogger('Utils.generate_chapter_url')
#    logger.debug(indexUrl)
#    logger.debug(chapterLink)
    result = ""
    if string.find(chapterLink, "http://") == 0:
        result = chapterLink
    else:
        result = get_context_of_index_url(indexUrl) + chapterLink
#    logger.debug(result)
    return result

FONT_COLOR_BLACK="000000"
FONT_COLOR_WHITE="ffffff"
BG_COLOR_BLACK="000000"
BG_COLOR_BLUE="E7F4FE"

FONT_COLOR_PLACE_HOLDER = "$FONTCOLOR"
BG_COLOR_PLACE_HOLDER = "$BGCOLOR"

CONTENT_HTML="""
<HTML>
    <HEAD>
        <META http-equiv=Content-Type content="text/html; charset=gbk">
        <title>$TITLE</title>
    </HEAD>
    <BODY text=#$FONTCOLOR Bgcolor=#$BGCOLOR leftMargin=0 topMargin=0 marginheight=0 marginwidth=0 style='word-break:break-all'>
        <table border="0" cellpadding="0" cellspacing="0" width=100% id=main>
            <tr> <td width="100%" align="left" valign="top">
                    <br><br>
                </td></tr> <TR vAlign=center align=left>
                <TD valign="top" align="left">
                    <TABLE cellSpacing=0 cellPadding=0 align=center border="0" style="line-height:150%;" WIDTH="90%">
                        <TBODY> <TR vAlign=top align=left>
                                <TD>
                                    <div align="left" style="width: 100%; height: 132">
                                        <p align="left">
                                        <center>
                                            <span style="font-size:18pt;">$TITLE</span>
                                        </center>
                                        <br>
                                        <br>
                                        <span style="font-size:18pt;line-height:150%;">
                                            <!--BookContent Start-->
                                            $CONTENT
                                            <!--BookContent End-->
                                        </span>
                                        <br>
                                        <br>
                                        </div>
                                    <center>
                                    </center></TD></TR> </TBODY> </TABLE></TD></TR> </table>
        <br>
    </BODY></HTML>
"""

NO_CONTENT_HTML2="""
<HTML>
    <HEAD>
        <META http-equiv=Content-Type content="text/html; charset=gbk">
        <title>404</title>
    </HEAD>
    <BODY leftMargin=0 topMargin=0 marginheight=0 marginwidth=0>
        <table border="0" cellpadding="0" cellspacing="0" width=100%>
            <tr> <td width="100%" align="left" valign="top">
                    <br><br>
                </td></tr>
                 <TR>
                    <TD align="center" style="font-size:18pt;">
                                        <br>
                                            404
                                        <br>
                                        <br>
                                            该章节尚未下载，无法显示，请点击下载。
                                            或点击载入原始网页。
                                        <br>
                                        <br>
                    </TD></TR>
        </table>
        <br>
    </BODY></HTML>
"""

NO_CONTENT_HTML="""
<HTML>
    <HEAD>
        <META http-equiv=Content-Type content="text/html; charset=gbk">
        <title>404</title>
    </HEAD>
    <BODY text=#$FONTCOLOR Bgcolor=#$BGCOLOR leftMargin=0 topMargin=0 marginheight=0 marginwidth=0>
        <table border="0" cellpadding="0" cellspacing="0" width=100%>
            <tr> <td width="100%" align="left" valign="top">
                    <br><br>
                </td></tr>
                 <TR>
                    <TD align="center" style="font-size:18pt;">
                                        <br>
                                            404
                                        <br>
                                        <br>
                                            该章节尚未下载，无法显示，请点击下载。
                                            或点击载入原始网页。
                                        <br>
                                        <br>
                    </TD></TR>
        </table>
        <br>
    </BODY></HTML>
"""

