# -*- coding: utf-8 -*-

import time
from PyQt4.QtCore import *

class Logger(QObject):

    def __init__(self,ui,level=2,debug_mode=0,parent=None):
        #level: 1 DEBUG,2 INFO,3 WARNING,4 ERROR
        super(Logger, self).__init__(parent)
        self.ui = ui
        self.level=level
        self.debug_mode = debug_mode
        self.span_end = "</style>"
        
    def span_start(self, color):
        return "<span style=\"color:" + color + ";\">"
    
    def generate_timestamp(self):
        localtime = time.localtime()
        hour = localtime.tm_hour
        if hour < 10:
            hour = "0" + str(hour)
        minute = localtime.tm_min
        if minute < 10:
            minute = "0" + str(minute)
        second = localtime.tm_sec
        if second < 10:
            second = "0" + str(second)
        timestamp = "%s:%s:%s" % (hour, minute, second)
        return timestamp
        
    def join_message(self, msg, param):
        msg_join = msg + " %s" % param
        return msg_join

    def debug(self, message, param = None):
        if self.level==1:
            if param != None:
                message = self.join_message(message, param)
            timestamp = self.generate_timestamp()
            post_timestamp = " ---"
            category = "[DEBUG]:"
            html_message = timestamp + self.span_start("white") + post_timestamp + self.span_end + self.span_start("black") + category + " " + str(message) + self.span_end
            self.log(html_message, timestamp, post_timestamp, category, message)
        
    def info(self, message, param = None):
        if self.level<=2:
            if param != None:
                message = self.join_message(message, param)
            timestamp = self.generate_timestamp()
            post_timestamp = " ---"
            category = "[INFO]:"
            html_message = timestamp + self.span_start("white") + post_timestamp + self.span_end + self.span_start("black") + category + " " +str(message) + self.span_end
            self.log(html_message, timestamp, post_timestamp, category, message)

    def warning(self, message, param = None):
        if self.level<=3:
            if param != None:
                message = self.join_message(message, param)
            timestamp = self.generate_timestamp()
            post_timestamp = " "
            category = "[WARNING]:"
            html_message = timestamp + post_timestamp + self.span_start("#cdbc2a") + category + " " + str(message) + self.span_end
            self.log(html_message, timestamp, post_timestamp, category, message)
        
    def error(self, message, param = None):
        if self.level<=4:
            if param != None:
                message = self.join_message(message, param)
            timestamp = self.generate_timestamp()
            post_timestamp = " --"
            category = "[ERROR]:"
            html_message = timestamp + self.span_start("white") + post_timestamp + self.span_end + self.span_start("red") + category + " " +str(message) + self.span_end
            self.log(html_message, timestamp, post_timestamp, category, message)
            
    def log(self, html_message, timestamp, post_timestamp, category, message):
        if self.ui != None:
#            self.ui.write(html_message)
            self.emit(SIGNAL("log(QString)"), html_message)
        if self.debug_mode:
            print "%s%s%s %s" % (timestamp, post_timestamp, category, message)
#
#    def auth(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " ---"
#        category = "[AUTH]:"
#        html_message = timestamp + self.span_start("white") + post_timestamp + self.span_end + self.span_start("green") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
#
#    def config(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " -"
#        category = "[CONFIG]:"
#        html_message = timestamp + self.span_start("white") + post_timestamp + self.span_end + self.span_start("purple") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
#
#    def network(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " "
#        category = "[NETWORK]:"
#        html_message = timestamp + post_timestamp + self.span_start("blue") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
#
#    def network_error(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " "
#        category = "[NETWORK ERROR]:"
#        html_message = timestamp + post_timestamp + self.span_start("red") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
#
#    def sync(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " ---"
#        category = "[SYNC]:"
#        html_message = timestamp + self.span_start("white") + post_timestamp + self.span_end + self.span_start("blue") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
#
#    def sync_error(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " "
#        category = "[SYNC ERROR]:"
#        html_message = timestamp + post_timestamp + self.span_start("red") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
#
#    def transfer(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " "
#        category = "[TRANSFER]:"
#        html_message = timestamp + post_timestamp + self.span_start("blue") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
#
#    def transfer_error(self, message, param = None):
#        if param != None:
#            message = self.join_message(message, param)
#        timestamp = self.generate_timestamp()
#        post_timestamp = " "
#        category = "[TRANSFER ERROR]:"
#        html_message = timestamp + post_timestamp + self.span_start("red") + category + " " + message + self.span_end
#        self.log(html_message, timestamp, post_timestamp, category, message)
        


