# -*- coding: utf-8 -*-
'''
Created on 2010-1-17

@author: Michael


'''
import sqlite3
import Utils
import os

class DAO():
    def __init__(self,logger):
#        self.logger = logging.getLogger('DAO')
        self.logger=logger
        self.logger.debug("connecting to the database")
        self.check_db()
        self.con = sqlite3.connect(Utils.DB_FILE_PATH,check_same_thread=False)
        self.con.text_factory = str
        self.con.row_factory = sqlite3.Row
        self.wcon = sqlite3.connect(Utils.INSTALL_PATH+Utils.WEBSITE_DB_NAME,check_same_thread=False)
        self.wcon.text_factory = str
        self.wcon.row_factory = sqlite3.Row
        self.logger.debug("connect database completed")

    def check_db(self):
        dir=Utils.CONF_DIR
        if os.access(dir, os.W_OK) == 0:
            os.mkdir(dir)
        file=Utils.DB_FILE_PATH
        if os.access(file, os.W_OK) == 0:
            con = sqlite3.connect(file)
            c = con.cursor()
            # Create table
            c.execute(Utils.SQL_DROP_BOOKS_TABLE)
            c.execute(Utils.SQL_DROP_CHAPTERS_TABLE)
            c.execute(Utils.SQL_CREATE_BOOKS_TABLE)
            c.execute(Utils.SQL_CREATE_CHAPTERS_TABLE)
            con.commit()
            c.close()
            con.close()

    def get_connection(self):
        return self.con

    def get_w_connection(self):
        return self.wcon

    def get_a_website(self,id):
        self.logger.debug('DAO.get_a_website')
        self.logger.debug("website id: " + str(id))
        sql = """
        SELECT * FROM websites WHERE id=?
        """
        con = self.get_w_connection()
        c = con.cursor()
        c.execute(sql, (id,))
        r = c.fetchone()
        c.close()
        self.logger.debug(r)
        result = Utils.build_website_from_row(r)
        self.logger.debug(result)
        return result

    def get_all_websites(self):
        self.logger.debug('DAO.get_all_websites')
        sql = """
        SELECT * FROM websites
        """
        con = self.get_w_connection()
        c = con.cursor()
        c.execute(sql)
        rs = c.fetchall()
        self.logger.debug(rs)
        c.close()
        result = []
        for r in rs:
            self.logger.debug(r)
            website = Utils.build_website_from_row(r)
            result.append(website)
        return result

    def update_websites(self,websites):
        sql="""
            UPDATE websites SET enabled=:enabled where id=:id
        """
        con = self.get_w_connection()
        c = con.cursor()
        for website in websites:
            c.execute(sql, website)
            self.logger.debug(c.rowcount)
        con.commit()
        c.close()

    def add_a_book(self, book):
        self.logger.debug('DAO.add_a_book')
        self.logger.debug(book)
        sql = """
        INSERT INTO books ("name", "author", "website_id", "website_name",
          "url", "last_modified", "etag", "stop_update", "auto_download",
          "create_date", "update_date", "chapter_num", "unread_chapter_num",
          "downloaded_chapter_num","sequence","last_viewed_chapter_id")
          VALUES (:name,:author,:websiteId,:websiteName,:url,:lastModified,:eTag,
        :stopUpdate,:autoDownload,:createDate,:updateDate,:chapterNum,:unreadChapterNum,
        :downloadedChapterNum,:sequence,:lastViewedChapterId)
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, book)
        con.commit()
        id = c.lastrowid
        book["id"] = id
        self.logger.debug("book id: " + str(id))
        c.close()
        return book

    def get_a_book(self, id):
        self.logger.debug('DAO.get_a_book')
        self.logger.debug("book id: " + str(id))
        sql = """
        SELECT * FROM books WHERE id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (id,))
        r = c.fetchone()
        c.close()
        self.logger.debug(r)
        book = Utils.build_book_from_row(r)
        self.logger.debug(book)
        return book

    def get_all_books(self):
        #return value: a list [book,book,...]
        self.logger.debug('DAO.get_all_books')
        sql = """
        SELECT * FROM books order by id
        """
        result = []
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql)
        rs = c.fetchall()
        self.logger.debug(rs)
        c.close()
        for r in rs:
            self.logger.debug(r)
            book = Utils.build_book_from_row(r)
            result.append(book)
        return result

    def update_a_book(self, book):
        self.logger.debug('DAO.update_a_book')
        self.logger.debug(book)
        sql = """
        UPDATE books SET name=:name, author=:author, website_id=:websiteId, website_name=:websiteName,
          url=:url, last_modified=:lastModified, etag=:eTag, stop_update=:stopUpdate,
           auto_download=:autoDownload, create_date=:createDate, update_date=:updateDate,
           chapter_num=:chapterNum, unread_chapter_num=:unreadChapterNum,
           downloaded_chapter_num=:downloadedChapterNum,sequence=:sequence,
           last_viewed_chapter_id=:lastViewedChapterId
        WHERE id=:id
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, book)
        con.commit()
        self.logger.debug(c.rowcount)
        c.close()
        return book

    def delete_a_book(self, id):
        self.logger.debug('DAO.delete_a_book')
        self.logger.debug("id: " + str(id))
        sql = """
        DELETE FROM books WHERE id=?
        """
        sql2 = """
        DELETE FROM chapters WHERE book_id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (id,))
        self.logger.debug(c.rowcount)
        c.execute(sql2, (id,))
        self.logger.debug(c.rowcount)
        con.commit()
        c.close()

    def add_chapters(self, chapterList):
        #in arg: a list [chapter, chapter,...]
        #return value: a list [chapter, chapter,...]
        self.logger.debug('DAO.add_chapters')
        self.logger.debug(chapterList)
        sql = """
        INSERT INTO chapters ("book_id", "sequence", "title",
          "url", "filename", "readed", "downloaded", "downloadable",
          "filtered", "download_date")
          VALUES (:bookId,:sequence,:title,:url,:filename,
        :readed,:downloaded,:downloadable,:filtered,:downloadDate)
        """
        con = self.get_connection()
        c = con.cursor()
        for chapter in chapterList:
            c.execute(sql, chapter)
            chapter["id"] = c.lastrowid
            self.logger.debug(c.lastrowid)
        con.commit()
        c.close()
        return chapterList

    def get_chapters_for_a_book(self, bookId):
        #return value: a list [chapter, chapter,...]
        self.logger.debug('DAO.get_all_chapters_for_a_book')
        self.logger.debug("book id: " + str(bookId))
        sql = """
        SELECT * FROM chapters WHERE book_id=? AND filtered=0 ORDER BY sequence
        """
        result=[]
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (bookId,))
        rs = c.fetchall()
        c.close()
        self.logger.debug(rs)
        for r in rs:
            self.logger.debug(r)
            chapter = Utils.build_chapter_from_row(r)
            result.append(chapter)
        return result

    def get_all_chapters_for_a_book(self, bookId):
        #return value: a list [chapter, chapter,...]
        self.logger.debug('DAO.get_all_chapters_for_a_book')
        self.logger.debug("book id: " + str(bookId))
        sql = """
        SELECT * FROM chapters WHERE book_id=? ORDER BY sequence
        """
        result=[]
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (bookId,))
        rs = c.fetchall()
        c.close()
        self.logger.debug(rs)
        for r in rs:
            self.logger.debug(r)
            chapter = Utils.build_chapter_from_row(r)
            result.append(chapter)
        return result

    def get_max_sequence_for_a_book(self,bookId):
        self.logger.debug('DAO.get_max_sequence_for_a_book')
        self.logger.debug("book id: " + str(bookId))
        sql = """
        SELECT max(sequence) FROM chapters WHERE book_id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (bookId,))
        r = c.fetchone()
        c.close()
        self.logger.debug(r)
        result=r[0]
        self.logger.debug(result)
        return result

    def update_chapters(self, chapters):
        #in arg: a list [chapter, chapter,...]
        self.logger.debug('DAO.update_chapters')
        self.logger.debug(chapters)
        sql = """
        UPDATE chapters SET book_id=:bookId, sequence=:sequence, title=:title,
          url=:url, filename=:filename, readed=:readed, downloaded=:downloaded,
           downloadable=:downloadable, filtered=:filtered, download_date=:downloadDate
        WHERE id=:id
        """
        con = self.get_connection()
        c = con.cursor()
        for chapter in chapters:
            c.execute(sql, chapter)
            self.logger.debug(c.rowcount)
        con.commit()
        c.close()

    def delete_chapters(self, chapterList):
        self.logger.debug('DAO.delete_chapters')
        self.logger.debug(chapterList)
        sql = """
        DELETE FROM chapters WHERE id=:id
        """
        con = self.get_connection()
        c = con.cursor()
        for chapter in chapterList:
            c.execute(sql, chapter)
            self.logger.debug(c.rowcount)
        con.commit()
        c.close()

    def delete_all_chapters_for_a_book(self, bookId):
        self.logger.debug('DAO.delete_all_chapters_for_a_book')
        self.logger.debug("book id: " + str(bookId))
        sql = """
        DELETE FROM chapters WHERE book_id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (bookId,))
        self.logger.debug(c.rowcount)
        con.commit()
        c.close()

    def delete_all_chapters(self):
        self.logger.debug('DAO.delete_all_chapters')
        sql = """
        DELETE FROM chapters
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql)
        con.commit()
        self.logger.debug(c.rowcount)
        c.close()

def test_add_a_book():
        from datetime import datetime
        book = {"id":1,
            "name":"中国",
            "author":"中国人",
            "website":"www.michaelwong.cn",
            "websiteName":"中国",
            "url":"www.michaelwong.cn/index.html",
            "lastModified":None,
            "eTag":None,
            "stopUpdate":1,
            "autoDownload":1,
            "createDate":datetime.now(),
            "updateDate":None,
            "chapterNum":0,
            "unreadChapterNum":0}
        print add_a_book(book)

def test_get_a_book():
    id = 2
    book = get_a_book(id)
    print book

def test_get_all_books():
    books = get_all_books()
    print books

def test_update_a_book():
    from datetime import datetime
    book = {"id":1,
        "name":"中国",
        "author":"中国人",
        "website":"www.michaelwong.cn",
        "websiteName":"中国",
        "url":"www.michaelwong.cn/index.html",
        "lastModified":None,
        "eTag":None,
        "stopUpdate":1,
        "autoDownload":1,
        "createDate":datetime.now(),
        "updateDate":None,
        "chapterNum":0,
        "unreadChapterNum":0}
    print book
    update_a_book(book)

def test_delete_a_book():
    id = 1
    delete_a_book(id)

def test_add_chapters_for_a_book():
    from datetime import datetime
    chapter1 = {"id":111,
        "bookId":3,
        "sequence":1,
        "title":"中国人中1",
        "url":"www.michaelwong.cn/index2.html",
        "filename":"E:\workspace\NDR\src\download\1\fdafdaf.html",
        "readed":1,
        "downloaded":1,
        "downloadable":0,
        "filtered":1,
        "downloadDate":datetime.now()}
    chapter2 = {"id":2222,
        "bookId":4,
        "sequence":2,
        "title":"中国人2",
        "url":"www.michaelwong.cn/index2.html",
        "filename":"E:\workspace\NDR\src\download\1\fdafdaf.html",
        "readed":0,
        "downloaded":0,
        "downloadable":0,
        "filtered":0,
        "downloadDate":datetime.now()}
    chapterList = []
    print add_chapters(chapterList)
    chapterList = [chapter1, chapter2]
    print add_chapters(chapterList)

def test_get_all_chapters_for_a_book():
    bookId = 3
    print get_all_chapters_for_a_book(bookId)

def test_update_chapters():
    from datetime import datetime
    chapter1 = {"id":1,
        "bookId":50,
        "sequence":10,
        "title":"中国人10",
        "url":"www.michaelwong.cn/index20.html",
        "filename":"E:\workspace\NDR\src\download\1\fdafdaf0.html",
        "readed":0,
        "downloaded":0,
        "downloadable":0,
        "filtered":0,
        "downloadDate":datetime.now()}
    chapter2 = {"id":2,
        "bookId":3,
        "sequence":20,
        "title":"中国人20",
        "url":"www.michaelwong.cn/index2.html",
        "filename":"E:\workspace\NDR\src\download\1\fdafdaf00.html",
        "readed":1,
        "downloaded":1,
        "downloadable":1,
        "filtered":1,
        "downloadDate":datetime.now()}
    chapterList = []
    print update_chapters(chapterList)
    chapterList = [chapter1, chapter2]
    print update_chapters(chapterList)

if __name__ == "__main__":
    import sys
    reload(sys)
    sys.setdefaultencoding('utf-8')
#    test_add_a_book()
#    test_get_a_book()
#    test_get_all_books()
#    test_delete_a_book()
#    test_update_a_book()
#    test_add_chapters_for_a_book()
#    test_get_all_chapters_for_a_book()
#    test_update_chapters()
