
/*
 * jabber_request.h - interface for Jabber requests function.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */



#ifndef _JABBER_REQUESTS_H
#define	_JABBER_REQUESTS_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <glib.h>
#include <loudmouth/loudmouth.h>


LmMessage* build_get_vcard_request(const gchar* from, const gchar* to);
LmMessage* build_set_vcard_request(const gchar* from, const gchar* to, const xmlDocPtr vcadr_doc);
LmMessage* build_get_friends_request(const gchar* from, const gchar* to);
LmMessage* build_send_message_request(const xmlDocPtr message_doc);

#ifdef	__cplusplus
}
#endif

#endif	/* _JABBER_REQUESTS_H */

