<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:roster='jabber:iq:roster'
	exclude-result-prefixe="roster"
    extension-element-prefixes="roster"
>
<xsl:output method="xml"/>

<xsl:param name="ID"/>
<xsl:param name="PREFIX"/>
<xsl:param name="PREFIX_ID"/>
<xsl:param name="DRV_PREFIX"/>
<xsl:param name="FUNC_NAME"/>

<xsl:template match="/iq/roster:query" >

<xsl:variable name="friendCount" select="count(roster:item)" />


<Response class="friends">
            <xsl:attribute name="function">
                <xsl:value-of select="$FUNC_NAME" />
            </xsl:attribute>

    <Params>
    <xsl:attribute name="id">
      <xsl:value-of select="$PREFIX" />
    </xsl:attribute>
        <array name="contactList" from="1">
            <xsl:attribute name="friendsQuantity">
                <xsl:value-of select="$friendCount" />
            </xsl:attribute>
            <xsl:attribute name="to">
                <xsl:value-of select="$friendCount" />
            </xsl:attribute>
            

            <xsl:for-each select="roster:item">					
                <struct name="contact">
                    <xsl:attribute name="id">
                        <xsl:value-of select="$PREFIX" />
                        <xsl:value-of select="@jid" />
                    </xsl:attribute>
                    
                    <string name="FriendName">
                        <xsl:choose>
                            <xsl:when test="boolean(@name)">                    
                                <xsl:value-of select="@name"/>                                
                            </xsl:when>
                            <xsl:otherwise>
                            <xsl:value-of select="@jid" />

                            </xsl:otherwise>
                        </xsl:choose>  
                    </string>       
                    
                    <string name="FriendStatus">
                          <xsl:text>0</xsl:text>
                    </string>       
                    
                    
                 </struct>   
            </xsl:for-each>
           </array> 
    </Params>
 </Response>
</xsl:template>


</xsl:stylesheet>
