/*
 * repository.h - interface for kernel transit data repository
 * This file is part of MSA program
 *
 * Copyright (C) 2009 - Alexander A. Lomov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
 // $id$
 

#ifndef _REPOSITORY_H_
#define _REPOSITORY_H_

#include "general.h"


void repository_free();
guint repository_get_length();
gint repository_add_data(transit_data* data);
transit_data* repository_get_oldest_transit_data(gboolean need_remove);
transit_data* repository_get_newest_transit_data(gboolean need_remove);
transit_data* repository_get_transit_data_by_index(const guint index, 
                                                   const gboolean need_remove);

#endif /* _REPOSITORY_H_ */
