/*
 * db_msa_logic.h - interface fo msa db logic.
 * This file is part of DB-Maemo.
 *
 * Copyright (C) 2009 - Ilia L. Burlak
 *
 * DB-Maemo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DB-Maemo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DB-Maemo; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef _DB_H_
#define _DB_H_
#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "db_logic.h"
#include <libxml/parser.h>
#include <libxslt/xslt.h>
#include <libxslt/xsltInternals.h>
#include <libxslt/transform.h>
#include <libxslt/xsltutils.h>
#include <gconf/gconf-client.h>
#include "../msa_module.h"

#include "db_interface_function.h"

#ifndef DATADIR
#define DATADIR "./"
#endif

#define XML_VERSION "1.0"

#define HOME_DIR g_get_home_dir()
#define CONFIG_FILE_NAME "db_config.rc"

#define PROGRAM_DIR_NAME ".msa"
#define PROGRAM_DB_NAME "db"
#define CONFIG_FILE_PATH DATADIR"/""msa""/"PROGRAM_DB_NAME"/"CONFIG_FILE_NAME
#define CONFIG_FILE_PATH_HOME HOME_DIR"/"PROGRAM_DIR_NAME"/"CONFIG_FILE_NAME
#define HOME_PATH "./"
//#define HOME_PROGRAM_PATH HOME_DIR"/"PROGRAM_DIR_NAME
//#define HOME_PROGRAM_DB_PATH HOME_DIR"/"PROGRAM_DIR_NAME"db"

#define BINARY_DIR_NAME "binary_data"
#define TEMP_BINARY_DIR_NAME "tmp_data"

#define DRIVER_TAG "driver"
#define STATUS_PROP "status"
#define STATE_PROP "state"

#define DB_PATH_GCONF "/apps/msa/db/"
#define DB_LIST_DRIVERS "listdrv"


#define XML_FILE_EXTENSION ".xml"

#define MAX_STR_BUF_LEN 512

// For sort
#define ORDER_DESC 1
#define ORDER_ASC 2
#define ORDER_NO 0

enum {
/*    FAILURE = -1,
    SUCCESS = 0, */
    ERROR_MEMORY = 1,
    ERROR_ARGUMENT,
    ERROR_WORD_IS_NOT_UNIQ,
    ERROR_WORD_IS_EMPTY,
    ERROR_TRANSLATION_IS_EMPTY,
    ERROR_STATUS,
    ERROR_INIT,
    ERROR_CANT_OPEN_CONFIG_FILE,
    ERROR_CANT_FIND_GROUP_SECTION,
    ERROR_CANT_OPEN_FILE,
    ERROR_CANT_PARSE_STYLESHEET,
    ERROR_CANT_SAVE_TABLE
};

/**
 * @struct msa_module
 * @brief struct curent func 
 * @param sour
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
typedef struct _curent_func {

	char* source_id;
	char* target_id;

	char* class_name;
	char* func_name;

	xmlDocPtr (*cfunc) (xmlDocPtr);

} curent_func;


int db_shutdown();
int msa_module_init(msa_module* db);
int db_send(xmlDocPtr request, xmlDocPtr *response, msa_module* db_info);
int db_start(gpointer _kernel, gpointer _list_drv, int argc, char* argv[]);
xmlXPathObject* db_xpath(char* req, xmlDocPtr doc);
curent_func* db_get_curent_func(xmlDocPtr doc);
int db_select_curent_func(curent_func* func);
void add_target(const xmlDocPtr doc, const xmlChar* target_id);
void rem_targets(xmlDocPtr doc);
xmlXPathObjectPtr get_nodeset(const xmlDocPtr doc, const xmlChar* xpath);

void free_curent_func(curent_func *fnc);
curent_func *create_curent_func();


#endif /* _DB_H_ */

