/*
 * ui_general.h - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Andrey Bogachev
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _UI_GENERAL_
#define _UI_GENERAL_

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <hildon/hildon-program.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtkwidget.h>
#include "../msa.h"
#include "../msa_module.h"
#include "../kernel/general.h"
#include "ui_callback.h"
#include "ui_init.h"
#include "he-fullscreen-button.h"
#include <curl/curl.h>
#include <curl/easy.h>

/* CLASS */
#define PROFILE "profile"
#define SETTINGS "settings"
#define FRIENDS "friends"
#define MESSAGES "messages"
#define SYSTEM_MESSAGES "systemMessages"

/* FUNCTIONS */
#define GET_SETTINGS "getSettings"
#define GET_PROFILE "getProfile"
#define GET_FRIENDSLIST "getListFriends"
#define UPDATE_PROFILE "updateProfile"
#define SET_PROFILE "setProfile"
#define GET_INBOX "getInboxMessages"
#define GET_OUTBOX "getOutboxMessages"
#define ERROR_MESSAGE "errorMessage"
#define INFO_MESSAGE "infoMessage"
#define CAPTCHA_MSG "captchaMessage"

#define DIR DATADIR"/msa/ui/"
#define IMG_ADDF DIR"addcontact.png"
#define IMG_CLER DIR"clear.png"
#define IMG_CONT DIR"contact.png"
#define IMG_COMP DIR"compose.png"
#define IMG_EXIT DIR"exit.png"
#define IMG_FIND DIR"search.png"
#define IMG_FRND DIR"contacts.png"
#define IMG_FRST DIR"first.png"
#define IMG_FROM DIR"from.png"
#define IMG_FULL DIR"full.png"
#define IMG_HELP DIR"help.png"
#define IMG_LAST DIR"last.png"
#define IMG_MSSG DIR"messages.png"
#define IMG_MYSC DIR"mysocials.png"
#define IMG_NEXT DIR"next.png"
#define IMG_PRFL DIR"profile.png"
#define IMG_REFR DIR"refresh.png"
#define IMG_PREV DIR"prev.png"
#define IMG_SEPR DIR"separator.png"
#define IMG_SETS DIR"settings.png"
#define IMG_SORT DIR"sort.png"
#define IMG_SRVC DIR"service.png"
#define IMG_TOOL DIR"tool.png"

/* STRINGS: EN */
#define STR_BOUT _("About")
#define STR_BACK _("Back")
#define STR_BRTH _("Birthdate")
#define STR_CITY _("City")
#define STR_CNCL _("Cancel")
#define STR_CMPS _("Compose")
#define STR_CTRY _("Country")
#define STR_EDIT _("Edit")
#define STR_EMPT "---"
#define STR_EXIT _("Exit")
#define STR_FIND _("Find")
#define STR_FRDS _("Friends")
#define STR_FULL _("Full screen")
#define STR_GET_ _("Get")
#define STR_GNDR _("Gender")
#define STR_GO__ _("Go!")
#define STR_HELP _("Help")
#define STR_JOIN _("Join with...")
#define STR_LSTN _("Last Name")
#define STR_MRTL _("Marital status")
#define STR_MSGS _("Messages")
#define STR_NMSG _("New message")
#define STR_NAME _("First Name")
#define STR_OK__ _("Ok")
#define STR_PLTC _("Political views")
#define STR_PR2J _("profiles to join")
#define STR_PRFL _("Profile")
#define STR_PROG "MySocials"
#define STR_RPLY _("Reply")
#define STR_RSLT _("Search results for")
#define STR_SAVE _("Save")
#define STR_SEND _("Send")
#define STR_SETP _("Services")
#define STR_SLCT _("Select")
#define STR_SETS _("Settings")
#define STR_STRT _("Start")
#define STR_THEN _("Then press Go!")
#define STR_TOOL _("Toolbar")
#define STR_TO   _("to: ")
#define STR_UPDT _("Refresh")
#define STR_ZEROS "0 - 0 / 0"
#define STR_INCM _("Incoming")
#define STR_SENT _("Sent")
#define STR_FROM _("from: ")
#define STR_TTLS " - "

#define STR_ABOUT _("MySocials is a mobile client to access \
services of social networks. \
Distributed under GNU GPL license (see COPYING). \
Please visit:\n\
http://oss.fruct.org/wiki/Maemo-VKontakte\n\
for additional info, updates and documentation\n\
----------------------------------------\n\
Developers:\n\
    A. Bogachev <bogachev@cs.karelia.ru>\n\
    I. Burlak <burlak@cs.karelia.ru>\n\
    A. Lomov <lomov@cs.karelia.ru>\n\
    S. Zakharov <szaharov@cs.karelia.ru>\n\
    A. Borodin <aborod@cs.karelia.ru>\n\
    K. Kulakov <kulakov@cs.karelia.ru>")
#define STR_HELPT _("Introduction\n\
This is MySocials, version 0.2. MySocials is the client for\
social networks with cross profile features. With MySocials\
you will be able to edit your profile entries, manage contacts\
(friend lists) and send messages. You will also be able to\
join contacts from different services if they represent the\
same person.\n\n\
Currently the interaction with VKontakte services only is enabled.\
A short time later there will be support of Jabber, Facebook and\
other social networks and instant messenger services.\n\n\
Using MySocials\n\
After program start at first time you should fill and save account\
information for each supported service. In particular for VKontakte\
you should specify an email, password and mailbox autoupdate\
interval. You are supposed to have the accounts otherwise you\
should sign up by browser.\n\n\
Next you should press \"Go\" button to proceed to main window.\
Using left-side buttons you can switch between profile, contacts,\
messages and setup forms.\n\n\
User profile is fetched automatically when the form is activated.\
Contact list should be updated manually.\n\n\
Clicking on user picture in contact list will show you user profile\
form. Also clicking on envelope button allows to compose and send a\
message. Contacts can be sorted and also contact search feature is\
provided.\n\n\
On mailbox form you can look through the messages and reply.\n\n\
License information\n\
MySocials is free software, distributed under the terms of the\
[GNU] General Public License as published by the Free Software\
Foundation, version 2.1 of the License.  For more information,\
see the file COPYING.\n\n\
Privacy Statement\n\
We claim that your personal info will never be transferred to\
third parties.\n\n\
Reporting Bugs\n\
Bug reports for MySocials should be sent to:\
http://maemo.cs.karelia.ru/bugzilla/enter_bug.cgi?product=mysocials\n\
Enjoy!")

#define TYPE_IMAGE "img"
#define TYPE_NUMBR "number"
#define TYPE_STRNG "string"
#define TYPE_SELCT "select"
#define TYPE_STRCT "struct"
#define TYPE_DATE "date"
#define TYPE_BOOL "boolean"

#define MARKUP "<span foreground=\"#aaaaaa\">"
#define MARKUP1 "<span foreground=\"#aaaaaa\">"
#define MARKUP2 "<span foreground=\"#aaaaaa\">"
#define MARKUP_OFFLINE "<span>"
#define MARKUP_ONLINE "<span foreground=\"#aaffaa\">"
#define MARKUP_READ "<span>"
#define MARKUP_UNREAD "<span foreground=\"#aaffaa\">"
#define PUKRAM "</span>"

#define SIZE_HELP 200
#define TIMEOUT   150
#define TIMEAUTO  999
#define PADDING   10
#define MIN_HEIGHT 40
#define MIN_WIDTH 200
#define MIN_WIDTH_PHOTO 80
#define MIN_WIDTH_CONTROL 100
#define MIN_MSG_WIDTH 500
#define MIN_TASKS_WIDTH 90
#define MAX_HEIGHT_PHOTO 400
#define FRIENDS_PER_PAGE 10
#define MESSAGES_PER_PAGE 10
#define TXT_HELP DIR"help.txt"


msa_module* kernel;

typedef enum _mbox 
{
    INBOX,
    SENT
}mbox;


/* UI data struct */
typedef struct _UIdata   UIdata;
struct _UIdata {
    /* Basic Items */
    HildonProgram* program;
    HildonWindow* window;
    GtkWidget* tasks;
    GtkWidget* boxes[5];
    GtkWidget* taskboxes[5];
    GtkWidget* box_profile;
    GtkWidget* box_service;
    GtkWidget* box_setting;
    GtkWidget* list_drvs;
    
    GtkWidget* entry_logn;
    GtkWidget* entry_pass;
    GtkWidget* entry_auto;
    GtkWidget* entry_actv;
    
    GtkWidget* entry_labl;
    GtkWidget* entry_date;
    GtkWidget* entry_text;
    GtkWidget* entry_comb;
    
    gboolean empty_profile;
    
    // transit data
    xmlDocPtr ui_request;
    xmlDocPtr response;
    GHashTable* table_imgs;
    
    GSource* source_time;  
    int page;
    int prev;
    int num_srvs;
    int srvc;

    /* Friends */
    gboolean ascending;
    gboolean empty_friends;
    gboolean friends_filter;
    
    int num_frds;
    int page_frds;
    
    GtkWidget* box_friend;
    GtkWidget* box_friends;
    GtkWidget* box_friends_list;
    GtkWidget* box_friends_navi;
    GtkWidget* box_friends_result;
    GtkWidget* box_friends_profile;
    GtkWidget* label_friends_page;
    GtkWidget* label_friends_filter;
    GtkWidget* button_friend_profile_refresh;
	GtkWidget* button_friends_page_prev;
	GtkWidget* button_friends_page_next;
	GtkWidget* button_friends_page_frst;
	GtkWidget* button_friends_page_last;
    
    /* Messages */
    gboolean empty_messages;
    mbox msgs_box;
    int page_msgs;
    int num_msgs;
    GtkWidget* label_messages_page;
    GtkWidget* box_messages;
    GtkWidget* box_messages_list;
    GtkWidget* box_message_reply;
	GtkWidget* button_messages_page_prev;
	GtkWidget* button_messages_page_next;
	GtkWidget* button_messages_page_frst;
	GtkWidget* button_messages_page_last;
    /* Strings */
    gchar* str_page[5];
    gchar* str_task[4];
    /* Drivers */
    GList* drivers;    
};

UIdata* ui_data;

/* MESSAGE STRUCT */
typedef struct _Message   Message;
struct _Message {
    gchar* str_sender_id;
    gchar* str_sender_name;
    gchar* str_recipient_id;
    gchar* str_recipient_name;
    gchar* str_date;
    gchar* str_time;
    gchar* str_status;
    gchar* str_text;
};

/* FRIEND STRUCT */
typedef struct _Friend   Friend;
struct _Friend {
    gchar* str_name;
    gchar* str_id;
    gchar* str_status;
    gchar* str_img;
    gchar* str_uri;
};


/*  */
typedef struct _InputWidget InputWidget;
struct _InputWidget {
    GtkWidget* input;
};

/* KERNEL RESPONSE */
static void callback_kernel_response (xmlChar* request, xmlChar** response);
xmlXPathObject* xpath(char* req, xmlDocPtr doc);

/* HELP FUNC */
void ui_init_help();


#endif

