/*
 * ui_init.c - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Andrey Bogachev
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
 
#include "ui_general.h"

/**
 * @brief user interface initialization
 * @param
 * @return  
**/
void ui_init()
{
    HildonProgram* program;
    HildonWindow* window;

    program = HILDON_PROGRAM(hildon_program_get_instance());
    window  = HILDON_WINDOW(hildon_window_new());
    
    /* window */
    ui_data->program = HILDON_PROGRAM(program);
    ui_data->window = HILDON_WINDOW(window);
    ui_data->full = FALSE;
    ui_data->help = FALSE;
    ui_data->tool = FALSE;    
    
    g_signal_connect(G_OBJECT(window), "destroy", G_CALLBACK(callback_exit), NULL);
    gtk_window_set_title (GTK_WINDOW (ui_data->window), ui_data->str_page[0]);
    
    ui_data->str_page[0] = g_strdup(STR_STRT);
    ui_data->str_page[1] = g_strdup(STR_SETS);
    ui_data->str_page[2] = g_strdup(STR_PRFL);
    ui_data->str_page[3] = g_strdup(STR_EDIT);
    ui_data->str_page[4] = g_strdup(STR_NMSG);
    
    ui_data->str_task[0] = g_strdup(STR_PRFL);
    ui_data->str_task[1] = g_strdup(STR_FRDS);
    ui_data->str_task[2] = g_strdup(STR_MSGS);
    ui_data->str_task[3] = g_strdup(STR_SETS); 
    
    ui_init_pages();
    ui_init_tools();
    ui_init_menus();

    hildon_program_add_window(program, window);
    g_set_application_name(STR_PROG);
    gtk_window_set_title (GTK_WINDOW (ui_data->window), ui_data->str_page[0]);
    gtk_widget_show(GTK_WIDGET(program));
    //gtk_main();
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
static void ui_init_pages()
{
    GtkWidget* pages;
    GtkWidget* label;
    char strings[10];
    int i;

    pages = gtk_notebook_new();
    ui_data->notebook = pages;
    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(pages), FALSE);
    gtk_notebook_set_show_border(GTK_NOTEBOOK(pages), FALSE);
    for (i = 0; i < 5; i++) {
        sprintf(strings, "page %d", i + 1);
        label = gtk_label_new(strings);
        ui_data->boxes[i] = gtk_vbox_new(FALSE, 0);
        gtk_widget_show(label);
        gtk_widget_show(ui_data->boxes[i]);
        label = gtk_label_new(strings);
        gtk_notebook_append_page(GTK_NOTEBOOK(pages), ui_data->boxes[i], label);
    }
    gtk_container_add(GTK_CONTAINER((GtkWidget*)ui_data->window), pages);
    gtk_widget_show_all(GTK_WIDGET(ui_data->window));
    ui_init_page0();
    ui_init_page1();
    ui_init_page2();
    ui_init_page3();
    ui_data->page = 0;
    ui_data->prev = 0;
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
static void ui_init_page0()
{
    //UIdata* ui_data = ui_data_ptr;
    GtkWidget* hbox = gtk_hbox_new(TRUE, 0);
    GtkWidget* hbox_labels = gtk_hbox_new(TRUE, 0);
    GtkWidget* vbox = gtk_vbox_new(FALSE, 0);
    GtkWidget* label0 = gtk_label_new(STR_SETP);
    GtkWidget* label1 = gtk_label_new(STR_THEN);
    GtkWidget* image = gtk_image_new_from_file(IMG_MYSC);
    GtkWidget* button = gtk_button_new_with_label(STR_GO__);
    //smy_widget_init(button);
    
    GtkWidget* alignment_label0 = gtk_alignment_new(0, 0.5, 0, 0);
    gtk_container_add (GTK_CONTAINER(alignment_label0), label0);
    
    GtkWidget* alignment_label1 = gtk_alignment_new(0, 0.5, 0, 0);
    gtk_container_add (GTK_CONTAINER(alignment_label1), label1);
    
    gtk_box_pack_start (GTK_BOX (hbox_labels), alignment_label0, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox_labels), alignment_label1, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->boxes[0]), hbox_labels, FALSE, FALSE, PADDING);
    gtk_box_pack_start (GTK_BOX (ui_data->boxes[0]), hbox, TRUE, TRUE, 0);
    
    /* SERVICES LIST */
    GtkWidget* alignment_list = ui_init_list_drivers();
    
    GtkWidget* vseparator = gtk_vseparator_new();   
    gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), alignment_list, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);    
    gtk_widget_show_all(ui_data->boxes[0]);
    
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(callback_goto), 2);
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
static void ui_init_page1()
{
    //UIdata* ui_data = ui_data_ptr;
    GtkWidget* hbox2 = gtk_hbox_new(TRUE, 0);
    GtkWidget* vbox = gtk_vbox_new(TRUE, 0);
    
    //GtkWidget* box[4];
    //gtk_notebook_set_show_border(tasks, TRUE);
    //ui_data->tasks = tasks;
    
    //GtkWidget* label; // = gtk_label_new(STR_WLCM);
    //img[0] = gtk_image_new_from_file(IMG_PRFL);
    //img[1] = gtk_image_new_from_file(IMG_FRND);
    //img[2] = gtk_image_new_from_file(IMG_MSSG);
    //img[3] = gtk_image_new_from_file(IMG_SETS);
    GtkWidget* button_cncl = gtk_button_new_with_label(STR_CNCL);
    GtkWidget* button_save = gtk_button_new_with_label(STR_SAVE);
    gtk_widget_set_usize (button_cncl, -1, MIN_HEIGHT);
    gtk_widget_set_usize (button_save, -1, MIN_HEIGHT);
    //gtk_box_pack_start (GTK_BOX (ui_data->boxes[1]), tasks, TRUE, TRUE, 0);
    //gtk_notebook_set_show_tabs(pages, FALSE);
    //gtk_notebook_set_show_border(tasks, FALSE);
    //gtk_notebook_set_tab_pos (tasks, GTK_POS_LEFT);
    
    
    //GtkWidget* button_srvc_1 = gtk_button_new_with_label("back");
    //g_signal_connect(G_OBJECT(button_prfl_1), "clicked", G_CALLBACK(callback_button_profile_get), ui_data_ptr);
    //GtkWidget* button_srvc_2 = gtk_button_new_with_label("save");    
    
    //g_print("ui_init_page1\n");
    
    /* PROFILE */
    //box[0] = gtk_vbox_new(TRUE, 2);
    //ui_data->box_profile = box[0];
    //GtkWidget* box_prfl = gtk_hbox_new(TRUE, 2);
    
    ui_data->box_setting = gtk_vbox_new(TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->boxes[1]), ui_data->box_setting, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->boxes[1]), hbox2, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox2), button_cncl, TRUE, TRUE, 10);
    gtk_box_pack_start (GTK_BOX (hbox2), button_save, TRUE, TRUE, 10);
    
    //GtkWidget* button_prfl_1 = gtk_button_new_with_label("get");
    //g_signal_connect(G_OBJECT(button_prfl_1), "clicked", G_CALLBACK(callback_button_profile_get), ui_data_ptr);
    //GtkWidget* button_prfl_2 = gtk_button_new_with_label("save");
    
    //gtk_box_pack_start (GTK_BOX(box_prfl), button_prfl_1, TRUE, TRUE, 10);
    //gtk_box_pack_start (GTK_BOX(box_prfl), button_prfl_2, TRUE, TRUE, 10);
    
    
    //gtk_widget_show_all(ui_data->tasksui_);
    //gtk_box_pack_start (GTK_BOX (ui_data->boxes[1]), button, TRUE, TRUE, 10);
    //gtk_box_pack_start (GTK_BOX (hbox), image, TRUE, TRUE, 10);
    //gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 10);
    //gtk_widget_show(button_full);
    //g_signal_connect(G_OBJECT(button_full), "clicked", G_CALLBACK(callback_full), (gpointer)ui_data);
    gtk_widget_show_all(ui_data->boxes[1]);
    //ui_data->page = 1;
    //ui_data->prev = 1;
    //g_print("ui_data-page = %d\n", ui_data->page);
    g_signal_connect(G_OBJECT(button_cncl), "clicked", G_CALLBACK(callback_button_cancel_setup_service), ui_data->srvc);
    g_signal_connect(G_OBJECT(button_save), "clicked", G_CALLBACK(callback_button_save_setup_service), ui_data->srvc);
    
    GtkWidget* hbox[4];
    GtkWidget* alignment[4];
    GtkWidget* entries[4];
    GtkWidget* labels[4];
    
    int i;
    
    for(i = 0; i < 4; i++){
        hbox[i] = gtk_hbox_new(TRUE, 0);
        gtk_box_pack_start (GTK_BOX (ui_data->box_setting), hbox[i], TRUE, TRUE, 0);
    }    
    
    labels[0] = gtk_label_new(NULL);
    labels[1] = gtk_label_new(NULL);
    labels[2] = gtk_label_new(NULL);
    labels[3] = gtk_label_new(NULL);

    gchar* strings = g_strdup(g_strconcat(MARKUP, "Login:", PUKRAM, NULL));
    gtk_label_set_markup (labels[0], strings);
    strings = g_strdup(g_strconcat(MARKUP, "Password:", PUKRAM, NULL));
    gtk_label_set_markup (labels[1], strings);
    strings = g_strdup(g_strconcat(MARKUP, "Auto-update time:", PUKRAM, NULL));
    gtk_label_set_markup (labels[2], strings);
    strings = g_strdup(g_strconcat(MARKUP, "Enable service:", PUKRAM, NULL));
    gtk_label_set_markup (labels[3], strings);
    
    gtk_box_pack_start (GTK_BOX (hbox[0]), labels[0], TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox[1]), labels[1], TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox[2]), labels[2], TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox[3]), labels[3], TRUE, TRUE, 0);
    
    ui_data->entry_logn = gtk_entry_new();
    ui_data->entry_pass = gtk_entry_new();
    gtk_entry_set_visibility(GTK_ENTRY(ui_data->entry_pass), FALSE);
    ui_data->entry_auto = gtk_entry_new();
    ui_data->entry_actv = gtk_check_button_new();
    gtk_widget_set_sensitive(GTK_WIDGET(ui_data->entry_actv), FALSE);
    gtk_widget_set_usize (ui_data->entry_logn, -1, MIN_HEIGHT);
    gtk_widget_set_usize (ui_data->entry_pass, -1, MIN_HEIGHT);
    gtk_widget_set_usize (ui_data->entry_auto, -1, MIN_HEIGHT);
    gtk_widget_set_usize (ui_data->entry_actv, -1, MIN_HEIGHT);
       
        //GtkWidget* hbox = gtk_hbox_new(TRUE, 0);
    //gtk_box_pack_start (GTK_BOX (hbox), label0, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox[0]), ui_data->entry_logn, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox[1]), ui_data->entry_pass, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox[2]), ui_data->entry_auto, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox[3]), ui_data->entry_actv, TRUE, TRUE, 0);
    
    gtk_widget_show_all(GTK_WIDGET(ui_data->box_setting));
    
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
static void ui_init_page2()
{
    GtkWidget* tasks = gtk_notebook_new();
    GtkWidget* img[4];
    GtkWidget* box[4];
    GtkWidget* image_back;
    GtkWidget* image_frwd;
    gtk_notebook_set_show_border(GTK_NOTEBOOK(tasks), FALSE);
    ui_data->tasks = tasks;
    g_signal_connect(G_OBJECT(ui_data->tasks), "switch-page", G_CALLBACK(callback_task_switch), NULL);
    char* strings[20];
    int i;
    GtkWidget* label; // = gtk_label_new(STR_WLCM);
    img[0] = gtk_image_new_from_file(IMG_PRFL);
    img[1] = gtk_image_new_from_file(IMG_FRND);
    img[2] = gtk_image_new_from_file(IMG_MSSG);
    img[3] = gtk_image_new_from_file(IMG_SETS);
    //GtkWidget* button = gtk_button_new_with_label("Go!");
    gtk_box_pack_start (GTK_BOX (ui_data->boxes[2]), tasks, TRUE, TRUE, 0);
    //gtk_notebook_set_show_tabs(pages, FALSE);
    gtk_notebook_set_show_border(GTK_NOTEBOOK(tasks), FALSE);
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK(tasks), GTK_POS_LEFT);
    
    for (i = 0; i < 4; i++) {
        ui_data->taskboxes[i] = gtk_vbox_new(FALSE, 0);
        gtk_widget_show(ui_data->taskboxes[i]);
        gtk_notebook_append_page(GTK_NOTEBOOK(tasks), ui_data->taskboxes[i], img[i]);
    }
    g_print("ui_init_page1\n");
    
    /* PROFILE */
    GtkWidget* box_profile = gtk_hbox_new(FALSE, PADDING);
    ui_data->box_profile = box_profile;
    GtkWidget* box_prfl = gtk_hbox_new(FALSE, 0);
    GtkWidget* box_service = gtk_hbox_new(FALSE, 0);
    
    /* ICONS OF SERVICES */
    GList* node;
    msa_driver_info* info;
    GtkWidget* icon_service[ui_data->num_srvs];
    GtkWidget* alignment[ui_data->num_srvs];
    GtkWidget* combo = gtk_combo_box_new_text();
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        info = (msa_driver_info*)node->data;
        if (info->pic == NULL){
            icon_service[i] = gtk_image_new_from_file(IMG_SRVC);
        } else {
            int size;
            guchar* buff = g_base64_decode((gchar*)info->pic, &size);
            GdkPixbufLoader* pbloader;
            pbloader = gdk_pixbuf_loader_new_with_type ("png", NULL);
            gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
            gdk_pixbuf_loader_close (pbloader, NULL);
            //icon_service[i] = gtk_image_new_from_pixbuf(gdk_pixbuf_loader_get_pixbuf(pbloader));
            int width = gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader)) / 2;
            GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, width, GDK_INTERP_BILINEAR);
            icon_service[i] = gtk_image_new_from_pixbuf(pixbuff);
        }
        
        gtk_box_pack_start(GTK_BOX(box_service), icon_service[i], FALSE, FALSE, PADDING);
        gtk_combo_box_append_text(GTK_COMBO_BOX(combo), info->name);
        i++;
    }
    /* END ICONS */
    
    gtk_combo_box_set_active(GTK_COMBO_BOX(combo), 0);
    gtk_box_pack_start (GTK_BOX (box_service), combo, TRUE, TRUE, PADDING);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[0]), box_service, FALSE, FALSE, PADDING);
    GtkWidget* separator = gtk_hseparator_new();
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[0]), separator, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[0]), ui_data->box_profile, TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[0]), box_prfl, FALSE, TRUE, 0);
    
    //GtkWidget* button_prfl_1 = gtk_button_new_with_label(STR_GET_);
    GtkWidget* button_prfl_2 = gtk_button_new_with_label(STR_UPDT);    
    GtkWidget* button_prfl_3 = gtk_button_new_with_label(STR_SAVE);
    //gtk_widget_set_usize (button_prfl_1, -1, MIN_HEIGHT);
    gtk_widget_set_usize (button_prfl_2, -1, MIN_HEIGHT);
    gtk_widget_set_usize (button_prfl_3, -1, MIN_HEIGHT);    

    //g_signal_connect(G_OBJECT(button_prfl_1), "clicked", G_CALLBACK(callback_button_profile_get), NULL);
    g_signal_connect(G_OBJECT(button_prfl_2), "clicked", G_CALLBACK(callback_button_profile_update), NULL);
    g_signal_connect(G_OBJECT(button_prfl_3), "clicked", G_CALLBACK(callback_button_profile_save), NULL);
    
    //gtk_box_pack_start (GTK_BOX(box_prfl), button_prfl_1, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX(box_prfl), button_prfl_2, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX(box_prfl), button_prfl_3, TRUE, TRUE, 0);

    /* END OF PROFILE */

    /* FRIENDS */
    GtkWidget* box_friends_tasks = gtk_vbox_new(TRUE, 0);
    GtkWidget* box_friends_list = gtk_vbox_new(FALSE, 0);
    gtk_widget_set_usize(GTK_WIDGET(box_friends_tasks), MIN_TASKS_WIDTH, -1);
    ui_data->page_frds = 0;
    ui_data->ascending = TRUE;
    
    ui_data->box_friends_list = gtk_vbox_new(TRUE, 0);
    ui_data->box_friends = gtk_hbox_new(FALSE, 0);    
    ui_data->box_friend = gtk_vbox_new(FALSE, 0);
    
    /* FRIENDS NAVIGATION */
    image_back = gtk_image_new_from_file(IMG_PREV);
    image_frwd = gtk_image_new_from_file(IMG_NEXT);
    GtkWidget* image_frst = gtk_image_new_from_file(IMG_FRST);
    GtkWidget* image_last = gtk_image_new_from_file(IMG_LAST);
    
    ui_data->box_friends_navi = gtk_hbox_new(FALSE, 0);
    ui_data->button_friends_page_prev = gtk_button_new();
    ui_data->button_friends_page_next = gtk_button_new();
    ui_data->button_friends_page_frst = gtk_button_new();
    ui_data->button_friends_page_last = gtk_button_new();
    ui_data->label_friends_page = gtk_label_new(STR_EMPT);
    
    gtk_container_add (GTK_CONTAINER(ui_data->button_friends_page_prev), image_back);
    gtk_container_add (GTK_CONTAINER(ui_data->button_friends_page_next), image_frwd);
    gtk_container_add (GTK_CONTAINER(ui_data->button_friends_page_frst), image_frst);
    gtk_container_add (GTK_CONTAINER(ui_data->button_friends_page_last), image_last);
    
    gtk_widget_set_usize(GTK_WIDGET(ui_data->button_friends_page_prev), MIN_WIDTH_CONTROL, MIN_HEIGHT);
    gtk_widget_set_usize(GTK_WIDGET(ui_data->button_friends_page_next), MIN_WIDTH_CONTROL, MIN_HEIGHT);
    gtk_widget_set_usize(GTK_WIDGET(ui_data->button_friends_page_frst), MIN_WIDTH_CONTROL, MIN_HEIGHT);
    gtk_widget_set_usize(GTK_WIDGET(ui_data->button_friends_page_last), MIN_WIDTH_CONTROL, MIN_HEIGHT);
    
    separator = gtk_hseparator_new();
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_navi), ui_data->button_friends_page_frst, FALSE, FALSE, PADDING); 
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_navi), ui_data->button_friends_page_prev, FALSE, FALSE, 0); 
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_navi), ui_data->label_friends_page, TRUE, FALSE, 0); 
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_navi), ui_data->button_friends_page_next, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_navi), ui_data->button_friends_page_last, FALSE, FALSE, PADDING); 
    
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_prev), "clicked", G_CALLBACK(callback_button_friends_page_prev), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_next), "clicked", G_CALLBACK(callback_button_friends_page_next), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_frst), "clicked", G_CALLBACK(callback_button_friends_page_frst), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_last), "clicked", G_CALLBACK(callback_button_friends_page_last), NULL);
    
    gtk_box_pack_start (GTK_BOX (box_friends_list), ui_data->box_friends_navi, FALSE, FALSE, 0);      
    /* END OF FRIENDS NAVIGATION */
    
    /* FRIENDS FILTER */
    ui_data->box_friends_result = gtk_hbox_new(FALSE, PADDING);
    gtk_widget_set_usize(ui_data->box_friends_result, -1, MIN_HEIGHT);
    ui_data->label_friends_filter = gtk_label_new(NULL);
    
    GtkWidget* button_friends_result = gtk_button_new();
    gtk_widget_set_usize(GTK_WIDGET(button_friends_result), MIN_WIDTH_CONTROL, MIN_HEIGHT);
    gtk_container_add (GTK_CONTAINER(button_friends_result), gtk_image_new_from_file(IMG_CLER));
    g_signal_connect(G_OBJECT(button_friends_result), "clicked", G_CALLBACK(callback_button_friends_result), NULL);
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_result), ui_data->label_friends_filter, TRUE, TRUE, 0); 
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_result), button_friends_result, FALSE, FALSE, PADDING); 
    gtk_box_pack_start (GTK_BOX (box_friends_list), ui_data->box_friends_result, FALSE, TRUE, 0); 
    /* END OF FRIENDS FILTER*/
    
    gtk_box_pack_start (GTK_BOX (box_friends_list), separator, FALSE, FALSE, PADDING); 
    
    gtk_box_pack_start (GTK_BOX (box_friends_list), ui_data->box_friends_list, TRUE, TRUE, 0);
    
    /* FRIENDS TASKS */
    GtkWidget* button_friends_find = gtk_button_new();
    GtkWidget* button_friends_refr = gtk_button_new();    
    GtkWidget* button_friends_sort = gtk_button_new();
    GtkWidget* button_friends_addf = gtk_button_new();
    
    GtkWidget* image_find = gtk_image_new_from_file(IMG_FIND);
    GtkWidget* image_refr = gtk_image_new_from_file(IMG_REFR);
    GtkWidget* image_sort = gtk_image_new_from_file(IMG_SORT);
    GtkWidget* image_addf = gtk_image_new_from_file(IMG_ADDF);
    
    gtk_container_add (GTK_CONTAINER(button_friends_find), image_find);
    gtk_container_add (GTK_CONTAINER(button_friends_refr), image_refr);
    gtk_container_add (GTK_CONTAINER(button_friends_sort), image_sort);
    gtk_container_add (GTK_CONTAINER(button_friends_addf), image_addf);
    
    gtk_widget_set_sensitive(button_friends_addf, FALSE);
    
    gtk_box_pack_start (GTK_BOX (box_friends_tasks), button_friends_find, TRUE, TRUE, 0); 
    gtk_box_pack_start (GTK_BOX (box_friends_tasks), button_friends_refr, TRUE, TRUE, 0); 
    gtk_box_pack_start (GTK_BOX (box_friends_tasks), button_friends_sort, TRUE, TRUE, 0); 
    gtk_box_pack_start (GTK_BOX (box_friends_tasks), button_friends_addf, TRUE, TRUE, 0);    
    
    g_signal_connect(G_OBJECT(button_friends_find), "clicked", G_CALLBACK(callback_button_friends_find), NULL);
    g_signal_connect(G_OBJECT(button_friends_refr), "clicked", G_CALLBACK(callback_button_friends_update), NULL);
    g_signal_connect(G_OBJECT(button_friends_sort), "clicked", G_CALLBACK(callback_button_friends_sort), NULL);
    /* END OF FRIENDS TASKS */
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends), box_friends_list, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends), box_friends_tasks, FALSE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[1]), ui_data->box_friends, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[1]), ui_data->box_friend, TRUE, TRUE, 0);
    
    /* END OF FRIENDS */ 
    
    /* MESSAGES */
    GtkWidget* box_msgs = gtk_hbox_new(FALSE, 0);
    GtkWidget* box_msgs_tasks = gtk_vbox_new(TRUE, 0);
    GtkWidget* box_msgs_list = gtk_vbox_new(FALSE, 0);
    gtk_widget_set_usize(GTK_WIDGET(box_msgs_tasks), MIN_TASKS_WIDTH, -1);
    ui_data->box_messages_list = gtk_vbox_new(TRUE, 0);
    ui_data->msgs_box = INBOX;
    ui_data->page_msgs = 0;
    
    /* MESSAGES NAVIGATION */
    image_back = gtk_image_new_from_file(IMG_PREV);
    image_frwd = gtk_image_new_from_file(IMG_NEXT);
    
    GtkWidget* combo_msgs = gtk_combo_box_new_text();
    gtk_combo_box_append_text(GTK_COMBO_BOX(combo_msgs), STR_INCM);
    gtk_combo_box_append_text(GTK_COMBO_BOX(combo_msgs), STR_SENT);
    gtk_combo_box_set_active(GTK_COMBO_BOX(combo_msgs), 0);
    //gtk_widget_set_usize(GTK_WIDGET(combo_msgs), MIN_WIDTH, MIN_HEIGHT);
    g_signal_connect(G_OBJECT(combo_msgs), "changed", G_CALLBACK(callback_combo_msgs_changed), NULL);
    
    GtkWidget* box_msgs_navi = gtk_hbox_new(FALSE, 0);
    ui_data->button_messages_page_prev = gtk_button_new();
    ui_data->button_messages_page_next = gtk_button_new();
    ui_data->label_messages_page = gtk_label_new(STR_EMPT);
    //GtkWidget* alignment_label_messages_page = gtk_alignment_new(0, 1, 0, 0);
    //gtk_container_add (GTK_CONTAINER(alignment_label_messages_page), ui_data->label_messages_page);
    
    gtk_container_add (GTK_CONTAINER(ui_data->button_messages_page_prev), image_back);
    gtk_container_add (GTK_CONTAINER(ui_data->button_messages_page_next), image_frwd);
    
    g_signal_connect(G_OBJECT(ui_data->button_messages_page_prev), "clicked", G_CALLBACK(callback_button_msgs_page_prev), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_messages_page_next), "clicked", G_CALLBACK(callback_button_msgs_page_next), NULL);
    
    gtk_widget_set_usize(GTK_WIDGET(box_msgs_navi), -1, MIN_HEIGHT);
    //gtk_widget_set_usize(GTK_WIDGET(button_messages_page_prev), MIN_WIDTH_CONTROL, MIN_HEIGHT);
    
    separator = gtk_hseparator_new();
    
    gtk_box_pack_start (GTK_BOX (box_msgs_navi), combo_msgs, TRUE, TRUE, PADDING);
    gtk_box_pack_start (GTK_BOX (box_msgs_navi), ui_data->button_messages_page_prev, TRUE, TRUE, PADDING); 
    gtk_box_pack_start (GTK_BOX (box_msgs_navi), ui_data->label_messages_page, FALSE, FALSE, 0); 
    gtk_box_pack_start (GTK_BOX (box_msgs_navi), ui_data->button_messages_page_next, TRUE, TRUE, PADDING);
    gtk_box_pack_start (GTK_BOX (box_msgs_list), box_msgs_navi, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (box_msgs_list), separator, FALSE, FALSE, PADDING);    
    /* END OF MESSAGES NAVIGATION */
    
    gtk_box_pack_start (GTK_BOX (box_msgs_list), ui_data->box_messages_list, TRUE, TRUE, 0); 
    
    GtkWidget* button_msgs_find = gtk_button_new();
    GtkWidget* button_msgs_refr = gtk_button_new();    
    GtkWidget* button_msgs_comp = gtk_button_new();
    GtkWidget* button_msgs_from = gtk_button_new();
    
    gtk_widget_set_sensitive(button_msgs_find, FALSE);
    //gtk_widget_set_sensitive(button_msgs_refr, FALSE);
    gtk_widget_set_sensitive(button_msgs_comp, FALSE);
    gtk_widget_set_sensitive(button_msgs_from, FALSE);
    
    image_find = gtk_image_new_from_file(IMG_FIND);
    image_refr = gtk_image_new_from_file(IMG_REFR);
    GtkWidget* image_comp = gtk_image_new_from_file(IMG_COMP);
    GtkWidget* image_from = gtk_image_new_from_file(IMG_FROM);
    
    gtk_container_add (GTK_CONTAINER(button_msgs_find), image_find);
    gtk_container_add (GTK_CONTAINER(button_msgs_refr), image_refr);
    gtk_container_add (GTK_CONTAINER(button_msgs_comp), image_comp);
    gtk_container_add (GTK_CONTAINER(button_msgs_from), image_from);
    
    gtk_box_pack_start (GTK_BOX (box_msgs_tasks), button_msgs_find, TRUE, TRUE, 0); 
    gtk_box_pack_start (GTK_BOX (box_msgs_tasks), button_msgs_refr, TRUE, TRUE, 0); 
    gtk_box_pack_start (GTK_BOX (box_msgs_tasks), button_msgs_comp, TRUE, TRUE, 0); 
    gtk_box_pack_start (GTK_BOX (box_msgs_tasks), button_msgs_from, TRUE, TRUE, 0);
    
    g_signal_connect(G_OBJECT(button_msgs_refr), "clicked", G_CALLBACK(callback_button_messages_update), NULL);   
    
    gtk_box_pack_start (GTK_BOX (box_msgs), box_msgs_list, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (box_msgs), box_msgs_tasks, FALSE, TRUE, 0);
    ui_data->box_messages = box_msgs;
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[2]), ui_data->box_messages, TRUE, TRUE, 0);
    
    /* MESSAGE REPLY FORM */
    ui_data->box_message_reply = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[2]), ui_data->box_message_reply, TRUE, TRUE, 0);
    
    /* END OF MESSAGES */
    
    /* SETTINGS */
    GtkWidget* list_drivers = ui_init_list_drivers();
    GtkWidget* label_services = gtk_label_new("  "STR_SETP);
    GtkWidget* alignment_label_services = gtk_alignment_new(0, 0.5, 0, 0);
    gtk_container_add (GTK_CONTAINER(alignment_label_services), label_services);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[3]), alignment_label_services, FALSE, TRUE, PADDING);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[3]), list_drivers, TRUE, TRUE, 0);
    
    /* END OF SETTINGS */   
    gtk_widget_show_all(ui_data->tasks);
    gtk_widget_hide(GTK_WIDGET(ui_data->box_friend));
    gtk_widget_hide(GTK_WIDGET(ui_data->box_friends_result));
    gtk_widget_hide(GTK_WIDGET(ui_data->box_message_reply));
    
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
static void ui_init_page3()
{
    GtkWidget* hbox = gtk_hbox_new(TRUE, 0);
    GtkWidget* hbox_buttons = gtk_hbox_new(TRUE, 0);
    GtkWidget* vbox = gtk_vbox_new(TRUE, 0);
    
    ui_data->entry_labl = gtk_label_new("label: ");
    ui_data->entry_date = gtk_calendar_new();
    ui_data->entry_text = gtk_entry_new();
    ui_data->entry_comb = gtk_combo_box_new();
    
    GtkWidget* button_cncl = gtk_button_new_with_label(STR_CNCL);
    g_signal_connect(G_OBJECT(button_cncl), "clicked", G_CALLBACK(callback_button_cancel_edit), NULL);
    GtkWidget* button_save = gtk_button_new_with_label(STR_SAVE);

    gtk_box_pack_start (GTK_BOX (vbox), ui_data->entry_date, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), ui_data->entry_text, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), ui_data->entry_comb, TRUE, TRUE, 0);
    
    GtkWidget* alignment_label = gtk_alignment_new(1, 0.5, 0, 0);
    gtk_container_add (GTK_CONTAINER(alignment_label), ui_data->entry_labl);
    gtk_box_pack_start (GTK_BOX (hbox), alignment_label, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox_buttons), button_cncl, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox_buttons), button_save, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->boxes[3]), hbox, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->boxes[3]), hbox_buttons, FALSE, FALSE, 0);
    
    gtk_widget_show_all(ui_data->boxes[3]);
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
static gpointer ui_init_list_drivers()
{
    GtkWidget* button_setup[ui_data->num_srvs];
    char* strings[20];
    int i = 0;
    GtkWidget* icon_service[ui_data->num_srvs];
    GtkWidget* check_service[ui_data->num_srvs];
    GtkWidget* label_service;
    GtkWidget* separator;
    GtkWidget* vbox_services = gtk_vbox_new(FALSE, 0);
    GtkWidget* scrollable = gtk_scrolled_window_new(NULL, NULL); 
    ui_data->list_drvs = scrollable;
    GList* node;
    msa_driver_info* info;
    
    GtkWidget* alignment_list = gtk_alignment_new (0.5, 0.5, 1, 1);
    gtk_alignment_set_padding (GTK_ALIGNMENT(alignment_list), 0, 0, 0, PADDING);
    gtk_container_add (GTK_CONTAINER(alignment_list), scrollable);
    gtk_scrolled_window_add_with_viewport(GTK_WINDOW(scrollable), vbox_services);
    gtk_scrolled_window_set_policy(scrollable, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    //gtk_box_pack_start (GTK_BOX (ui_data->box_service), scrollable, TRUE, TRUE, 0);
    //gtk_box_pack_start (GTK_BOX (ui_data->box_service), hbox, FALSE, TRUE, 0);
    
    ui_data->box_service = gtk_vbox_new(FALSE, 0);
    
    /* LIST ELEMENTS */
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        //for (i = 0; i < ui_data->num_srvs; i++) {
        info = (msa_driver_info*)node->data;
        //sprintf(strings, "service %d", i + 1);
        label_service = gtk_label_new(info->name); 

        if (info->pic == NULL){
            icon_service[i] = gtk_image_new_from_file(IMG_SRVC);
        } else {
            int size;
            guchar* buff = g_base64_decode((gchar*)info->pic, &size);
            GdkPixbufLoader* pbloader;
            pbloader = gdk_pixbuf_loader_new_with_type ("png", NULL);
            gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
            gdk_pixbuf_loader_close (pbloader, NULL);
            icon_service[i] = gtk_image_new_from_pixbuf(gdk_pixbuf_loader_get_pixbuf(pbloader));
        } 
        check_service[i] = gtk_check_button_new ();
        gtk_widget_set_sensitive(GTK_WIDGET(check_service[i]), FALSE);
	if (info->status == ON) {
            gtk_toggle_button_set_active (check_service[i], TRUE);
        } else {
            gtk_toggle_button_set_active (check_service[i], FALSE);
        }
        button_setup[i] = gtk_button_new();
        
        GtkWidget* hbox_service = gtk_hbox_new(FALSE, 0);
        GtkWidget* box_button = gtk_hbox_new(FALSE, 0);        
        
        GtkWidget* alignment_service = gtk_alignment_new (0, 0.5, 1, 1);
        gtk_container_add (GTK_CONTAINER(alignment_service), label_service);
        
        GtkWidget* alignment_check = gtk_alignment_new (0.5, 0.5, 1, 1);
        gtk_alignment_set_padding (GTK_ALIGNMENT(alignment_check), PADDING, PADDING, PADDING, PADDING);
        
        GtkWidget* alignment_icon = gtk_alignment_new (0.5, 0.5, 1, 1);
        gtk_alignment_set_padding (GTK_ALIGNMENT(alignment_icon), PADDING, PADDING, PADDING, PADDING);       
        gtk_container_add (GTK_CONTAINER(alignment_icon), icon_service[i]);
        
        gtk_container_add (GTK_CONTAINER(alignment_check), check_service[i]);
        gtk_container_add (GTK_CONTAINER(button_setup[i]), box_button);
        gtk_box_pack_start (GTK_BOX (box_button), alignment_icon, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (box_button), alignment_service, TRUE, TRUE, 0);
        gtk_box_pack_start (GTK_BOX (hbox_service), alignment_check, FALSE, FALSE, 0);  
        gtk_box_pack_start (GTK_BOX (hbox_service), button_setup[i], TRUE, TRUE, 0);      
        g_signal_connect(G_OBJECT(check_service[i]), "clicked", G_CALLBACK(callback_check_service), i);
        g_signal_connect(G_OBJECT(button_setup[i]), "clicked", G_CALLBACK(callback_button_setup_service), i);
        
        gtk_box_pack_start (GTK_BOX (vbox_services), hbox_service, FALSE, FALSE, 0);
        //if (i + 1 != ui_data->num_srvs){
            separator = gtk_hseparator_new();
            GtkWidget* alignment_separator = gtk_alignment_new (0.5, 0.5, 1, 1);
            gtk_alignment_set_padding (GTK_ALIGNMENT(alignment_separator), PADDING / 2, PADDING / 2, PADDING / 2, 0);
            gtk_container_add (GTK_CONTAINER(alignment_separator), separator);
            gtk_box_pack_start (GTK_BOX(vbox_services), alignment_separator, FALSE, FALSE, PADDING);
        //}
        i++;
        g_print("service added\n");
    }
    //ui_data->entry = gtk_entry_new();
    //gtk_box_pack_start (GTK_BOX (vbox_services), ui_data->entry, TRUE, TRUE, 0);
    
    //gtk_box_pack_start (GTK_BOX (ui_data->boxes[1]), ui_data->box_service, TRUE, TRUE, 0);
    //gtk_widget_show_all(ui_data->boxes[1]);
    return alignment_list;
}


/**
 * @brief tools initialization
 * @param
 * @return  
**/
static void ui_init_tools()
{
    //UIdata* ui_data = ui_data_ptr;
    /* Create new GTK toolbar */
    ui_data->toolbar = gtk_toolbar_new();
    
    /* Set toolbar properties */
    gtk_toolbar_set_orientation(GTK_TOOLBAR(ui_data->toolbar), GTK_ORIENTATION_HORIZONTAL);
    gtk_toolbar_set_style(GTK_TOOLBAR(ui_data->toolbar), GTK_TOOLBAR_BOTH_HORIZ);
    
    /* Make menus and buttons to toolbar: */
    
    /* Create toolitems using defined items from stock */
    ui_data->tool_sepr = gtk_image_new_from_file(IMG_SEPR); //gtk_separator_tool_item_new();
    ui_data->tool_exit = gtk_tool_button_new(gtk_image_new_from_file(IMG_EXIT), STR_EXIT);
    ui_data->tool_full = gtk_tool_button_new(gtk_image_new_from_file(IMG_FULL), STR_FULL);
    ui_data->tool_help = gtk_tool_button_new(gtk_image_new_from_file(IMG_HELP), STR_HELP);
    ui_data->tool_tool = gtk_tool_button_new(gtk_image_new_from_file(IMG_TOOL), STR_TOOL);
    
    //ui_data->tool_full = gtk_toggle_tool_button_new();
    //gtk_container_add(GTK_CONTAINER(ui_data->tool_full), gtk_image_new_from_file(IMG_FULLSCREEN));
    //gtk_box_pack_start (GTK_BOX (ui_data->boxes[0]), ui_data->tool_full, TRUE, TRUE, 0);
    //gtk_widget_show_all(ui_data->boxes[0]);
    //ui_data->tool_exit = gtk_tool_button_new_from_stock(GTK_STOCK_CLOSE);
    //ui_data->tool_help = gtk_tool_button_new_from_stock(GTK_STOCK_HELP);
    //ui_data->tool_tool = gtk_tool_button_new_from_stock(GTK_STOCK_PREFERENCES);
    
    /* Insert items to toolbar */
        //gtk_toolbar_insert(GTK_TOOLBAR(ui_data->toolbar), ui_data->separator_tb1, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(ui_data->toolbar), ui_data->tool_exit, 0);
    gtk_toolbar_insert(GTK_TOOLBAR(ui_data->toolbar), ui_data->tool_full, 0);
    gtk_toolbar_insert(GTK_TOOLBAR(ui_data->toolbar), ui_data->tool_sepr, 0);
    //gtk_toolbar_insert(GTK_TOOLBAR(ui_data->toolbar), ui_data->tool_tool, 0);
    gtk_toolbar_insert(GTK_TOOLBAR(ui_data->toolbar), ui_data->tool_help, 0);
    
    /* Connect signals to buttons */
    g_signal_connect(G_OBJECT(ui_data->tool_full), "clicked", G_CALLBACK(callback_tool_full), NULL);
    g_signal_connect(G_OBJECT(ui_data->tool_help), "clicked", G_CALLBACK(callback_help), NULL);
    g_signal_connect(G_OBJECT(ui_data->tool_tool), "clicked", G_CALLBACK(callback_tool_tool), NULL);
    g_signal_connect(G_OBJECT(ui_data->tool_exit), "clicked", G_CALLBACK(callback_exit), NULL);

    /* Add toolbar to the HildonWindow */
    hildon_window_add_toolbar(ui_data->window, GTK_TOOLBAR(ui_data->toolbar));

    /* Show toolbar */
    gtk_widget_show_all(GTK_WIDGET(ui_data->toolbar));
    gtk_widget_hide(GTK_WIDGET(ui_data->toolbar));
    //gtk_widget_show_all(GTK_WIDGET(ui_data->window));
}

/**
 * @brief menu initialization
 * @param
 * @return  
**/
static void ui_init_menus()
{
    //UIdata*    ui_data = ui_data_ptr;
    /* Create needed handles */
    GtkMenu*   main_menu;
    GtkWidget* extra_menu;
    GtkWidget* separator = NULL;
    GtkWidget* help  = NULL;
    GtkWidget* close = NULL;

    /* Create menu and new menu for submenu in drop down menu */
    main_menu  = GTK_MENU(gtk_menu_new());
    extra_menu = gtk_menu_new();

    /* Create the menu items */
    //ui_data->file_item   = gtk_menu_item_new_with_label("File");
    //ui_data->new_item    = gtk_menu_item_new_with_label("New");
    //ui_data->open_item   = gtk_menu_item_new_with_label("Open");
    //ui_data->save_item   = gtk_menu_item_new_with_label("Save");
    //ui_data->saveas_item = gtk_menu_item_new_with_label("Save As...");
    //ui_data->edit_item   = gtk_menu_item_new_with_label("Edit");
    //ui_data->cut_item    = gtk_menu_item_new_with_label("Cut");
    //ui_data->copy_item   = gtk_menu_item_new_with_label("Copy");
    //ui_data->paste_item  = gtk_menu_item_new_with_label("Paste");

    ui_data->menu_full = gtk_check_menu_item_new_with_label(STR_FULL);
    ui_data->menu_tool = gtk_check_menu_item_new_with_label(STR_TOOL);
    separator          = gtk_separator_menu_item_new();
    ui_data->menu_help = gtk_menu_item_new_with_label(STR_HELP);
    ui_data->menu_exit = gtk_menu_item_new_with_label(STR_EXIT);

    /* Add menu items to right menus */
    //gtk_menu_append( main_menu, ui_data->file_item );
    //gtk_menu_append( extra_menu, ui_data->new_item );
    //gtk_menu_append( extra_menu, ui_data->open_item );
    //gtk_menu_append( extra_menu, ui_data->save_item );
    //gtk_menu_append( extra_menu, ui_data->saveas_item );

    //gtk_menu_append( main_menu, ui_data->edit_item );

    //gtk_menu_append( main_menu, ui_data->sendvia_item );

    //gtk_menu_append( main_menu, ui_data->font_item );
    gtk_menu_append(main_menu, ui_data->menu_full);
    gtk_menu_append(main_menu, ui_data->menu_tool);
    gtk_menu_append(main_menu, separator);
    gtk_menu_append(main_menu, ui_data->menu_help);
    gtk_menu_append(main_menu, ui_data->menu_exit);

    /* Add submenus to the right items */
    //gtk_menu_item_set_submenu(GTK_MENU_ITEM(ui_data->file_item), extra_menu);

    /* Attach the callback functions to the activate signal */
    g_signal_connect(G_OBJECT(ui_data->menu_full), "activate", G_CALLBACK(callback_full), NULL);
    g_signal_connect(G_OBJECT(ui_data->menu_tool), "activate", G_CALLBACK(callback_tool), NULL);
    g_signal_connect(G_OBJECT(ui_data->menu_help), "activate", G_CALLBACK(callback_help), NULL);
    g_signal_connect(G_OBJECT(ui_data->menu_exit), "activate", G_CALLBACK(callback_exit), NULL);

    /* Add menu to HildonWindow */
    hildon_window_set_menu(ui_data->window, main_menu);

    /* We need to show menu items */
    gtk_widget_show_all(GTK_WIDGET(main_menu));
    //gtk_check_menu_item_set_active(ui_data->menu_tool, TRUE);
}

/**
 * @brief help
 * @param
 * @return  
**/
void ui_init_help()
{
    //UIdata*    ui_data = ui_data_ptr;
    HildonWindow* window_help;
    window_help = HILDON_WINDOW(hildon_window_new());
    hildon_program_add_window(ui_data->program, window_help);
    gtk_window_set_title (GTK_WINDOW (window_help), STR_HELP);
    ui_data->window_help = HILDON_WINDOW(window_help);
    //g_print("in ui_init_help: help is %d\n", ui_data->help);
    ui_data->help = TRUE;
    g_signal_connect(G_OBJECT(window_help), "destroy", G_CALLBACK(callback_help_close), NULL);
    
    //FILE* cap_fp;
    //char* new_line;
    //char* cap_string = g_strdup("");
    //int cap_limit = SIZE_HELP;
    /* Check whether the file being opened exists */
    //if ((cap_fp = fopen (TXT_HELP, "r")) != NULL){
        /* Check whether the string was read */
        //while (fgets (new_line, cap_limit, cap_fp) != NULL) {
            //cap_string = g_strdup(g_strconcat(cap_string, new_line, NULL));
	    /* Strip the newline if needed */
            //if ((newline = strrchr (cap_string, '\n')) != NULL) {
            //    *newline = '\0';
            //}
	//}
            GtkWidget* label;
            label = gtk_label_new(STR_ABOUT);
            GtkWidget* box = gtk_vbox_new(TRUE, 0);
	    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	    gtk_label_set_single_line_mode(GTK_LABEL(label), FALSE);
            gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);
            gtk_container_add(GTK_CONTAINER((GtkWidget*)ui_data->window_help), box);
            gtk_widget_show_all((GtkWidget*)ui_data->window_help);
            //g_print(cap_string);
            return;
        
        //g_print("file is read\n");
    //}    
}

