/*
 * ui_callback.h - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Andrey Bogachev
 * 
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _UI_CALLBACK_
#define _UI_CALLBACK_

void callback_full(GtkAction*, gpointer);
void callback_goto(GtkWidget*, int);
void callback_help(GtkAction*, gpointer);
void callback_next(GtkAction*, gpointer);
void callback_tool(GtkAction*, gpointer);
void callback_tool_full(GtkAction*, gpointer);
void callback_tool_tool(GtkAction*, gpointer);
void callback_scrn_stat(gpointer);
void callback_help_close(GtkWidget*, gpointer);

void callback_button_profile_get(GtkWidget*, gpointer);
void callback_button_profile_update(GtkWidget*, gpointer);
void callback_button_profile_save(GtkWidget*, gpointer);

void callback_button_friends_get(GtkWidget*, gpointer);
void callback_button_friends_update(GtkWidget*, gpointer);
void callback_button_friends(GtkWidget*, gpointer);
void callback_button_friends_profile_update(GtkWidget*, gpointer);
void callback_button_friends_profile_join(GtkWidget*, gpointer);
void callback_button_friends_find(GtkWidget*, gpointer);
gpointer ui_init_friend_tools(gpointer);
void callback_friend_send_message(GtkWidget*, gpointer);

void callback_button_friends_page_prev(GtkWidget*, gpointer);
void callback_button_friends_page_next(GtkWidget*, gpointer);
void callback_button_friends_page_frst(GtkWidget*, gpointer);
void callback_button_friends_page_last(GtkWidget*, gpointer);
void callback_button_friends_sort(GtkWidget*, gpointer);
void callback_button_friends_result(GtkWidget*, gpointer);
void callback_friends_join(GtkWidget*, gpointer);

void callback_button_messages_get(GtkWidget*, gpointer);
void callback_button_messages_update(GtkWidget*, gpointer);
void callback_message_reply(GtkWidget*, GdkEventButton*, gpointer);
void callback_message_reply_cancel(GtkWidget*, gpointer);
void callback_message_reply_send(GtkWidget*, gpointer);
void callback_message_reply_entry(GtkWidget*, gpointer);
void callback_message_profile(GtkWidget*, GdkEventButton*, gpointer);
void callback_button_msgs_page_prev(GtkWidget*, gpointer);
void callback_button_msgs_page_next(GtkWidget*, gpointer);

void callback_combo_changed(GtkComboBox*, gpointer);
void callback_combo_msgs_changed(GtkComboBox*, gpointer);

void callback_friend(GtkWidget*, GdkEventButton*, gpointer);
void ui_init_friend_profile(GtkWidget*, gpointer);
gpointer ui_init_message_reply(gpointer);

void callback_button_setup_service(GtkWidget*, int);
void callback_button_cancel_setup_service(GtkWidget*, int);
void callback_button_cancel_edit(GtkWidget*, gpointer);
void callback_button_save_setup_service(GtkWidget*, gpointer);
void callback_detail_edit(GtkWidget*, gpointer);
void callback_date_edit(GtkWidget*, gpointer);
void callback_check_service(GtkWidget*, gpointer);
void callback_exit(GtkAction*, gpointer);
void callback_empty(GtkWidget*,  GdkEventButton*, gpointer);
void callback_button_profile_save_detail(GtkWidget*);
void callback_label_profile_edit(GtkWidget*, gpointer);
void callback_switch (GtkWidget*, gpointer);
void callback_task_switch(GtkWidget*, GtkNotebookPage*, guint, gpointer);

#endif

