/**
 * dispatcher.c, dispatcher_interface.c
 * 
 * This file is part of MSA program
 * 
 * Copyright (C) 2009 Burlak I.L.
 * 
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef _DISPATCHER_H_
#define _DISPATCHER_H_

#include "general.h"
#include "kernel.h"

#include <glib/gprintf.h>
#include <libgnomevfs/gnome-vfs.h>
#include <dlfcn.h>

#include "../msa.h"
#include "../msa_module.h"

#define MODULE_PATH DATADIR"/msa/"
#define G_FILE_ATTRIBUTE_STANDARD_NAME "standard::name" 

/** stacdart function **/
#define MODULE_INIT "msa_module_init"
#define UI_DOWN NULL
#define DB_DOWN NULL
#define KERNEL_SHUTDOWN kernel_shutdown
#define KERNEL_SEND kernel_ext_put_text_data

/** @struct msa_disp_module
 *  @brief msa_modules and inside information
 *  @see msa_module in msa_module.h
 */
typedef struct _disp_msa_module {
    void* handle;
    msa_module* msa_mod;
    gpointer data;
}msa_module_disp;

/** @enum msa_module_type
 *  @brief List of driver status
 *
 *  Currently there are three module types:
 *  DISP_ON - dispatcher ON
 *  DISP_OFF - dispatcher OFF
 */
typedef enum _disp_status {
    DISP_ON = 0,		// Dispatcher ON and ready to work
    DISP_OFF = 1		// In the module there was a critical error and it is switched off
} disp_status;

disp_status msa_disp_status;

int msa_disp_init();

/** internal function **/
static xmlNodePtr msa_disp_get_node_params(xmlNodePtr,char*);
static msa_module_disp* msa_disp_module_new();
static msa_driver_info* msa_driver_info_get(gchar* id);
static int msa_driver_info_new(msa_module* mod); 
static int msa_disp_driver_connect(msa_module_disp*);
static void save_module(msa_module_disp* mod);
static void msa_disp_free(gpointer,gpointer,gpointer);

/** Interface function **/
extern int msa_disp_send_request(xmlChar* target_id, xmlDocPtr msa_ui_request);
extern int msa_module_shutdown();
extern int module_set_settings(msa_driver_info* new_settings);
extern int msa_settings(xmlChar* target_id, xmlDocPtr request);

#ifdef TEST
/** TEST INTERFACE FUNCTION **/
msa_module_disp* test_msa_disp_module_new();
int (*test_send)(xmlDocPtr request, xmlDocPtr* response, msa_driver_info** info); // test function of sending of request
int test_msa_disp_driver_connect(msa_module_disp* mod);
int test_init(int (*_test_send)(xmlDocPtr request, xmlDocPtr* response, msa_driver_info* info));
#endif

#endif



