#About plugins

Plugins in MusiKloud2 are used to provide access to additional services, such as tracks from a website. Installed plugins 
are listed in the application, allowing artists to select them and access the content which they provide.

#Creating a plugin

Creating a MusiKloud2 plugin consists of three steps:

1. Defining the plugin using XML format in a \*.plugin file.
2. Defining the settings (if any) to be displayed in the UI using XML format.
3. Providing an executable to be called by the application.

##Defining a plugin

Plugins are defined using XML, in a file with \*.plugin extension. The plugin definition file can be place either in 
**/opt/musikloud2/plugins** or **~/.config/MusiKloud2/plugins**.

The following nodes must be provided in a plugin definition file:

<table>
    <tr>
        <th>
            Name
        </th>
        <th>
            Description
        </th>
        <th>
            Attributes
        </th>
    </tr>
    <tr>
        <td>
            plugin
        </td>
        <td>
            The root node.
        </td>
        <td>
            <ul>
                <li><b>name</b> - The display name of the plugin.</li>
                <li><b>settings</b> - The path to the declarative settings file (absolute or relative path).</li>
                <li><b>exec</b> - The absolute path to the executable.</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            resources
        </td>
        <td>
            Encapsulates the resource declarations.
        </td>
        <td>
            None.
        </td>
    </tr>
    <tr>
        <td>
            resource
        </td>
        <td>
            Declares a supported resource.
        </td>
        <td>
            <ul>
                <li><b>method</b> - The method supported for this resource. Can be 'get', 'list' or 'search'.</li>
                <li><b>name</b> - The display name for the resource.</li>
                <li><b>type</b> - The resource type. Can be  'category', 'playlist', 'artist' or 'track'.</li>
                <li><b>id</b> - An optional identifier to be passed as the <b>-i</b> argument when calling the 'list' method.</li>
                <li><b>order</b> - The value to be passed as the <b>-o</b> argument when calling the 'search' method.</li>
                <li><b>regexp</b> - The regular expression used to check if a URL is supported by the plugin. If a match 
                is found, the URL will be passed as the <b>-i</b> argument when calling the 'get' method.</li>
            </ul>
        </td>
    </tr>
</table>

###Example

Below is an example of a plugin definition for a plugin named **My Plugin**.

    <plugin name="My Plugin" settings="myplugin.settings" exec="/opt/musikloud2/plugins/myplugin">
        <resources>
            <resource method="list" name="Latest tracks" type="track" id="latest_tracks" />
            <resource method="list" name="Latest playlists" type="playlist" id="latest_playlists" />
            <resource method="list" name="Categories" type="category" id="all_categories" />
            <resource method="list" name="Artists" type="artist" id="all_artists" />
            <resource method="search" name="Tracks" type="track" order="relevance" />
            <resource method="search" name="Playlists" type="playlist" order="relevance" />
            <resource method="get" type="track" regexp="http://api.mywebsite.com/track/w+" />
            <resource method="get" type="playlist" regexp="http://api.mywebsite.com/playlist/w+" />
            <resource method="get" type="artist" regexp="http://api.mywebsite.com/artist/w+" />
        </resources>
    </plugin>

##Defining plugin settings

Plugin settings are defined using XML. The following types are supported:

<table>
    <tr>
        <th>
            Name
        </th>
        <th>
            Description
        </th>
        <th>
            Attributes
        </th>
    </tr>
    <tr>
        <td>
            boolean
        </td>
        <td>
            A boolean type with value true or false, represented in the UI by a checkbox or switch.
        </td>
        <td>
            <ul>
                <li><b>title</b> - The display name used in the text label.</li>
                <li><b>key</b> - The key used for storing the value.</li>
                <li><b>default</b> - The default value used when none has been set.</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            group
        </td>
        <td>
            A string providing a group heading, represented in the UI as a bold text label or similar.
        </td>
        <td>
            <ul>
                <li><b>title</b> - The display name used in the text label.</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            integer
        </td>
        <td>
            A number, represented in the UI by a spinbox or slider.
        </td>
        <td>
            <ul>
                <li><b>title</b> - The display name used in the text label.</li>
                <li><b>key</b> - The key used for storing the value.</li>
                <li><b>min</b> - The minimum value that can be set.</li>
                <li><b>max</b> - The maximium value that can be set.</li>
                <li><b>step</b> - The step size used when incrementing/decrementing the value.</li>
                <li><b>default</b> - The default value used when none has been set.</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            list
        </td>
        <td>
            An array of values from which a value can be chosen, represented in the UI by a combobox or similar.
        </td>
        <td>
            <ul>
                <li><b>title</b> - The display name used in the text label.</li>
                <li><b>key</b> - The key used for storing the value.</li>
                <li><b>default</b> - The default value used when none has been set.</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            element
        </td>
        <td>
            An element in a list. Can only be used as a child of a list.
        </td>
        <td>
            <ul>
                <li><b>name</b> - The display name.</li>
                <li><b>value</b> - The value.</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            text
        </td>
        <td>
            A string, represented in the artist interface by a textfield.
        </td>
        <td>
            <ul>
                <li><b>title</b> - The display name used in the text label.</li>
                <li><b>key</b> - The key used for storing the value.</li>
                <li><b>default</b> - The default value used when none has been set.</li>
            </ul>
        </td>
    </tr>
</table>

###Example

Below is an example settings file for **My Plugin**.

    <settings title="My Plugin">
        <group title="Group one" />
        <boolean title="True or false" key="trueOrFalse" default="true" />
        <integer title="Pick a number from 1 to 5" key="oneToFive" min="1" max="5" step="1" default="1" />
        <group title="Group two" />
        <list title="Pick a number from 1 to 5" key="oneToFive" default="1">
            <element name="One" value="1" />
            <element name="Two" value="2" />
            <element name="Three" value="3" />
            <element name="Four" value="4" />
            <element name="Five" value="5" />
        </list>
        <text title="Enter a string" key="aString" default="Hello" />
    </settings>

##Providing an executable

The only requirement of a plugin executable is that is accepts certain arguments and writes an appropriate response 
to STDOUT in JSON format. It is therefore possible to create an executable using any language you prefer.

The following arguments are used when calling an executable:

<table>
    <tr>
        <th>
            Name
        </th>
        <th>
            Description
        </th>
        <th>
            Possible values
        </th>
    </tr>
    <tr>
        <td>
            -m
        </td>
        <td>
            The method called by the application.
        </td>
        <td>
            <ul>
                <li>get</li>
                <li>list</li>
                <li>search</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            -r
        </td>
        <td>
            The resource type requested by the application.
        </td>
        <td>
            <ul>
                <li>category</li>
                <li>playlist</li>
                <li>stream</li>
                <li>artist</li>
                <li>track</li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            -i
        </td>
        <td>
            The identifier for the requested resource. Used for calls to 'get' and 'list'.
        </td>
        <td>
            A string value. The value passed will be either one of those declared in the plugin definition file, or 
            one provided by the executable in the JSON response to a method call.
        </td>
    </tr>
    <tr>
        <td>
            -q
        </td>
        <td>
            The search query string. Used for calls to 'search'.
        </td>
        <td>
            A string value.
        </td>
    </tr>
    <tr>
        <td>
            -o
        </td>
        <td>
            The search sort order. Used for calls to 'search'.
        </td>
        <td>
            A string value. The value passed will be one of those declared in the plugin definition file.
        </td>
    </tr>
</table>

###Output format

MusiKloud2 expects the executable to provide a response to method calls in JSON format, by writing the response to STDOUT. 
The values to be included in the response depend on both the method called and the resource type:

<table>
    <tr>
        <th>
            Method
        </th>
        <th>
            Response (success)
        </th>
        <th>
            Response (error)
        </th>
    </tr>
    <tr>
        <td>
            get
        </td>
        <td>
            { &lt;resource&gt; }
        </td>
        <td>
            { "error": &lt;error_string&gt; }
        </td>
    </tr>
    <tr>
        <td>
            list
        </td>
        <td>
            { "next": &lt;id_for_next_page_if_any&gt;, "items": &lt;array_of_resource&gt; }
        </td>
        <td>
            { "error": &lt;error_string&gt; }
        </td>
    </tr>
    <tr>
        <td>
            search
        </td>
        <td>
            { "next": &lt;id_for_next_page_if_any&gt;, "items": &lt;array_of_resource&gt; }
        </td>
        <td>
            { "error": &lt;error_string&gt; }
        </td>
    </tr>
</table>

##Resource types

###Category

<table>
    <tr>
        <th>
            Attribute
        </th>
        <th>
            Description
        </th>
    </tr>
    <tr>
        <td>
            id
        </td>
        <td>
            The resource identifier. This will be used to retrieve a list of tracks belonging to the category.
        </td>
    </tr>
    <tr>
        <td>
            title
        </td>
        <td>
            The display title of the category.
        </td>
    </tr>
</table>

###Playlist

<table>
    <tr>
        <th>
            Attribute
        </th>
        <th>
            Description
        </th>
    </tr>
    <tr>
        <td>
            artist
        </td>
        <td>
            The name of the artist that created the playlist. Can be empty.
        </td>
    </tr>
    <tr>
        <td>
            artistId
        </td>
        <td>
            The id of the artist that created the playlist. Can be empty.
        </td>
    </tr>
    <tr>
        <td>
            date
        </td>
        <td>
            The created date of the playlist formatted as a human-readable string.
        </td>
    </tr>
    <tr>
        <td>
            description
        </td>
        <td>
            The playlist description. Can be empty.
        </td>
    </tr>
    <tr>
        <td>
            duration
        </td>
        <td>
            The playlist duration as a string in format [hours:]minutes:seconds or in milliseconds.
        </td>
    </tr>
    <tr>
        <td>
            genre
        </td>
        <td>
            The track genre.
        </td>
    </tr>
    <tr>
        <td>
            id
        </td>
        <td>
            The resource identifier. This will be used to retrieve a list of tracks belonging to the category.
        </td>
    </tr>
    <tr>
        <td>
            largeThumbnailUrl
        </td>
        <td>
            The URL to a large thumbnail. Re-use thumbnailUrl if no larger thumbnail is available.
        </td>
    </tr>
    <tr>
        <td>
            thumbnailUrl
        </td>
        <td>
            The URL to a thumbnail for the playlist.
        </td>
    </tr>
    <tr>
        <td>
            title
        </td>
        <td>
            The display title of the playlist.
        </td>
    </tr>
</table>

###Artist

<table>
    <tr>
        <th>
            Attribute
        </th>
        <th>
            Description
        </th>
    </tr>
    <tr>
        <td>
            description
        </td>
        <td>
            The artist description. Can be empty.
        </td>
    </tr>
    <tr>
        <td>
            id
        </td>
        <td>
            The resource identifier. This will be used to retrieve a list of tracks belonging to the artist.
        </td>
    </tr>
    <tr>
        <td>
            largeThumbnailUrl
        </td>
        <td>
            The URL to a large thumbnail. Re-use thumbnailUrl if no larger thumbnail is available.
        </td>
    </tr>
    <tr>
        <td>
            name
        </td>
        <td>
            The name of the artist.
        </td>
    </tr>
    <tr>
        <td>
            thumbnailUrl
        </td>
        <td>
            The URL to a thumbnail for the artist.
        </td>
    </tr>
</table>

###Stream

<table>
    <tr>
        <th>
            Attribute
        </th>
        <th>
            Description
        </th>
    </tr>
    <tr>
        <td>
            description
        </td>
        <td>
            The track stream description, for example the codec.
        </td>
    </tr>
    <tr>
        <td>
            ext
        </td>
        <td>
            The file extension.
        </td>
    </tr>
    <tr>
        <td>
            id
        </td>
        <td>
            The resource identifier.
        </td>
    </tr>
    <tr>
        <td>
            url
        </td>
        <td>
            The URL to the track stream, used for playback/download.
        </td>
    </tr>
</table>

###Track

<table>
    <tr>
        <th>
            Attribute
        </th>
        <th>
            Description
        </th>
    </tr>
    <tr>
        <td>
            artist
        </td>
        <td>
            The name of the artist that created the track. Can be empty.
        </td>
    </tr>
    <tr>
        <td>
            artistId
        </td>
        <td>
            The id of the artist that created the track. Can be empty.
        </td>
    </tr>
    <tr>
        <td>
            date
        </td>
        <td>
            The created date of the track formatted as a human-readable string.
        </td>
    </tr>
    <tr>
        <td>
            description
        </td>
        <td>
            The track description. Can be empty.
        </td>
    </tr>
    <tr>
        <td>
            duration
        </td>
        <td>
            The track duration as a string in format [hours:]minutes:seconds or in milliseconds.
        </td>
    </tr>
    <tr>
        <td>
            format
        </td>
        <td>
            The track audio format, e.g. MP3.
        </td>
    </tr>
    <tr>
        <td>
            genre
        </td>
        <td>
            The track genre.
        </td>
    </tr>
    <tr>
        <td>
            id
        </td>
        <td>
            The resource identifier. This will be used to retrieve a list of related tracks.
        </td>
    </tr>
    <tr>
        <td>
            largeThumbnailUrl
        </td>
        <td>
            The URL to a large thumbnail. Re-use thumbnailUrl if no larger thumbnail is available.
        </td>
    </tr>
    <tr>
        <td>
            size
        </td>
        <td>
            The track size as a string or in bytes.
        </td>
    </tr>
    <tr>
        <td>
            streamUrl
        </td>
        <td>
            The URL to the track stream. If specified, the application will use this when playing a track, instead of 
            requesting a list of streams.
        </td>
    </tr>
    <tr>
        <td>
            thumbnailUrl
        </td>
        <td>
            The URL to a thumbnail for the track.
        </td>
    </tr>
    <tr>
        <td>
            title
        </td>
        <td>
            The display title of the track.
        </td>
    </tr>
    <tr>
        <td>
            url
        </td>
        <td>
            The URL of the track. Used for sharing features.
        </td>
    </tr>
</table>

###Examples

Method call:

    /opt/musikloud2/plugins/myplugin -m list -r category -i categories

Response:

    {
        "next": "http://api.mywebsite.com/categories?page=2",
        "items": [
            {
                "id": "abc123",
                "title": "Some category"
            },
            
            {
                "id": "xyz456",
                "title": "Another category"
            }
        ]
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m get -r playlist -i http://api.mywebsite.com/playlist/abc123
    
Response:

    {
        "date": "08 Jun 2015",
        "description": "Some cool story about this playlist.",
        "id": "abc123",
        "largeThumbnailUrl": "http://static.mywebsite.com/images/abc123_large.jpg",
        "thumbnailUrl": "http://static.mywebsite.com/images/abc123.jpg",
        "title": "Some cool playlist",
        "url": "http://api.mywebsite.com/playlist/abc123",
        "artistId": "xyz456",
        "artistname": "Some guy"
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m list -r playlist -i latest_playlists

Response:

    {
        "next": "http://api.mywebsite.com/latest_playlists?page=2",
        "items": [
            { <playlist_1> },
            { <playlist_2> }
        ]
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m search -r playlists -q 'cool playlists' -o relevance

Response:

    {
        "next": "http://api.mywebsite.com/search?r=playlist&q=cool+playlists&o=relevance&page=2",
        "items": [
            { <playlist_1> },
            { <playlist_2> }
        ]
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m list -r stream -i http://api.mywebsite.com/track/abc123

Response:

    {
        "items": [
            {
                "description": "FLAC stream",
                "extension": "flac"
                "id": "abc123",
                "url": "http://static.mywebsite.com/streams/flac/abc123.flac",
            },
            
            {
                "description": "128kb MP3 stream",
                "extension": "mp3",
                "url": "http://static.mywebsite.com/streams/mp3/abc123.mp3",
            }
        ]
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m get -r artist -i http://api.mywebsite.com/artist/abc123
    
Response:

    {
        "description": "Some cool story about this artist.",
        "id": "abc123",
        "largeThumbnailUrl": "http://static.mywebsite.com/images/abc123_large.jpg",
        "thumbnailUrl": "http://static.mywebsite.com/images/abc123.jpg",
        "name": "Some guy"
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m list -r artist -i all_artists

Response:

    {
        "next": "http://api.mywebsite.com/all_artists?page=2",
        "items": [
            { <artist_1> },
            { <artist_2> }
        ]
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m search -r artist -q 'cool artists' -o popular

Response:

    {
        "next": "http://api.mywebsite.com/search?r=artist&q=cool+artists&o=popular&page=2",
        "items": [
            { <artist_1> },
            { <artist_2> }
        ]
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m get -r track -i http://api.mywebsite.com/track/abc123
    
Response:

    {
        "date": "08 Jun 2015",
        "description": "Some cool story about this track.",
        "duration": "05:00",
        "id": "abc123",
        "largeThumbnailUrl": "http://static.mywebsite.com/images/abc123_large.jpg",
        "streamUrl": "http://static.mywebsite.com/streams/abc123.mp4",
        "thumbnailUrl": "http://static.mywebsite.com/images/abc123.jpg",
        "title": "Some cool track",
        "url": "http://api.mywebsite.com/track/abc123",
        "artistId": "xyz456",
        "artistname": "Some guy"
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m list -r track -i latest_tracks

Response:

    {
        "next": "http://api.mywebsite.com/latest_tracks?page=2",
        "items": [
            { <track_1> },
            { <track_2> }
        ]
    }

Method call:

    /opt/musikloud2/plugins/myplugin -m search -r track -q 'cool tracks' -o relevance

Response:

    {
        "next": "http://api.mywebsite.com/search?r=track&q=cool+tracks&o=relevance&page=2",
        "items": [
            { <track_1> },
            { <track_2> }
        ]
    }
