#ifndef WINDOWSTACK_H
#define WINDOWSTACK_H

#include <QObject>

class StackedWindow;

class WindowStack : public QObject
{
    Q_OBJECT

public:
    explicit WindowStack(QObject *parent = 0);
    StackedWindow* currentWindow() const;
    StackedWindow* rootWindow() const;

    static WindowStack* instance();
        
public slots:
    void addWindowToStack(StackedWindow *window);
    void removeWindowFromStack(StackedWindow *window);
    void unwindWindowStack();

signals:
    void currentWindowChanged(StackedWindow *window);
    
private:
    static WindowStack* self;
    QList<StackedWindow*> m_windowStack;
};

#endif // WINDOWSTACK_H
