#include "windowstack.h"
#include "stackedwindow.h"

WindowStack* WindowStack::self = 0;

WindowStack::WindowStack(QObject *parent) :
    QObject(parent)
{
    if (!self) {
        self = this;
    }
}

WindowStack*  WindowStack::instance() {
    return !self ? new WindowStack : self;
}

StackedWindow* WindowStack::currentWindow() const {
    return m_windowStack.isEmpty() ? 0 : m_windowStack.last();
}

StackedWindow* WindowStack::rootWindow() const {
    return m_windowStack.isEmpty() ? 0 : m_windowStack.first();
}

void WindowStack::addWindowToStack(StackedWindow *window) {
    m_windowStack.append(window);
    emit currentWindowChanged(this->currentWindow());
}

void WindowStack::removeWindowFromStack(StackedWindow *window) {
    m_windowStack.removeOne(window);
    emit currentWindowChanged(this->currentWindow());
}

void WindowStack::unwindWindowStack() {
    for (int i = m_windowStack.size() - 1; i > 0; i--) {
        m_windowStack.at(i)->close();
    }

    emit currentWindowChanged(this->currentWindow());
}
