#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "abstractdialog.h"

class NetworkProxyDialog;
class MediaPlayerSelector;
class DownloadFormatSelector;
class ConcurrentTransfersSelector;
class ScreenOrientationSelector;
class LanguageSelector;
class QCheckBox;
class QLineEdit;
class QScrollArea;
class QDialogButtonBox;
class QGridLayout;
class QMaemo5ValueButton;

class SettingsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);

private slots:
    void saveSettings();
    void showFileDialog();
    void showNetworkProxyDialog();
    void onMediaPlayerChanged(const QString &player);

private:
    void loadSettings();
    void setLandscapeLayout();
    void setPortraitLayout();
    void scheduleEvents();
    void clearEvents();
    
private:
    QCheckBox *m_archiveCheckbox;
    QCheckBox *m_scrobbleCheckbox;
    QCheckBox *m_subfoldersCheckbox;
    QCheckBox *m_transferStatusCheckbox;
    QCheckBox *m_eventFeedCheckbox;
    QCheckBox *m_clipboardCheckbox;
    QPushButton *m_proxyButton;
    QMaemo5ValueButton *m_downloadFolderSelector;
    QString m_downloadPath;
    MediaPlayerSelector *m_mediaPlayerSelector;
    DownloadFormatSelector *m_downloadFormatSelector;
    ConcurrentTransfersSelector *m_concurrentSelector;
    ScreenOrientationSelector *m_orientationSelector;
    LanguageSelector *m_languageSelector;
    QLineEdit *m_mediaPlayerCommandEdit;
    QDialogButtonBox *m_buttonBox;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
    NetworkProxyDialog *m_proxyDialog;
    bool m_eventFeedEnabled;
};

#endif // SETTINGSDIALOG_H
