#include "playbackqueuewindow.h"
#include "trackinfowindow.h"
#include "tracklistdelegate.h"
#include "trackselectionwindow.h"
#include "nowplayingwindow.h"
#include "../base/soundcloud.h"
#include "../base/settings.h"
#include "../base/transfermanager.h"
#include "../base/playbacklistmodel.h"
#include "windowstack.h"
#include "../base/tracklauncher.h"
#include "../mediaplayer/mobility/mediaplayer.h"
#include "listview.h"
#include <QAction>
#include <QLabel>
#include <QMenuBar>
#include <QMaemo5Style>

PlaybackQueueWindow::PlaybackQueueWindow(QWidget *parent) :
    StackedWindow(parent),
    m_listView(new ListView(this)),
    m_addToFavouritesAction(this->menuBar()->addAction(tr("Add to favourites"), this, SLOT(addTracksToFavourites()))),
    m_deleteFromQueueAction(this->menuBar()->addAction(tr("Delete from playback queue"), this, SLOT(deleteTracksFromQueue()))),
    m_trackDownloadAction(this->menuBar()->addAction(tr("Download"), this, SLOT(addTrackDownloads()))),
    m_contextMenu(new QMenu(this)),
    m_favouritesContextAction(m_contextMenu->addAction(tr("Add to favourites"), this, SLOT(toggleFavourite()))),
    m_deleteFromQueueContextAction(m_contextMenu->addAction(tr("Delete from playback queue"), this, SLOT(deleteTrackFromQueue()))),
    m_trackDownloadContextAction(m_contextMenu->addAction(tr("Download"), this, SLOT(addTrackDownload()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No tracks queued")), this))
{
    this->setWindowTitle(tr("Queue"));
    this->setCentralWidget(m_listView);

    TrackListDelegate *delegate = new TrackListDelegate(m_listView);

    m_listView->setModel(PlaybackListModel::playbackQueue());
    m_listView->setItemDelegate(delegate);
    m_noResultsLabel->hide();

    this->connect(PlaybackListModel::playbackQueue(), SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(delegate, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(delegate, SIGNAL(play(QModelIndex)), this, SLOT(playTrack(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));

    this->onCountChanged(PlaybackListModel::playbackQueue()->rowCount());
    this->onOrientationChanged();
}

void PlaybackQueueWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void PlaybackQueueWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void PlaybackQueueWindow::setMenuActions() {
    m_addToFavouritesAction->setEnabled(SoundCloud::instance()->userSignedIn());
    m_favouritesContextAction->setVisible(SoundCloud::instance()->userSignedIn());
}

void PlaybackQueueWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void PlaybackQueueWindow::addTracksToFavourites() {
//    TrackSelectionWindow *window = new TrackSelectionWindow(PlaybackListModel::playbackQueue(), tr("Add to favourites"), SLOT(addTracksToFavourites()), this);
//    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
//    window->show();
}

void PlaybackQueueWindow::addTrackDownloads() {
//    TrackSelectionWindow *window = new TrackSelectionWindow(PlaybackListModel::playbackQueue(), tr("Download"), SLOT(addTrackDownloads()), this);
//    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
//    window->show();
}

void PlaybackQueueWindow::deleteTracksFromQueue() {
//    TrackSelectionWindow *window = new TrackSelectionWindow(PlaybackListModel::playbackQueue(), tr("Add to queue"), SLOT(queueTracks()), this);
//    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
//    window->show();
}

void PlaybackQueueWindow::showContextMenu(const QPoint &pos) {
    if (PlaybackListModel::playbackQueue()->data(m_listView->currentIndex(), PlaybackListModel::FavouriteRole).toBool()) {
        m_favouritesContextAction->setText(tr("Delete from favourites"));
    }
    else {
        m_favouritesContextAction->setText(tr("Add to favourites"));
    }

    m_contextMenu->popup(pos, m_favouritesContextAction);
}

void PlaybackQueueWindow::toggleFavourite() {
    if (PlaybackListModel::playbackQueue()->data(m_listView->currentIndex(), PlaybackListModel::FavouriteRole).toBool()) {
        SoundCloud::instance()->deleteFromFavourites(QStringList(PlaybackListModel::playbackQueue()->data(m_listView->currentIndex(), PlaybackListModel::IdRole).toString()));
    }
    else {
        SoundCloud::instance()->addToFavourites(QStringList(PlaybackListModel::playbackQueue()->data(m_listView->currentIndex(), PlaybackListModel::IdRole).toString()));
    }
}

void PlaybackQueueWindow::addTrackDownload() {
    TransferManager::instance()->addDownloadTransfer(PlaybackListModel::playbackQueue()->get(m_listView->currentIndex().row()));
}

void PlaybackQueueWindow::deleteTrackFromQueue() {
    PlaybackListModel::playbackQueue()->removeTrack(m_listView->currentIndex().row());
}

void PlaybackQueueWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showTrackInfo(PlaybackListModel::playbackQueue()->get(index.row()));
    }
}

void PlaybackQueueWindow::showTrackInfo(QSharedPointer<TrackItem> track) {
    TrackInfoWindow *window = new TrackInfoWindow(track, this);
    window->show();
}

void PlaybackQueueWindow::playTrack(const QModelIndex &index) {
    if (Settings::instance()->mediaPlayer() == "musikloud") {
        MediaPlayer::instance()->playTrack(PlaybackListModel::playbackQueue()->get(index.row()));
        NowPlayingWindow *window = new NowPlayingWindow(this);
        window->show();
    }
    else {
        TrackLauncher::launchTrack(SoundCloud::instance()->getStreamUrl(index.data(PlaybackListModel::StreamUrlRole).toUrl()));
    }
}
