#include "navbutton.h"
#include <QPainter>
#include <QtCore/qmath.h>

NavButton::NavButton(const QString &text, const QString &iconSource, QWidget *parent) :
    QAbstractButton(parent),
    m_icon(QImage(iconSource))
{
    this->setText(text);
    this->setFixedSize(160, 140);
}

void NavButton::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event)

    QPainter painter(this);
    QFont font;

    font.setPixelSize(20);
    painter.setFont(font);

    if (this->isDown()) {
        painter.setOpacity(0.5);
    }

    if (!m_icon.isNull()) {
        QRect imageRect = this->rect();

        imageRect.setTopLeft(QPoint(imageRect.left() + qFloor(m_icon.size().width() / 2), imageRect.top() + 10));
        imageRect.setSize(m_icon.size());

        painter.drawImage(imageRect, m_icon);
    }

    if (!this->text().isEmpty()) {
        QRect textRect = this->rect();
        textRect.setTop(textRect.top() + 100);

        painter.drawText(textRect, Qt::AlignCenter, this->text());
    }
}
