#include "archivetrackdelegate.h"
#include "../base/tracklistmodel.h"
#include <QPainter>
#include <QMouseEvent>
#include <QMaemo5Style>
#include <QStaticText>

ArchiveTrackDelegate::ArchiveTrackDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void ArchiveTrackDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if (((option.state) & (QStyle::State_Selected)) && (!index.data(TrackListModel::ThumbnailPressedRole).toBool())) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

    QImage thumbnail = index.data(TrackListModel::ThumbnailRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/64x64/hildon/mediaplayer_default_album.png");
    }

    if (index.data(TrackListModel::ThumbnailPressedRole).toBool()) {
        painter->setOpacity(0.5);
    }

    painter->drawImage(iconRect, thumbnail);
    painter->setOpacity(1);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(textRect.left() + 80, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - 8);

    QStaticText titleText(index.data(TrackListModel::TitleRole).toString());
    QTextOption textOption;
    textOption.setWrapMode(QTextOption::NoWrap);
    titleText.setTextOption(textOption);
    titleText.setTextWidth(textRect.width());

    painter->setClipRect(textRect);
    painter->drawStaticText(textRect.topLeft(), titleText);

    textRect.moveTop(textRect.bottom());

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setClipRect(textRect);
    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, QString("%1 - %2").arg(index.data(TrackListModel::DateRole).toString()).arg(index.data(TrackListModel::ArtistRole).toString()));
    painter->restore();
}

bool ArchiveTrackDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index) {
    if (event->type() == QEvent::MouseButtonPress) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        QRect iconRect = option.rect;
        iconRect.setSize(QSize(64, 64));
        iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

        if (iconRect.contains(mouse->pos())) {
            return model->setData(index, index.row(), TrackListModel::ThumbnailPressedRole);
        }

        return true;
    }

    if (event->type() == QEvent::MouseButtonRelease) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        if (index.data(TrackListModel::ThumbnailPressedRole).toBool()) {
            QRect iconRect = option.rect;
            iconRect.setSize(QSize(64, 64));
            iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

            if (iconRect.contains(mouse->pos())) {
                emit play(index);
            }
        }
        else if (option.rect.contains(mouse->pos())) {
            emit clicked(index);
        }

        return model->setData(index, -1, TrackListModel::ThumbnailPressedRole);
    }

    return false;
}

QSize ArchiveTrackDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
