#ifndef VOLUMECONTROL_H
#define VOLUMECONTROL_H

#include <QAbstractButton>

class QSlider;
class QLabel;
class QGridLayout;

class VolumeButton : public QAbstractButton
{
    Q_OBJECT

public:
    enum Role {
        Up = 0,
        Down,
        Mute
    };

    explicit VolumeButton(Role buttonRole, QWidget *parent = 0);
    ~VolumeButton();

protected:
    void paintEvent(QPaintEvent *event);

private:
    Role m_role;
};

class VolumeControl : public QWidget
{
    Q_OBJECT

public:
    explicit VolumeControl(QWidget *parent = 0);
    ~VolumeControl();

    qreal value() const;
    bool muted() const;

public slots:
    void setValue(qreal value);
    void setMuted(bool muted);

private slots:
    void onSliderValueChanged(int value);
    void onVolumeUpClicked();
    void onVolumeDownClicked();

signals:
    void pressed();
    void released();
    void valueChanged(qreal value);
    void mutedChanged(bool muted);
    
private:
    QSlider *m_slider;
    VolumeButton *m_upButton;
    VolumeButton *m_downButton;
    VolumeButton *m_muteButton;
    QGridLayout *m_grid;
    bool m_min;
    bool m_max;
};

#endif // VOLUMECONTROL_H
